/*
 * Decompiled with CFR 0.152.
 */
package imager.components.dialogs;

import imager.ImagerGlobal;
import imager.components.JTableComponent;
import imager.components.JTableModel;
import imager.components.dialogs.JPhotoDialog;
import imager.exif.ExifDisplayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ExifDisplayDialog
extends JPhotoDialog {
    Component owner;
    ExifDisplayer exifDisplayer;
    JFileChooser saveFileChooser;
    String filename;
    JButton closeButton;
    JButton htmlButton;
    JButton xmlButton;
    JButton textButton;
    JTableComponent exifTable;
    JTableModel exifTableModel;

    public ExifDisplayDialog(JFrame jFrame, ExifDisplayer exifDisplayer, Object[][] objectArray, String string) {
        super(jFrame, "Exif Info for " + string, true);
        this.owner = jFrame;
        this.exifDisplayer = exifDisplayer;
        int n = string.indexOf(46);
        this.filename = n != -1 ? string.substring(0, n) : string;
        this.saveFileChooser = new JFileChooser();
        String[] stringArray = new String[]{" ", "Name", "Description"};
        this.exifTableModel = new JTableModel(objectArray, stringArray);
        this.exifTable = new JTableComponent(this.exifTableModel);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.htmlButton = new JButton("Generate HTML");
        this.htmlButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExifDisplayDialog.this.U_generateHtml();
            }
        });
        jPanel.add(this.htmlButton);
        this.xmlButton = new JButton("Generate XML");
        this.xmlButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExifDisplayDialog.this.u_generateXml();
            }
        });
        jPanel.add(this.xmlButton);
        this.textButton = new JButton("Generate Text");
        this.textButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExifDisplayDialog.this.V_generateText();
            }
        });
        jPanel.add(this.textButton);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExifDisplayDialog.this.setVisible(false);
            }
        });
        jPanel.add(this.closeButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.getContentPane().add(this.exifTable);
        this.setSize(500, 500);
        this.setLocationRelativeTo(jFrame);
    }

    public void addData(Object[][] objectArray) {
        this.exifTableModel.clearTableData();
        int n = 0;
        while (n < objectArray.length) {
            this.exifTableModel.addRow(objectArray[n]);
            ++n;
        }
    }

    private void U_generateHtml() {
        this.saveFileChooser.setFileFilter(ImagerGlobal.htmlFileFilter);
        this.saveFileChooser.setSelectedFile(new File(String.valueOf(this.filename) + ".htm"));
        if (this.saveFileChooser.showSaveDialog(this.owner) == 0) {
            String string = this.saveFileChooser.getSelectedFile().getAbsolutePath();
            if (!string.endsWith(".htm") && !string.endsWith(".html")) {
                string = String.valueOf(string) + ".htm";
            }
            this.exifDisplayer.generateExifHTML(string);
        }
    }

    private void u_generateXml() {
        this.saveFileChooser.setFileFilter(ImagerGlobal.xmlFileFilter);
        this.saveFileChooser.setSelectedFile(new File(String.valueOf(this.filename) + ".xml"));
        if (this.saveFileChooser.showSaveDialog(this.owner) == 0) {
            String string = this.saveFileChooser.getSelectedFile().getAbsolutePath();
            if (!string.endsWith(".xml")) {
                string = String.valueOf(string) + ".xml";
            }
            this.exifDisplayer.generateExifHTML(string);
        }
    }

    private void V_generateText() {
        this.saveFileChooser.setFileFilter(ImagerGlobal.textFileFilter);
        this.saveFileChooser.setSelectedFile(new File(String.valueOf(this.filename) + ".txt"));
        if (this.saveFileChooser.showSaveDialog(this.owner) == 0) {
            String string = this.saveFileChooser.getSelectedFile().getAbsolutePath();
            if (!string.endsWith("txt")) {
                string = String.valueOf(string) + "txt";
            }
            this.exifDisplayer.generateExifHTML(string);
        }
    }
}

