/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.ICO;

import imager.imagefileio.ICO.ICOBitmap;
import imager.imagefileio.ICO.ICOBitmap1;
import imager.imagefileio.ICO.ICOBitmap24;
import imager.imagefileio.ICO.ICOBitmap32;
import imager.imagefileio.ICO.ICOBitmap4;
import imager.imagefileio.ICO.ICOBitmap8;
import imager.imagefileio.ICO.ICOEntry;
import imager.imagefileio.ICO.ICOHeader;
import imager.imagefileio.ICO.general.FileDecoder;
import imager.imagefileio.ICO.general.FileDecoderImpl;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;

public class ICOFile {
    private static int UU_fsVerbosity = 0;
    private String UV_fFileName;
    private int Uu_fReserved;
    private int Uv_fType;
    private int VU_fImageCount;
    private List VV_fEntries = new ArrayList();
    private static int Vu_fsFrames = 0;

    public ICOFile(String string) throws IOException {
        this.UV_fFileName = string;
        this.read(new FileInputStream(this.UV_fFileName));
    }

    public ICOFile(InputStream inputStream) throws IOException {
        this.UV_fFileName = "[from stream]";
        this.read(inputStream);
    }

    public ICOFile(URL uRL) throws IOException {
        this.UV_fFileName = uRL.toString();
        this.read(uRL.openStream());
    }

    public ICOFile(byte[] byArray) throws IOException {
        this.UV_fFileName = "[from buffer]";
        this.read(new ByteArrayInputStream(byArray));
    }

    public void read(InputStream inputStream) throws IOException {
        this.read(new FileDecoderImpl(inputStream));
    }

    public ICOFile(FileDecoder fileDecoder) throws IOException {
        this.read(fileDecoder);
    }

    public void read(FileDecoder fileDecoder) throws IOException {
        ICOEntry iCOEntry;
        fileDecoder.setEndianness(1);
        this.Uu_fReserved = fileDecoder.readUInt2();
        this.Uv_fType = fileDecoder.readUInt2();
        this.VU_fImageCount = fileDecoder.readUInt2();
        ICOFile.log(2, "Images found: " + this.VU_fImageCount);
        ICOEntry[] iCOEntryArray = new ICOEntry[this.VU_fImageCount];
        int n = 0;
        while (n < this.VU_fImageCount) {
            iCOEntryArray[n] = iCOEntry = new ICOEntry(fileDecoder);
            ++n;
        }
        n = 0;
        while (n < this.VU_fImageCount) {
            block15: {
                try {
                    iCOEntry = iCOEntryArray[n];
                    if (fileDecoder.getPos() != iCOEntry.getOffset()) {
                        ICOFile.log(1, "FYI: Skipping some fluff, " + (iCOEntry.getOffset() - fileDecoder.getPos()));
                        fileDecoder.fastForward(iCOEntry.getOffset());
                    }
                    ICOHeader iCOHeader = new ICOHeader(fileDecoder);
                    iCOEntry.setHeader(iCOHeader);
                    if (iCOHeader.getCompression() != 0) {
                        System.err.println("Compression type not supported: " + iCOHeader.getCompression());
                        break block15;
                    }
                    int n2 = iCOEntry.getBitCount();
                    ICOBitmap iCOBitmap = null;
                    switch (n2) {
                        case 1: {
                            iCOBitmap = new ICOBitmap1(iCOEntry);
                            break;
                        }
                        case 4: {
                            iCOBitmap = new ICOBitmap4(iCOEntry);
                            break;
                        }
                        case 8: {
                            iCOBitmap = new ICOBitmap8(iCOEntry);
                            break;
                        }
                        case 16: {
                            System.err.println("16 BPP icons not supported - write to ct@ctreber.com if you need this");
                            break block15;
                        }
                        case 24: {
                            iCOBitmap = new ICOBitmap24(iCOEntry);
                            break;
                        }
                        case 32: {
                            iCOBitmap = new ICOBitmap32(iCOEntry);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported bit count " + n2);
                        }
                    }
                    iCOBitmap.read(fileDecoder);
                    iCOEntry.setBitmap(iCOBitmap);
                    this.VV_fEntries.add(iCOEntry);
                }
                catch (IOException iOException) {
                    System.err.println("Error: " + iOException.getMessage());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("Error: " + illegalArgumentException.getMessage());
                }
            }
            ++n;
        }
        ICOFile.log(1, "Done reading icon file");
    }

    public List getEntries() {
        return this.VV_fEntries;
    }

    private ICOEntry Vv_getEntry(int n) {
        return (ICOEntry)this.VV_fEntries.get(n);
    }

    public int getType() {
        return this.Uv_fType;
    }

    public int getImageCount() {
        return this.VU_fImageCount;
    }

    public int getReserved() {
        return this.Uu_fReserved;
    }

    public static void log(int n, String string) {
        if (UU_fsVerbosity >= n) {
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Usage: aclibico.sh [-v <verbosity level:integer>] <fileName:string> [{, <fileName:string>}]\nfileName can be an URL, too");
            System.exit(1);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-v")) {
                if (++n < stringArray.length) {
                    try {
                        UU_fsVerbosity = Integer.parseInt(stringArray[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Argument to '-v' must be an integer number");
                    }
                }
            } else {
                String string = stringArray[n];
                ICOFile.log(1, "Processing " + string);
                ICOFile iCOFile = null;
                try {
                    URL uRL = new URL(string);
                    iCOFile = new ICOFile(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    iCOFile = new ICOFile(string);
                }
                int n2 = 0;
                while (n2 < iCOFile.getEntries().size()) {
                    ICOEntry iCOEntry = iCOFile.Vv_getEntry(n2);
                    System.out.println(ICOFile.uU_getCaption(string, n2, iCOEntry));
                    Image image = iCOEntry.getImageRGB();
                    if (image != null) {
                        JFrame jFrame = new JFrame(ICOFile.uU_getCaption(string, n2, iCOEntry));
                        jFrame.getContentPane().add(new JButton(new ImageIcon(image)));
                        jFrame.setSize(500, 200);
                        jFrame.setVisible(true);
                        ++Vu_fsFrames;
                        jFrame.setDefaultCloseOperation(2);
                        jFrame.addWindowListener(new WindowAdapter(){

                            public void windowClosed(WindowEvent windowEvent) {
                                ICOFile.uV_windowClose();
                            }
                        });
                    } else {
                        System.err.println("Could not create RGB image for image no. " + (1 + n2));
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private static void uV_windowClose() {
        if (--Vu_fsFrames <= 0) {
            System.out.println("Bye!");
            System.exit(0);
        }
    }

    private static String uU_getCaption(String string, int n, ICOEntry iCOEntry) {
        return String.valueOf(string) + ": " + "Entry no. " + (1 + n) + ", " + iCOEntry.getWidth() + " x " + iCOEntry.getHeight() + ", " + iCOEntry.getBitCount() + " BPP";
    }
}

