/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.ICO;

import imager.imagefileio.ICO.ICOFile;
import imager.imagefileio.ICO.general.FileDecoder;
import java.io.IOException;

public class ICOHeader {
    private int UU_fHeaderSize;
    private int uU_fWidth;
    private int VV_fHeight;
    private int Uu_fPlanes;
    private int uu_fBitCount;
    private int Vv_fCompression;
    private int VU_fImageSize;
    private int UV_fXPixelsPerM;
    private int uV_fYPixelsPerM;
    private int Vu_fColorsUsed;
    private int Uv_fColorsImportant;

    public ICOHeader(FileDecoder fileDecoder) throws IOException {
        ICOFile.log(2, "Reading header at " + fileDecoder.getPos());
        this.UU_fHeaderSize = fileDecoder.readUInt4();
        this.uU_fWidth = fileDecoder.readUInt4();
        this.VV_fHeight = fileDecoder.readUInt4();
        this.Uu_fPlanes = fileDecoder.readUInt2();
        this.uu_fBitCount = fileDecoder.readUInt2();
        this.Vv_fCompression = fileDecoder.readUInt4();
        this.VU_fImageSize = fileDecoder.readUInt4();
        this.UV_fXPixelsPerM = fileDecoder.readUInt4();
        this.uV_fYPixelsPerM = fileDecoder.readUInt4();
        this.Vu_fColorsUsed = fileDecoder.readUInt4();
        this.Uv_fColorsImportant = fileDecoder.readUInt4();
        ICOFile.log(2, this.toString());
    }

    public String toString() {
        return "Header: size: " + this.UU_fHeaderSize + ", width: " + this.uU_fWidth + ", height: " + this.VV_fHeight + ", planes: " + this.Uu_fPlanes + ", bitCount: " + this.uu_fBitCount + ", compression: " + this.Vv_fCompression + ", imageSize: " + this.VU_fImageSize + ", XPixelsPerM: " + this.UV_fXPixelsPerM + ", YPixelsPerM: " + this.uV_fYPixelsPerM + ", colorsUsed: " + this.Vu_fColorsUsed + ", colorsImportant: " + this.Uv_fColorsImportant + (this.Uv_fColorsImportant == 0 ? " (all)" : "");
    }

    public int getBitCount() {
        return this.uu_fBitCount;
    }

    public int getColorsImportant() {
        return this.Uv_fColorsImportant;
    }

    public int getColorsUsed() {
        return this.Vu_fColorsUsed;
    }

    public int getCompression() {
        return this.Vv_fCompression;
    }

    public int getHeight() {
        return this.VV_fHeight;
    }

    public int getImageSize() {
        return this.VU_fImageSize;
    }

    public int getPlanes() {
        return this.Uu_fPlanes;
    }

    public int getHeaderSize() {
        return this.UU_fHeaderSize;
    }

    public int getWidth() {
        return this.uU_fWidth;
    }

    public int getXPixelsPerM() {
        return this.UV_fXPixelsPerM;
    }

    public int getYPixelsPerM() {
        return this.uV_fYPixelsPerM;
    }
}

