/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.ICO.general;

import java.io.IOException;

public abstract class FileDecoder {
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    protected int fEndianness = 0;
    protected int fPos = 0;
    public final byte[] fReadBuf = new byte[4];

    public int readUInt1() throws IOException {
        return this.readValue(1);
    }

    public int readUInt2() throws IOException {
        return this.readValue(2);
    }

    public int readUInt4() throws IOException {
        return this.readValue(4);
    }

    public void setEndianness(int n) {
        this.fEndianness = n;
    }

    public int getPos() {
        return this.fPos;
    }

    public void fastForward(int n) throws IOException {
        if (this.fPos < n) {
            this.readArray(n - this.fPos);
        }
    }

    public abstract byte[] readArray(int var1) throws IOException;

    protected int readValue(int n) throws IOException {
        this.read4ByteMax(n);
        if (n == 1) {
            return this.fReadBuf[0] & 0xFF;
        }
        int n2 = 0;
        if (this.fEndianness == 0) {
            int n3 = 0;
            while (n3 < n) {
                n2 <<= 8;
                n2 += this.fReadBuf[n3] & 0xFF;
                ++n3;
            }
        } else {
            int n4 = n - 1;
            while (n4 >= 0) {
                n2 <<= 8;
                n2 += this.fReadBuf[n4] & 0xFF;
                --n4;
            }
        }
        return n2;
    }

    protected abstract void read4ByteMax(int var1) throws IOException;
}

