/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.PSD;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class PSDReader {
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    public static final int STATUS_UNSUPPORTED = 3;
    public static int ImageType = 2;
    protected BufferedInputStream input;
    protected int frameCount;
    protected BufferedImage[] frames;
    protected int status = 0;
    protected int nChan;
    protected int width;
    protected int height;
    protected int nLayers;
    protected boolean dummyLayer;
    protected LayerInfo[] layers;

    protected void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.input = null;
        }
    }

    protected boolean err() {
        return this.status != 0;
    }

    protected byte[] fillBytes(int n, int n2) {
        byte[] byArray = new byte[n];
        byte by = (byte)n2;
        int n3 = 0;
        while (n3 < n) {
            byArray[n3] = by;
            ++n3;
        }
        return byArray;
    }

    public int getDelay(int n) {
        return 0;
    }

    public BufferedImage getFrame(int n) {
        BufferedImage bufferedImage = null;
        if (n >= 0 && n < this.nLayers) {
            bufferedImage = this.frames[n];
            LayerInfo layerInfo = this.layers[n];
            if (layerInfo.w != this.width || layerInfo.h != this.height) {
                BufferedImage bufferedImage2 = new BufferedImage(this.width, this.height, ImageType);
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.drawImage((Image)bufferedImage, layerInfo.x, layerInfo.y, null);
                graphics2D.dispose();
                this.frames[n] = bufferedImage = bufferedImage2;
            }
        }
        return bufferedImage;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public Dimension getFrameSize() {
        return new Dimension(this.width, this.height);
    }

    public BufferedImage getImage() {
        return this.getFrame(0);
    }

    public BufferedImage getLayer(int n) {
        BufferedImage bufferedImage = null;
        if (n >= 0 && n < this.nLayers) {
            bufferedImage = this.frames[n];
        }
        return bufferedImage;
    }

    public Point getLayerOffset(int n) {
        Point point = null;
        if (n >= 0 && n < this.nLayers) {
            int n2 = this.layers[n].x;
            int n3 = this.layers[n].y;
            point = new Point(n2, n3);
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        return point;
    }

    protected void init() {
        this.close();
        this.frameCount = 0;
        this.frames = null;
        this.layers = null;
        this.dummyLayer = false;
        this.status = 0;
    }

    protected void makeDummyLayer() {
        int n;
        LayerInfo layerInfo;
        short s = this.readShort();
        if (s != 0) {
            this.status = 3;
            return;
        }
        this.dummyLayer = true;
        this.nLayers = 1;
        this.layers = new LayerInfo[1];
        this.layers[0] = layerInfo = new LayerInfo();
        layerInfo.h = this.height;
        layerInfo.w = this.width;
        layerInfo.nChan = n = Math.min(this.nChan, 4);
        layerInfo.chan = new ChanInfo[n];
        int n2 = 0;
        while (n2 < n) {
            ChanInfo chanInfo;
            layerInfo.chan[n2] = chanInfo = new ChanInfo();
            chanInfo.id = n2 == 3 ? -1 : n2;
            chanInfo.size = this.width * this.height;
            ++n2;
        }
    }

    protected BufferedImage makeImage(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n3 = n * n2;
        int n4 = 0;
        while (n4 < n3) {
            try {
                int n5 = byArray4[n4] & 0xFF;
                int n6 = byArray[n4] & 0xFF;
                int n7 = byArray2[n4] & 0xFF;
                int n8 = byArray3[n4] & 0xFF;
                nArray[n4] = ((n5 << 8 | n6) << 8 | n7) << 8 | n8;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n4;
        }
        return bufferedImage;
    }

    protected void process() {
        if (this.err()) {
            return;
        }
        this.readHeader();
        if (this.err()) {
            return;
        }
        this.readLayerInfo();
        if (this.err()) {
            return;
        }
        if (this.nLayers == 0) {
            this.makeDummyLayer();
            if (this.err()) {
                return;
            }
        }
        this.readLayers();
    }

    public int read(InputStream inputStream) {
        this.setInput(inputStream);
        this.process();
        return this.status;
    }

    public int read(String string) {
        this.setInput(string);
        this.process();
        return this.status;
    }

    protected int readByte() {
        int n = 0;
        try {
            n = this.input.read();
        }
        catch (IOException iOException) {
            this.status = 1;
        }
        return n;
    }

    protected int readBytes(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.input.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            this.status = 1;
        }
        if (n2 < n) {
            this.status = 1;
        }
        return n2;
    }

    protected void readHeader() {
        int n;
        String string = this.readString(4);
        short s = this.readShort();
        this.skipBytes(6);
        this.nChan = this.readShort();
        this.height = this.readInt();
        this.width = this.readInt();
        short s2 = this.readShort();
        short s3 = this.readShort();
        int n2 = this.readInt();
        if (n2 > 0) {
            this.skipBytes(n2);
        }
        if ((n = this.readInt()) > 0) {
            this.skipBytes(n);
        }
        if (!string.equals("8BPS") || s != 1) {
            this.status = 1;
        } else if (s2 != 8 || s3 != 3) {
            this.status = 3;
        }
    }

    protected int readInt() {
        return ((this.readByte() << 8 | this.readByte()) << 8 | this.readByte()) << 8 | this.readByte();
    }

    protected void readLayerInfo() {
        int n = this.readInt();
        if (n == 0) {
            return;
        }
        int n2 = this.readInt();
        this.nLayers = this.readShort();
        if (this.nLayers > 0) {
            this.layers = new LayerInfo[this.nLayers];
        }
        int n3 = 0;
        while (n3 < this.nLayers) {
            LayerInfo layerInfo;
            this.layers[n3] = layerInfo = new LayerInfo();
            layerInfo.y = this.readInt();
            layerInfo.x = this.readInt();
            layerInfo.h = this.readInt() - layerInfo.y;
            layerInfo.w = this.readInt() - layerInfo.x;
            layerInfo.nChan = this.readShort();
            layerInfo.chan = new ChanInfo[layerInfo.nChan];
            int n4 = 0;
            while (n4 < layerInfo.nChan) {
                ChanInfo chanInfo = new ChanInfo();
                chanInfo.id = this.readShort();
                chanInfo.size = this.readInt();
                layerInfo.chan[n4] = chanInfo;
                ++n4;
            }
            String string = this.readString(4);
            if (!string.equals("8BIM")) {
                this.status = 1;
                return;
            }
            this.skipBytes(4);
            layerInfo.alpha = this.readByte();
            int n5 = this.readByte();
            int n6 = this.readByte();
            this.readByte();
            int n7 = this.readInt();
            this.skipBytes(n7);
            ++n3;
        }
        n3 = n - n2 - 4;
        if (n3 > 0) {
            this.skipBytes(n3);
        }
    }

    protected void readLayers() {
        this.frameCount = this.nLayers;
        this.frames = new BufferedImage[this.nLayers];
        int n = 0;
        while (n < this.nLayers) {
            BufferedImage bufferedImage;
            LayerInfo layerInfo = this.layers[n];
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            int n2 = 0;
            int n3 = 0;
            while (n3 < layerInfo.nChan) {
                ChanInfo chanInfo = layerInfo.chan[n3];
                switch (chanInfo.id) {
                    case 0: {
                        byArray = this.readPlane(chanInfo.size);
                        break;
                    }
                    case 1: {
                        byArray2 = this.readPlane(chanInfo.size);
                        break;
                    }
                    case 2: {
                        byArray3 = this.readPlane(chanInfo.size);
                        break;
                    }
                    case -1: {
                        byArray4 = this.readPlane(chanInfo.size);
                        break;
                    }
                    default: {
                        this.readPlane(chanInfo.size);
                    }
                }
                if (this.err()) break;
                if (chanInfo.size > n2) {
                    n2 = chanInfo.size;
                }
                ++n3;
            }
            if (this.err()) break;
            if (byArray == null) {
                byArray = this.fillBytes(n2, 0);
            }
            if (byArray2 == null) {
                byArray2 = this.fillBytes(n2, 0);
            }
            if (byArray3 == null) {
                byArray3 = this.fillBytes(n2, 0);
            }
            if (byArray4 == null) {
                byArray4 = this.fillBytes(n2, 255);
            }
            this.frames[n] = bufferedImage = this.makeImage(layerInfo.w, layerInfo.h, byArray, byArray2, byArray3, byArray4);
            ++n;
        }
    }

    protected byte[] readPlane(int n) {
        if (!this.dummyLayer) {
            n -= 2;
            short s = this.readShort();
            if (s != 0) {
                this.status = 3;
                return null;
            }
        }
        byte[] byArray = new byte[n];
        int n2 = this.readBytes(byArray, n);
        return byArray;
    }

    protected short readShort() {
        return (short)(this.readByte() << 8 | this.readByte());
    }

    protected String readString(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + (char)this.readByte();
            ++n2;
        }
        return string;
    }

    public void reset() {
        this.init();
    }

    protected void setInput(InputStream inputStream) {
        this.init();
        if (inputStream == null) {
            this.status = 2;
        } else {
            this.input = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        }
    }

    protected void setInput(String string) {
        this.init();
        try {
            string = string.trim();
            if (string.startsWith("file:")) {
                string = string.substring(5);
                while (string.startsWith("/")) {
                    string = string.substring(1);
                }
            }
            if (string.indexOf("://") > 0) {
                URL uRL = new URL(string);
                this.input = new BufferedInputStream(uRL.openStream());
            } else {
                this.input = new BufferedInputStream(new FileInputStream(string));
            }
        }
        catch (IOException iOException) {
            this.status = 2;
        }
    }

    protected void skipBytes(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.readByte();
            ++n2;
        }
    }

    protected class LayerInfo {
        int x;
        int y;
        int w;
        int h;
        int nChan;
        ChanInfo[] chan;
        int alpha;

        protected LayerInfo() {
        }
    }

    protected class ChanInfo {
        int id;
        int size;

        protected ChanInfo() {
        }
    }
}

