/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.TIFF.enhanced;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class MotorolaIntelInputFilter {
    private RandomAccessFile U_raf;
    private boolean isIntel;

    public MotorolaIntelInputFilter(RandomAccessFile randomAccessFile, boolean bl) {
        this.U_raf = randomAccessFile;
        this.isIntel = bl;
    }

    public boolean isIntel() {
        return this.isIntel;
    }

    public short readByte() throws IOException {
        short s = (short)this.U_raf.readUnsignedByte();
        return s;
    }

    public void writeByte(int n) throws IOException {
        this.U_raf.writeByte(n);
    }

    public int readShort() throws IOException {
        int n = 0;
        if (this.isIntel) {
            int n2 = 0;
            int n3 = 0;
            n2 = this.U_raf.readUnsignedByte();
            n3 = this.U_raf.readUnsignedByte();
            n = ((n3 & 0xFFFF) << 8) + (n2 & 0xFFFF);
        } else {
            n = this.U_raf.readUnsignedShort();
        }
        return n;
    }

    public int readUnsignedShort() throws IOException {
        int n = 0;
        if (this.isIntel) {
            int n2 = 0;
            int n3 = 0;
            n2 = this.U_raf.readUnsignedByte();
            n3 = this.U_raf.readUnsignedByte();
            n = ((n3 & 0xFFFF) << 8) + (n2 & 0xFFFF);
        } else {
            n = this.U_raf.readUnsignedShort();
        }
        return n;
    }

    public void writeShort(int n) throws IOException {
        if (this.isIntel) {
            int n2 = 0;
            int n3 = 0;
            n2 = (n & 0xFF00) >> 8;
            n3 = n & 0xFF;
            n = ((n3 & 0xFF) << 8) + (n2 & 0xFF);
        }
        this.U_raf.writeShort(n);
    }

    public long readInt() throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l = this.U_raf.readInt();
        if (this.isIntel) {
            n = (int)((l & 0xFFFFFFFFFF000000L) >> 24);
            n2 = (int)((l & 0xFF0000L) >> 16);
            n3 = (int)((l & 0xFF00L) >> 8);
            n4 = (int)(l & 0xFFL);
            l = ((n4 & 0xFF) << 24) + ((n3 & 0xFF) << 16) + ((n2 & 0xFF) << 8) + (n & 0xFF);
        }
        return l;
    }

    public void writeInt(int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.isIntel) {
            n2 = (n & 0xFF000000) >> 24;
            n3 = (n & 0xFF0000) >> 16;
            n4 = (n & 0xFF00) >> 8;
            n5 = n & 0xFF;
            n = ((n5 & 0xFF) << 24) + ((n4 & 0xFF) << 16) + ((n3 & 0xFF) << 8) + (n2 & 0xFF);
        }
        this.U_raf.writeInt(n);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.U_raf.readFully(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray) throws IOException {
        this.U_raf.write(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.U_raf.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            n3 += n4;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.U_raf.write(byArray, n, n2);
    }

    public void readProperly(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isIntel || n < 2) {
            this.readFully(byArray, 0, n2);
        } else {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            while (n3 < n2) {
                switch (n) {
                    case 2: {
                        n4 = this.U_raf.readUnsignedByte();
                        n5 = this.U_raf.readUnsignedByte();
                        byArray[n3] = (byte)n5;
                        byArray[n3 + 1] = (byte)n4;
                        break;
                    }
                    case 4: {
                        n4 = this.U_raf.readUnsignedByte();
                        n5 = this.U_raf.readUnsignedByte();
                        n6 = this.U_raf.readUnsignedByte();
                        n7 = this.U_raf.readUnsignedByte();
                        byArray[n3] = (byte)n7;
                        byArray[n3 + 1] = (byte)n6;
                        byArray[n3 + 2] = (byte)n5;
                        byArray[n3 + 3] = (byte)n4;
                        break;
                    }
                    case 8: {
                        n4 = this.U_raf.readUnsignedByte();
                        n5 = this.U_raf.readUnsignedByte();
                        n6 = this.U_raf.readUnsignedByte();
                        n7 = this.U_raf.readUnsignedByte();
                        n8 = this.U_raf.readUnsignedByte();
                        n9 = this.U_raf.readUnsignedByte();
                        n10 = this.U_raf.readUnsignedByte();
                        n11 = this.U_raf.readUnsignedByte();
                        byArray[n3] = (byte)n11;
                        byArray[n3 + 1] = (byte)n10;
                        byArray[n3 + 2] = (byte)n9;
                        byArray[n3 + 3] = (byte)n8;
                        byArray[n3 + 4] = (byte)n7;
                        byArray[n3 + 5] = (byte)n6;
                        byArray[n3 + 6] = (byte)n5;
                        byArray[n3 + 7] = (byte)n4;
                    }
                }
                n3 += n;
            }
        }
    }

    public void writeProperly(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isIntel || n < 2) {
            this.write(byArray, 0, n2);
        } else {
            int n3 = 0;
            byte by = 0;
            byte by2 = 0;
            byte by3 = 0;
            byte by4 = 0;
            byte by5 = 0;
            byte by6 = 0;
            byte by7 = 0;
            byte by8 = 0;
            while (n3 < n2) {
                switch (n) {
                    case 2: {
                        by2 = byArray[n3];
                        by = byArray[n3 + 1];
                        int n4 = ((by2 & 0xFF) << 8) + (by & 0xFF);
                        this.U_raf.writeShort(n4);
                        break;
                    }
                    case 4: {
                        by4 = byArray[n3];
                        by3 = byArray[n3 + 1];
                        by2 = byArray[n3 + 2];
                        by = byArray[n3 + 3];
                        int n4 = ((by4 & 0xFF) << 24) + ((by3 & 0xFF) << 16) + ((by2 & 0xFF) << 8) + (by & 0xFF);
                        this.U_raf.writeInt(n4);
                        break;
                    }
                    case 8: {
                        by8 = byArray[n3];
                        by7 = byArray[n3 + 1];
                        by6 = byArray[n3 + 2];
                        by5 = byArray[n3 + 3];
                        by4 = byArray[n3 + 4];
                        by3 = byArray[n3 + 5];
                        by2 = byArray[n3 + 6];
                        by = byArray[n3 + 7];
                        long l = ((by8 & 0xFF) << 56) + ((by7 & 0xFF) << 48) + ((by6 & 0xFF) << 40) + ((by5 & 0xFF) << 32) + ((by4 & 0xFF) << 24) + ((by3 & 0xFF) << 16) + ((by2 & 0xFF) << 8) + (by & 0xFF);
                        this.U_raf.writeLong(l);
                    }
                }
                n3 += n;
            }
        }
    }

    public void seek(long l) throws IOException {
        this.U_raf.seek(l);
    }

    public long getFilePointer() throws IOException {
        return this.U_raf.getFilePointer();
    }

    public long length() throws IOException {
        return this.U_raf.length();
    }

    public void close() throws IOException {
        this.U_raf.close();
    }
}

