/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.TIFF.enhanced.tiff;

import imager.imagefileio.TIFF.enhanced.Converter;
import imager.imagefileio.TIFF.enhanced.tiff.IFD;
import imager.imagefileio.TIFF.enhanced.tiff.RawImage;
import imager.imagefileio.TIFF.enhanced.tiff.T4Code;
import imager.imagefileio.TIFF.enhanced.tiff.T4Node;
import imager.imagefileio.TIFF.enhanced.tiff.T4Tables;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

class CCITTG3Image
extends RawImage {
    T4Node WhiteTree;
    T4Node BlackTree;
    byte[] WhiteRun = new byte[2560];
    byte[] BlackRun = new byte[2560];
    boolean hiloBitOrder;
    int nPixels = 0;

    public CCITTG3Image(IFD iFD) {
        super(iFD);
        int n = 0;
        while (n < 2560) {
            this.WhiteRun[n] = -1;
            this.BlackRun[n] = 0;
            ++n;
        }
        this.hiloBitOrder = iFD.GetFieldValue(266) == 2;
        this.WhiteTree = new T4Node();
        this.BlackTree = new T4Node();
        if (this.hiloBitOrder) {
            int n2;
            T4Code t4Code;
            n = 0;
            while (n < T4Tables.WhiteCodes.length) {
                t4Code = new T4Code(T4Tables.WhiteCodes[n]);
                if (t4Code.bitLength <= 8) {
                    n2 = Converter.reverseByte(Converter.getLoByte(t4Code.codeWord));
                    t4Code.codeWord = n2 >>> 8 - t4Code.bitLength;
                } else {
                    t4Code.codeWord = Converter.reverseInt(t4Code.codeWord) >>> 16 - t4Code.bitLength;
                }
                this.WhiteTree.ReversedAdd(0, t4Code);
                ++n;
            }
            n = 0;
            while (n < T4Tables.BlackCodes.length) {
                t4Code = new T4Code(T4Tables.BlackCodes[n]);
                if (t4Code.bitLength <= 8) {
                    n2 = Converter.reverseByte(Converter.getLoByte(t4Code.codeWord));
                    t4Code.codeWord = n2 >>> 8 - t4Code.bitLength;
                } else {
                    t4Code.codeWord = Converter.reverseInt(t4Code.codeWord) >>> 16 - t4Code.bitLength;
                }
                this.BlackTree.ReversedAdd(0, t4Code);
                ++n;
            }
        } else {
            T4Code t4Code;
            n = 0;
            while (n < T4Tables.WhiteCodes.length) {
                t4Code = new T4Code(T4Tables.WhiteCodes[n]);
                this.WhiteTree.Add(0, t4Code);
                ++n;
            }
            n = 0;
            while (n < T4Tables.BlackCodes.length) {
                t4Code = new T4Code(T4Tables.BlackCodes[n]);
                this.BlackTree.Add(0, t4Code);
                ++n;
            }
        }
    }

    public Image getImage() {
        if (this.imageBytes == null && this.imageStrips != null) {
            int n = this.ifd.GetFieldValue(278);
            this.imageBytes = new byte[this.imageWidth * this.imageHeight];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = this.imageStrips.length - 1;
            while (n2 < this.imageStrips.length) {
                byte[] byArray = this.DecodeImageStrip(this.imageStrips[n2], n2 == n5 ? this.imageHeight - n4 : n, true);
                System.arraycopy(byArray, 0, this.imageBytes, n3, this.nPixels);
                n3 += this.nPixels;
                this.nPixels = 0;
                ++n2;
                n4 += n;
            }
            this.imageStrips = null;
        } else if (this.imageBytes != null) {
            this.imageBytes = this.DecodeImage();
        } else {
            return null;
        }
        Image image = null;
        if (this.bitsPerSample == 8 && this.imageBytes != null) {
            ColorModel colorModel = this.makeColorModel();
            image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.imageWidth, this.imageHeight, colorModel, this.imageBytes, 0, this.imageWidth));
        }
        return image;
    }

    public Object getImageProducer() {
        int n;
        if (this.imageBytes == null && this.imageStrips != null) {
            int n2 = this.ifd.GetFieldValue(278);
            this.imageBytes = new byte[this.imageWidth * this.imageHeight];
            int n3 = 0;
            n = 0;
            int n4 = 0;
            int n5 = this.imageStrips.length - 1;
            while (n3 < this.imageStrips.length) {
                byte[] byArray = this.DecodeImageStrip(this.imageStrips[n3], n3 == n5 ? this.imageHeight - n4 : n2, true);
                System.arraycopy(byArray, 0, this.imageBytes, n, this.nPixels);
                n += this.nPixels;
                this.nPixels = 0;
                ++n3;
                n4 += n2;
            }
            this.imageStrips = null;
        } else if (this.imageBytes != null) {
            this.imageBytes = this.DecodeImage();
        } else {
            return null;
        }
        if (this.bitsPerSample == 8 && this.imageBytes != null) {
            int[] nArray = new int[this.imageBytes.length];
            n = 0;
            while (n < this.imageBytes.length) {
                nArray[n] = this.imageBytes[n];
                ++n;
            }
            return new MemoryImageSource(this.imageWidth, this.imageHeight, nArray, 0, this.imageWidth);
        }
        return null;
    }

    byte[] DecodeImage() {
        System.out.println("CCITTG3Image::DecodeImage()");
        return this.DecodeImageStrip(this.imageBytes, this.imageHeight, true);
    }

    byte[] DecodeImageStrip(byte[] byArray, int n, boolean bl) {
        int n2;
        int n3;
        System.out.println("CCITTG3Image::DecodeImageStrip( strip, " + n + " )");
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[2];
        boolean bl2 = true;
        int n4 = 0;
        T4Code t4Code = new T4Code();
        int n5 = this.imageWidth * n;
        byte[] byArray4 = new byte[n5 + 1];
        this.nPixels = 0;
        if (bl) {
            n3 = 0;
            n2 = 0;
            while (byArray2[n3] == 0) {
                ++n3;
            }
            n2 = n3;
            if (this.hiloBitOrder) {
                int n6 = Converter.reverseByte(byArray2[n2]);
                n3 = 0;
                while (n6 >> n3 != 1) {
                    ++n3;
                }
            } else {
                n3 = 0;
                while (byArray2[n2] >> n3 != 1) {
                    ++n3;
                }
            }
            n3 += n2 * 8;
        } else {
            n3 = 0;
        }
        n4 = 1;
        int n7 = byArray2.length * 8;
        while (n4 < n && n3 < n7) {
            byte by;
            n2 = n3 / 8;
            int n8 = n3 % 8;
            byte by2 = byArray2[n2];
            byte by3 = n2 + 1 < byArray2.length ? byArray2[n2 + 1] : (byte)0;
            byte by4 = by = n2 + 2 < byArray2.length ? byArray2[n2 + 2] : (byte)0;
            if (this.hiloBitOrder) {
                if (n8 > 0) {
                    byArray3[1] = (byte)(((by2 & 0xFF) >>> n8) + ((by3 & 255 >>> 8 - n8) << 8 - n8));
                    byArray3[0] = (byte)(((by3 & 0xFF) >>> n8) + ((by & 255 >>> 8 - n8) << 8 - n8));
                } else {
                    byArray3[1] = by2;
                    byArray3[0] = by3;
                }
            } else if (n8 > 0) {
                byArray3[0] = (byte)(((by2 & 0xFF) << n8) + ((by3 & 0xFF) >> 8 - n8));
                byArray3[1] = (byte)(((by3 & 0xFF) << n8) + ((by & 0xFF) >> 8 - n8));
            } else {
                byArray3[0] = by2;
                byArray3[1] = by3;
            }
            T4Node t4Node = bl2 ? this.WhiteTree.Find(Converter.bytesToInt(byArray3)) : this.BlackTree.Find(Converter.bytesToInt(byArray3));
            if (t4Node != null) {
                t4Code = t4Node.code;
            }
            if (t4Code.runLength > 0) {
                if (this.nPixels >= byArray4.length || this.nPixels + t4Code.runLength >= byArray4.length || t4Code.runLength >= this.WhiteRun.length || t4Code.runLength >= this.BlackRun.length) {
                    System.out.println("nPixels=" + this.nPixels + ", code.runLength=" + t4Code.runLength + ", rawImage.length=" + byArray4.length + ", WhiteRun.length=" + this.WhiteRun.length + ", BlackRun.length=" + this.BlackRun.length);
                    System.out.flush();
                }
                System.arraycopy(bl2 ? this.WhiteRun : this.BlackRun, 0, byArray4, this.nPixels, t4Code.runLength);
                this.nPixels += t4Code.runLength;
            }
            n3 += t4Code.bitLength;
            if (t4Code.runLength == -3) {
                --n4;
                break;
            }
            if (this.nPixels > 0 && t4Code.runLength == -1) {
                bl2 = true;
                ++n4;
                continue;
            }
            if (t4Code.runLength >= 64) continue;
            boolean bl3 = bl2 = !bl2;
        }
        this.bitsPerSample = 8;
        return byArray4;
    }
}

