/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.TIFF.enhanced.tiff;

import imager.imagefileio.TIFF.enhanced.MemoryFileInputFilter;
import imager.imagefileio.TIFF.enhanced.MotorolaIntelInputFilter;
import java.io.IOException;

class Header {
    public static final int TIFF_VERSION = 42;
    public static final int TIFF_BIGENDIAN = 19789;
    public static final int TIFF_LITTLEENDIAN = 18761;
    public static final int SIZE = 8;
    public int byteOrder;
    public int id;
    public long offset;

    public Header() {
        this.init();
    }

    void init() {
        this.byteOrder = 18761;
        this.id = 42;
        this.offset = 10L;
    }

    void write(MotorolaIntelInputFilter motorolaIntelInputFilter) throws IOException {
        motorolaIntelInputFilter.writeShort(this.byteOrder);
        motorolaIntelInputFilter.writeShort(this.id);
        motorolaIntelInputFilter.writeInt((int)this.offset);
    }

    void read(MemoryFileInputFilter memoryFileInputFilter) {
        this.byteOrder = memoryFileInputFilter.readUnsignedShort();
        memoryFileInputFilter.setByteOrder(this.byteOrder == 18761);
        this.id = memoryFileInputFilter.readUnsignedShort();
        this.offset = memoryFileInputFilter.readInt();
    }

    public String toString() {
        String string = "Byte Order: ";
        string = this.byteOrder == 19789 ? String.valueOf(string) + "Motorola" : String.valueOf(string) + "Intel";
        string = String.valueOf(string) + ", Version: " + this.id + ", Offset: " + Long.toHexString(this.offset);
        return string;
    }
}

