/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.Colormap;
import imager.plugins.ImageMath;
import java.io.Serializable;

public class ArrayColormap
implements Colormap,
Cloneable,
Serializable {
    static final long serialVersionUID = -7990431442314209043L;
    protected int[] map;

    public ArrayColormap() {
        this.map = new int[256];
    }

    public ArrayColormap(int[] nArray) {
        this.map = nArray;
    }

    public Object clone() {
        try {
            ArrayColormap arrayColormap = (ArrayColormap)super.clone();
            arrayColormap.map = (int[])this.map.clone();
            return arrayColormap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setMap(int[] nArray) {
        this.map = nArray;
    }

    public int[] getMap() {
        return this.map;
    }

    public int getColor(float f) {
        int n = (int)(f * 255.0f);
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return this.map[n];
    }

    public void setColorInterpolated(int n, int n2, int n3, int n4) {
        int n5 = this.map[n2];
        int n6 = this.map[n3];
        int n7 = n2;
        while (n7 <= n) {
            this.map[n7] = ImageMath.mixColors((float)(n7 - n2) / (float)(n - n2), n5, n4);
            ++n7;
        }
        n7 = n;
        while (n7 < n3) {
            this.map[n7] = ImageMath.mixColors((float)(n7 - n) / (float)(n3 - n), n4, n6);
            ++n7;
        }
    }

    public void setColorRange(int n, int n2, int n3, int n4) {
        int n5 = n;
        while (n5 <= n2) {
            this.map[n5] = ImageMath.mixColors((float)(n5 - n) / (float)(n2 - n), n3, n4);
            ++n5;
        }
    }

    public void setColorRange(int n, int n2, int n3) {
        int n4 = n;
        while (n4 <= n2) {
            this.map[n4] = n3;
            ++n4;
        }
    }

    public void setColor(int n, int n2) {
        this.map[n] = n2;
    }
}

