/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.CrystalizeFilter;
import imager.plugins.PreviewFilterCustomizer;
import imager.plugins.SliderFactory;
import imager.plugins.SuperGridLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CrystalizeFilterCustomizer
extends PreviewFilterCustomizer
implements ItemListener,
ChangeListener {
    private JSlider UU_scale;
    private JSlider Uu_angle;
    private JSlider VU_randomness;
    private JSlider Vu_edges;
    private JComboBox UV_gridChoice;
    private JCheckBox Uv_fadeCheck;
    private CrystalizeFilter VV_filter;

    public CrystalizeFilterCustomizer() {
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        SuperGridLayout superGridLayout = new SuperGridLayout(3, 2);
        jPanel.setLayout(superGridLayout);
        superGridLayout.setColWeight(1, 1);
        jPanel.add(new JLabel("Size:", 4));
        this.UU_scale = new JSlider(0, 1, 100, 10);
        jPanel.add(this.UU_scale);
        this.UU_scale.setPaintTicks(true);
        this.UU_scale.setMajorTickSpacing(100);
        this.UU_scale.setMinorTickSpacing(20);
        this.UU_scale.setPaintLabels(true);
        this.UU_scale.addChangeListener(this);
        jPanel.add(new JLabel("Angle:", 4));
        this.Uu_angle = new JSlider(0, 0, 360, 0);
        jPanel.add(this.Uu_angle);
        this.Uu_angle.setPaintTicks(true);
        this.Uu_angle.setMajorTickSpacing(360);
        this.Uu_angle.setMinorTickSpacing(30);
        this.Uu_angle.setPaintLabels(true);
        this.Uu_angle.addChangeListener(this);
        jPanel.add(new JLabel("Randomness:", 4));
        this.VU_randomness = SliderFactory.createPercentageSlider();
        jPanel.add(this.VU_randomness);
        this.VU_randomness.addChangeListener(this);
        jPanel.add(new JLabel("Edges:", 4));
        this.Vu_edges = SliderFactory.createPercentageSlider();
        jPanel.add(this.Vu_edges);
        this.Vu_edges.addChangeListener(this);
        jPanel.add(new JLabel("Shape:", 4));
        this.UV_gridChoice = new JComboBox();
        jPanel.add(this.UV_gridChoice);
        this.UV_gridChoice.addItemListener(this);
        this.UV_gridChoice.addItem("Random");
        this.UV_gridChoice.addItem("Squares");
        this.UV_gridChoice.addItem("Hexagons");
        this.UV_gridChoice.addItem("Octagons & Squares");
        this.UV_gridChoice.addItem("Triangles");
        this.Uv_fadeCheck = new JCheckBox("Fade Edges");
        jPanel.add(this.Uv_fadeCheck);
        this.Uv_fadeCheck.addChangeListener(this);
    }

    public void setObject(Object object) {
        super.setObject(object);
        CrystalizeFilter crystalizeFilter = (CrystalizeFilter)object;
        this.VV_filter = null;
        this.UU_scale.setValue((int)crystalizeFilter.getScale());
        this.Uu_angle.setValue((int)(crystalizeFilter.getAngle() * 180.0f / 3.141593f));
        this.VU_randomness.setValue((int)(crystalizeFilter.getRandomness() * 100.0f));
        this.Vu_edges.setValue((int)(crystalizeFilter.getEdgeThickness() * 100.0f));
        this.UV_gridChoice.setSelectedIndex(crystalizeFilter.getGridType());
        this.Uv_fadeCheck.setSelected(crystalizeFilter.getFadeEdges());
        this.VV_filter = crystalizeFilter;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (this.VV_filter != null) {
            if (object == this.UV_gridChoice) {
                this.VV_filter.setGridType(this.UV_gridChoice.getSelectedIndex());
            }
            this.preview();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.VV_filter != null) {
            Object object = changeEvent.getSource();
            if (object instanceof JSlider && ((JSlider)object).getValueIsAdjusting()) {
                return;
            }
            if (object == this.UU_scale) {
                this.VV_filter.setScale(this.UU_scale.getValue());
            } else if (object == this.Uu_angle) {
                this.VV_filter.setAngle((float)this.Uu_angle.getValue() * 3.141593f / 180.0f);
            } else if (object == this.VU_randomness) {
                this.VV_filter.setRandomness((float)this.VU_randomness.getValue() / 100.0f);
            } else if (object == this.Vu_edges) {
                this.VV_filter.setEdgeThickness((float)this.Vu_edges.getValue() / 100.0f);
            } else if (object == this.Uv_fadeCheck) {
                this.VV_filter.setFadeEdges(this.Uv_fadeCheck.isSelected());
            }
            this.preview();
        }
    }
}

