/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.Noise;
import imager.plugins.PixelUtils;
import imager.plugins.TransformFilter;

public class MarbleFilter
extends TransformFilter {
    static final long serialVersionUID = -3658170437130333021L;
    public float[] sinTable;
    public float[] cosTable;
    public float xScale = 4.0f;
    public float yScale = 4.0f;
    public float amount = 1.0f;
    public float turbulence = 1.0f;

    public MarbleFilter() {
        this.setEdgeAction(1);
    }

    public void setXScale(float f) {
        this.xScale = f;
    }

    public float getXScale() {
        return this.xScale;
    }

    public void setYScale(float f) {
        this.yScale = f;
    }

    public float getYScale() {
        return this.yScale;
    }

    public void setAmount(float f) {
        this.amount = f;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setTurbulence(float f) {
        this.turbulence = f;
    }

    public float getTurbulence() {
        return this.turbulence;
    }

    private void U_initialize() {
        this.sinTable = new float[256];
        this.cosTable = new float[256];
        int n = 0;
        while (n < 256) {
            float f = 6.283185f * (float)n / 256.0f * this.turbulence;
            this.sinTable[n] = (float)((double)(-this.yScale) * Math.sin(f));
            this.cosTable[n] = (float)((double)this.yScale * Math.cos(f));
            ++n;
        }
    }

    private int V_displacementMap(int n, int n2) {
        return PixelUtils.clamp((int)(127.0f * (1.0f + Noise.noise2((float)n / this.xScale, (float)n2 / this.xScale))));
    }

    protected void transformInverse(int n, int n2, float[] fArray) {
        int n3 = this.V_displacementMap(n, n2);
        fArray[0] = (float)n + this.sinTable[n3];
        fArray[1] = (float)n2 + this.cosTable[n3];
    }

    public void imageComplete(int n) {
        this.U_initialize();
        super.imageComplete(n);
    }

    public String toString() {
        return "Distort/Marble...";
    }
}

