/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.Alignment;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;

public class SuperGridLayout
implements LayoutManager {
    static final long serialVersionUID = -3925957639755567096L;
    protected int hGap;
    protected int vGap;
    protected int hMargin;
    protected int vMargin;
    protected int rows;
    protected int cols;
    protected int reqRows;
    protected int reqCols;
    protected int[] rowHeights;
    protected int[] colWidths;
    protected int[] colFlags;
    protected int[] rowWeights;
    protected int[] colWeights;
    protected int alignment = 8;
    protected int fill = 3;
    protected boolean labelStyle = false;

    public SuperGridLayout() {
        this(0, 1, 2, 2);
    }

    public SuperGridLayout(int n, int n2) {
        this(n, n2, 2, 2);
    }

    public SuperGridLayout(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0, 0);
    }

    public SuperGridLayout(int n, int n2, int n3, int n4, int n5, int n6) {
        this.reqRows = n;
        this.reqCols = n2;
        this.hGap = n3;
        this.vGap = n4;
        this.hMargin = n5;
        this.vMargin = n6;
    }

    public void setLabelStyle(boolean bl) {
        this.labelStyle = bl;
        this.vGap = 11;
        this.hGap = 12;
        this.vMargin = 12;
        this.hMargin = 12;
        this.fill = 0;
    }

    public boolean getLabelStyle() {
        return this.labelStyle;
    }

    public void setColumns(int n) {
        if (n < 1) {
            n = 1;
        }
        this.cols = n;
    }

    public void setRows(int n) {
        if (n < 1) {
            n = 1;
        }
        this.rows = n;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setFill(int n) {
        this.fill = n;
    }

    public int getFill() {
        return this.fill;
    }

    private int[] U_setWeight(int[] nArray, int n, int n2) {
        if (nArray == null) {
            nArray = new int[n + 1];
        } else if (n >= nArray.length) {
            int[] nArray2 = new int[n + 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
        }
        nArray[n] = n2;
        return nArray;
    }

    public void setRowWeight(int n, int n2) {
        this.rowWeights = this.U_setWeight(this.rowWeights, n, n2);
    }

    public void setColWeight(int n, int n2) {
        this.colWeights = this.U_setWeight(this.colWeights, n, n2);
    }

    public void setColAlignment(int n, int n2) {
        this.colFlags = this.U_setWeight(this.colFlags, n, n2);
    }

    protected int getRowWeight(int n) {
        if (this.rowWeights != null && n < this.rowWeights.length) {
            return this.rowWeights[n];
        }
        return 0;
    }

    protected int getColWeight(int n) {
        if (this.colWeights != null && n < this.colWeights.length) {
            return this.colWeights[n];
        }
        return 0;
    }

    protected int getColAlignment(int n) {
        if (this.colFlags != null && n < this.colFlags.length) {
            return this.colFlags[n];
        }
        return this.alignment;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        this.calcCellSizes(container, true);
        dimension.width = this.sumArray(this.colWidths, this.hGap, this.cols);
        dimension.height = this.sumArray(this.rowHeights, this.vGap, this.rows);
        this.colWidths = null;
        this.rowHeights = null;
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right + 2 * this.hMargin;
        dimension.height += insets.top + insets.bottom + 2 * this.vMargin;
        return dimension;
    }

    public void layoutContainer(Container container) {
        int n = container.getComponentCount();
        if (n > 0) {
            Insets insets = container.getInsets();
            Dimension dimension = container.getSize();
            this.calcCellSizes(container, false);
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                if (component.isVisible()) {
                    Dimension dimension2 = component.getPreferredSize();
                    Rectangle rectangle = new Rectangle(0, 0, dimension2.width, dimension2.height);
                    int n3 = n2 / this.cols;
                    int n4 = n2 % this.cols;
                    int n5 = insets.left + this.sumArray(this.colWidths, this.hGap, n4) + this.hMargin;
                    int n6 = insets.top + this.sumArray(this.rowHeights, this.vGap, n3) + this.vMargin;
                    if (n4 > 0) {
                        n5 += this.hGap;
                    }
                    if (n3 > 0) {
                        n6 += this.vGap;
                    }
                    Rectangle rectangle2 = new Rectangle(n5, n6, this.colWidths[n4], this.rowHeights[n3]);
                    Alignment.alignInCell(rectangle, rectangle2, this.alignmentFor(component, n3, n4), this.fillFor(component, n3, n4));
                    component.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                ++n2;
            }
        }
        this.colWidths = null;
        this.rowHeights = null;
    }

    private Dimension V_calcMaxSize(Container container) {
        int n = container.getComponentCount();
        Dimension dimension = new Dimension(0, 0);
        int n2 = 0;
        while (n2 < n) {
            Dimension dimension2 = container.getComponent(n2).getPreferredSize();
            if (dimension2.width > dimension.width) {
                dimension.width = dimension2.width;
            }
            if (dimension2.height > dimension.height) {
                dimension.height = dimension2.height;
            }
            ++n2;
        }
        return dimension;
    }

    protected int sumArray(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 += nArray[n4];
            ++n4;
        }
        if (n2 > 1) {
            n3 += (n2 - 1) * n;
        }
        return n3;
    }

    protected void calcCellSizes(Container container, boolean bl) {
        int n;
        int n2;
        Serializable serializable;
        int n3 = container.getComponentCount();
        if (this.reqCols <= 0) {
            this.rows = this.reqRows;
            this.cols = (n3 + this.reqRows - 1) / this.reqRows;
        } else {
            this.rows = (n3 + this.reqCols - 1) / this.reqCols;
            this.cols = this.reqCols;
        }
        this.colWidths = new int[this.cols];
        int n4 = 0;
        while (n4 < this.cols) {
            this.colWidths[n4] = 0;
            ++n4;
        }
        this.rowHeights = new int[this.rows];
        n4 = 0;
        while (n4 < this.rows) {
            this.rowHeights[n4] = 0;
            ++n4;
        }
        n4 = 0;
        while (n4 < n3) {
            serializable = container.getComponent(n4);
            if (((Component)serializable).isVisible()) {
                Dimension dimension = ((Component)serializable).getPreferredSize();
                n2 = n4 / this.cols;
                n = n4 % this.cols;
                if (this.colWidths[n] < dimension.width) {
                    this.colWidths[n] = dimension.width;
                }
                if (this.rowHeights[n2] < dimension.height) {
                    this.rowHeights[n2] = dimension.height;
                }
            }
            ++n4;
        }
        if (!bl) {
            int n5;
            Dimension dimension = container.getSize();
            serializable = container.getInsets();
            dimension.width -= ((Insets)serializable).left + ((Insets)serializable).right + 2 * this.hMargin;
            dimension.height -= ((Insets)serializable).top + ((Insets)serializable).bottom + 2 * this.vMargin;
            int n6 = 0;
            n2 = 0;
            n = 0;
            while (n < this.cols) {
                n2 += this.getColWeight(n);
                n6 += this.colWidths[n];
                if (n != 0) {
                    n6 += this.hGap;
                }
                ++n;
            }
            if (n2 != 0) {
                n = dimension.width - n6;
                n5 = 0;
                while (n5 < this.cols) {
                    int n7 = n5;
                    this.colWidths[n7] = this.colWidths[n7] + n * this.getColWeight(n5) / n2;
                    ++n5;
                }
            }
            n6 = 0;
            n2 = 0;
            n = 0;
            while (n < this.rows) {
                n2 += this.getRowWeight(n);
                n6 += this.rowHeights[n];
                if (n != 0) {
                    n6 += this.vGap;
                }
                ++n;
            }
            if (n2 != 0) {
                n = dimension.height - n6;
                n5 = 0;
                while (n5 < this.rows) {
                    int n8 = n5;
                    this.rowHeights[n8] = this.rowHeights[n8] + n * this.getRowWeight(n5) / n2;
                    ++n5;
                }
            }
        }
    }

    protected int alignmentFor(Component component, int n, int n2) {
        if (this.labelStyle && n2 == 0) {
            return this.rowHeights[n] <= component.getPreferredSize().height * 3 ? 3 : 2;
        }
        return this.getColAlignment(n2);
    }

    protected int fillFor(Component component, int n, int n2) {
        if (this.labelStyle && n2 == 0) {
            return 0;
        }
        return this.fill;
    }
}

