/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.colorchooser.ColorChooserMainPanel;
import ch.randelshofer.quaqua.colorchooser.QuaquaColorPreviewPanel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessControlException;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class Quaqua13ColorChooserUI
extends ColorChooserUI {
    protected ColorChooserMainPanel mainPanel;
    protected JColorChooser chooser;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected JComponent previewPanel;

    public static ComponentUI createUI(JComponent c) {
        return new Quaqua13ColorChooserUI();
    }

    public void installUI(JComponent c) {
        this.chooser = (JColorChooser)c;
        this.installDefaults();
        this.installListeners();
        this.chooser.setLayout(new BorderLayout());
        this.mainPanel = new ColorChooserMainPanel();
        this.chooser.add(this.mainPanel);
        this.defaultChoosers = this.createDefaultChoosers();
        this.chooser.setChooserPanels(this.defaultChoosers);
        this.installPreviewPanel();
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        String[] defaultChoosers = (String[])UIManager.get("ColorChooser.defaultChoosers");
        AbstractColorChooserPanel[] panels = new AbstractColorChooserPanel[defaultChoosers.length];
        for (int i = 0; i < defaultChoosers.length; ++i) {
            try {
                panels[i] = (AbstractColorChooserPanel)Class.forName(defaultChoosers[i]).newInstance();
                continue;
            }
            catch (AccessControlException e) {
                System.err.println("Quaqua13ColorChooserUI warning: unable to instantiate " + defaultChoosers[i]);
                continue;
            }
            catch (Exception e) {
                throw new InternalError("Unable to instantiate " + defaultChoosers[i]);
            }
            catch (UnsupportedClassVersionError e) {
                System.err.println("Quaqua13ColorChooserUI warning: unable to instantiate " + defaultChoosers[i]);
            }
        }
        return panels;
    }

    public void uninstallUI(JComponent c) {
        this.chooser.remove(this.mainPanel);
        this.uninstallListeners();
        this.uninstallDefaultChoosers();
        this.uninstallDefaults();
        this.mainPanel.setPreviewPanel(null);
        if (this.previewPanel instanceof UIResource) {
            this.chooser.setPreviewPanel(null);
        }
        this.mainPanel = null;
        this.previewPanel = null;
        this.defaultChoosers = null;
        this.chooser = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.previewListener = new PreviewListener();
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    protected void installPreviewPanel() {
        if (this.previewPanel != null) {
            this.mainPanel.setPreviewPanel(null);
        }
        this.previewPanel = this.chooser.getPreviewPanel();
        if (this.previewPanel != null && this.mainPanel != null && this.chooser != null && this.previewPanel.getSize().getHeight() + this.previewPanel.getSize().getWidth() == 0.0) {
            this.mainPanel.setPreviewPanel(null);
            return;
        }
        if (this.previewPanel == null || this.previewPanel instanceof UIResource) {
            this.previewPanel = new QuaquaColorPreviewPanel();
            this.chooser.setPreviewPanel(this.previewPanel);
        }
        this.previewPanel.setForeground(this.chooser.getColor());
        this.mainPanel.setPreviewPanel(this.previewPanel);
    }

    protected void uninstallDefaultChoosers() {
        for (int i = 0; i < this.defaultChoosers.length; ++i) {
            this.chooser.removeChooserPanel(this.defaultChoosers[i]);
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("chooserPanels")) {
                int i;
                AbstractColorChooserPanel[] oldPanels = (AbstractColorChooserPanel[])e.getOldValue();
                AbstractColorChooserPanel[] newPanels = (AbstractColorChooserPanel[])e.getNewValue();
                for (i = 0; i < oldPanels.length; ++i) {
                    Container wrapper = oldPanels[i].getParent();
                    if (wrapper == null) continue;
                    Container parent = wrapper.getParent();
                    if (parent != null) {
                        parent.remove(wrapper);
                    }
                    oldPanels[i].uninstallChooserPanel(Quaqua13ColorChooserUI.this.chooser);
                }
                Quaqua13ColorChooserUI.this.mainPanel.removeAllColorChooserPanels();
                for (i = 0; i < newPanels.length; ++i) {
                    Quaqua13ColorChooserUI.this.mainPanel.addColorChooserPanel(newPanels[i]);
                }
                for (i = 0; i < newPanels.length; ++i) {
                    newPanels[i].installChooserPanel(Quaqua13ColorChooserUI.this.chooser);
                }
            }
            if (e.getPropertyName().equals("previewPanel") && e.getNewValue() != Quaqua13ColorChooserUI.this.previewPanel) {
                Quaqua13ColorChooserUI.this.installPreviewPanel();
            }
        }
    }

    class PreviewListener
    implements ChangeListener {
        PreviewListener() {
        }

        public void stateChanged(ChangeEvent e) {
            ColorSelectionModel model = (ColorSelectionModel)e.getSource();
            if (Quaqua13ColorChooserUI.this.previewPanel != null) {
                Quaqua13ColorChooserUI.this.previewPanel.setForeground(model.getSelectedColor());
                Quaqua13ColorChooserUI.this.previewPanel.repaint();
            }
        }
    }
}

