/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class QuaquaListUI
extends BasicListUI {
    private boolean isStriped = false;
    private static final int VERTICAL;
    private static final Method getLayoutOrientation;
    private int layoutOrientation;
    static /* synthetic */ Class class$javax$swing$JList;

    private Color getAlternateColor(int modulo) {
        if (modulo == 0) {
            return UIManager.getColor("List.alternateBackground.0");
        }
        return UIManager.getColor("List.alternateBackground.1");
    }

    private void updateStriped() {
        Object value = this.list.getClientProperty("Quaqua.List.style");
        this.isStriped = value != null && value.equals("striped") && this.getLayoutOrientation() == VERTICAL;
    }

    private int getLayoutOrientation() {
        if (getLayoutOrientation != null) {
            try {
                return (Integer)getLayoutOrientation.invoke((Object)this.list, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return VERTICAL;
    }

    public void paintStripes(Graphics g, JComponent c) {
        if (this.isStriped && this.list.getModel() != null) {
            int y;
            Dimension vs = c.getSize();
            Dimension ts = this.list.getSize();
            Point p = this.list.getLocation();
            int rh = this.list.getFixedCellHeight();
            int n = this.list.getModel().getSize();
            if (rh <= 0) {
                rh = n == 0 ? 12 : this.getCellBounds(this.list, (int)0, (int)0).height;
            }
            int row = Math.abs(p.y / rh);
            int th = n * rh - row * rh;
            g.setColor(this.getAlternateColor(1));
            g.fillRect(0, 0, ts.width, ts.height);
            g.setColor(this.getAlternateColor(0));
            if (ts.width < vs.width) {
                y = p.y + row * rh;
                while (y < th) {
                    if (row % 2 == 0) {
                        g.fillRect(0, y, vs.width, rh);
                    }
                    y += rh;
                    ++row;
                }
            }
            if (th < vs.height) {
                row = n;
                y = th;
                while (y < vs.height) {
                    if (row % 2 == 0) {
                        g.fillRect(0, y, vs.width, rh);
                    }
                    y += rh;
                    ++row;
                }
            }
        }
    }

    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        Object value = dataModel.getElementAt(row);
        boolean cellHasFocus = this.list.hasFocus() && row == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(row);
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int ch = rowBounds.height;
        if (!this.list.isSelectedIndex(row) && this.isStriped) {
            rendererComponent.setBackground(this.getAlternateColor(row % 2));
            g.setColor(this.getAlternateColor(row % 2));
            g.fillRect(cx, cy, cw, ch);
        }
        this.rendererPane.paintComponent(g, rendererComponent, this.list, cx, cy, cw, ch, true);
    }

    public void paint(Graphics g, JComponent c) {
        this.paintStripes(g, c);
        super.paint(g, c);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateStriped();
    }

    public static ComponentUI createUI(JComponent list) {
        return new QuaquaListUI();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int value = 0;
        try {
            value = (class$javax$swing$JList == null ? (class$javax$swing$JList = QuaquaListUI.class$("javax.swing.JList")) : class$javax$swing$JList).getField("VERTICAL").getInt(null);
        }
        catch (Exception e) {
            // empty catch block
        }
        VERTICAL = value;
        Method value2 = null;
        try {
            value2 = (class$javax$swing$JList == null ? (class$javax$swing$JList = QuaquaListUI.class$("javax.swing.JList")) : class$javax$swing$JList).getMethod("getLayoutOrientation", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        getLayoutOrientation = value2;
    }

    public class PropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        public PropertyChangeHandler() {
            super(QuaquaListUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("Quaqua.List.style")) {
                QuaquaListUI.this.updateStriped();
            } else if ("layoutOrientation".equals(propertyName)) {
                QuaquaListUI.this.layoutOrientation = (Integer)e.getNewValue();
                QuaquaListUI.this.updateStriped();
            }
            super.propertyChange(e);
        }
    }

    public class FocusHandler
    implements FocusListener {
        protected void repaintCellFocus() {
            Rectangle r;
            int leadIndex = QuaquaListUI.this.list.getLeadSelectionIndex();
            if (leadIndex != -1 && (r = QuaquaListUI.this.getCellBounds(QuaquaListUI.this.list, leadIndex, leadIndex)) != null) {
                QuaquaListUI.this.list.repaint(r.x, r.y, r.width, r.height);
            }
        }

        public void focusGained(FocusEvent event) {
            this.repaintCellFocus();
            QuaquaUtilities.repaintBorder((JComponent)event.getComponent());
        }

        public void focusLost(FocusEvent event) {
            this.repaintCellFocus();
            QuaquaUtilities.repaintBorder((JComponent)event.getComponent());
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private boolean selectedOnPress;

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.adjustFocusAndSelection(e);
        }

        private boolean shouldIgnore(MouseEvent e) {
            return e.isConsumed() || !SwingUtilities.isLeftMouseButton(e) || !QuaquaListUI.this.list.isEnabled() || e.isPopupTrigger();
        }

        void adjustFocusAndSelection(MouseEvent e) {
            int row;
            if (this.shouldIgnore(e)) {
                return;
            }
            if (!QuaquaListUI.this.list.hasFocus() && QuaquaListUI.this.list.isRequestFocusEnabled()) {
                QuaquaListUI.this.list.requestFocus();
            }
            if ((row = QuaquaListUI.this.locationToIndex(QuaquaListUI.this.list, e.getPoint())) != -1) {
                boolean adjusting = e.getID() == 501;
                QuaquaListUI.this.list.setValueIsAdjusting(adjusting);
                int anchorIndex = QuaquaListUI.this.list.getAnchorSelectionIndex();
                if (e.isMetaDown()) {
                    if (QuaquaListUI.this.list.isSelectedIndex(row)) {
                        QuaquaListUI.this.list.removeSelectionInterval(row, row);
                    } else {
                        QuaquaListUI.this.list.addSelectionInterval(row, row);
                    }
                } else if (e.isShiftDown() && anchorIndex != -1) {
                    QuaquaListUI.this.list.setSelectionInterval(anchorIndex, row);
                } else {
                    QuaquaListUI.this.list.setSelectionInterval(row, row);
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            Rectangle cellBounds;
            if (e.isConsumed()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (!QuaquaListUI.this.list.isEnabled()) {
                return;
            }
            if (e.isShiftDown() || e.isMetaDown()) {
                return;
            }
            int row = QuaquaListUI.this.locationToIndex(QuaquaListUI.this.list, e.getPoint());
            if (row != -1 && (cellBounds = QuaquaListUI.this.getCellBounds(QuaquaListUI.this.list, row, row)) != null) {
                QuaquaListUI.this.list.scrollRectToVisible(cellBounds);
                QuaquaListUI.this.list.setSelectionInterval(row, row);
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (this.selectedOnPress) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                QuaquaListUI.this.list.setValueIsAdjusting(false);
            } else {
                this.adjustFocusAndSelection(e);
            }
        }
    }
}

