/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import ch.randelshofer.quaqua.QuaquaManager;
import com.jhlabs.app.ActionHandler;
import com.jhlabs.app.AppInternalFrame;
import com.jhlabs.app.ApplicationAction;
import com.jhlabs.app.BetterFocusManager;
import com.jhlabs.app.DialogController;
import com.jhlabs.app.Document;
import com.jhlabs.app.DocumentController;
import com.jhlabs.app.DocumentWindow;
import com.jhlabs.app.HelpWindow;
import com.jhlabs.app.Plugin;
import com.jhlabs.app.PluginFactory;
import com.jhlabs.app.PluginsManager;
import com.jhlabs.app.SplashWindow;
import com.jhlabs.app.StatusBar;
import com.jhlabs.app.StatusDisplay;
import com.jhlabs.app.StringUtils;
import com.jhlabs.swing.DocumentOutputStream;
import com.jhlabs.xml.XMLParser;
import com.jhlabs.xml.XMLUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.Beans;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class Application
extends ActionHandler
implements StatusDisplay,
DropTargetListener {
    public static final int MENUBAR = 0;
    public static final int TOOLBAR = 1;
    public static final int STATUSBAR = 2;
    protected static Application instance;
    public static int debugLevel;
    private JFrame frame;
    private JMenuBar menubar;
    protected JMenuBar currentMenubar;
    protected DocumentController mainController;
    protected Document currentDocument;
    protected DocumentWindow currentDocumentWindow;
    protected JToolBar applicationToolBar;
    protected JToolBar currentToolBar;
    protected Vector windows = new Vector();
    private Vector pluginActions;
    private Vector plugins;
    protected transient PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    public Action newAction;
    public Action openAction;
    public Action quitAction;
    public Action preferencesAction;
    public Action aboutAction;
    public Action helpAction;
    public Properties properties;
    public Properties preferences;
    protected SplashWindow splashWindow;
    public ResourceBundle commonResources = null;
    protected JDesktopPane desktopPane;
    protected JPanel desktopPanel;
    protected StatusBar statusBar;
    protected JLabel statusLabel;
    private boolean exitOnQuit = true;
    public boolean useFileChooser = true;
    public boolean inPaint = false;
    private JFileChooser fileChooser;
    protected int visibleUIElements = -1;
    public boolean isMDI = true;
    protected String lastDirectory = null;
    public MenuBarTag appMenuBarConfig;
    public MenuBarTag menuBarConfig;
    public Vector toolbarItems;
    private PluginsManager pluginsManager;
    protected Container container;
    private String[] recentFiles = new String[10];
    private boolean hasToolbar = false;
    private boolean verbosePlugins = false;
    private static boolean isMacintosh;
    private static Font smallSystemFont;
    public static final String CURRENT_DOCUMENT_PROPERTY = "currentDocument";
    public static final String CURRENT_WINDOW_PROPERTY = "currentWindow";
    public static final String WINDOWS_PROPERTY = "windows";
    public static final String RECENT_FILES_PROPERTY = "recentFiles";
    private Hashtable pluginsFolders = new Hashtable();
    public final MenuItemTag SEPARATOR = new MenuItemTag("-", null, null, false);

    public Application() {
        this(null);
    }

    public Application(Container container) {
        int i;
        this.container = container;
        instance = this;
        this.commonResources = ResourceBundle.getBundle("com.jhlabs.app.CommonResourceBundle");
        this.registerActions();
        isMacintosh = System.getProperty("os.name").startsWith("Mac OS");
        if (isMacintosh) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        }
        this.pluginsManager = new PluginsManager();
        this.pluginsManager.registerType("action", "Actions");
        this.properties = new Properties();
        this.preferences = new Properties();
        this.pluginActions = new Vector();
        this.plugins = new Vector();
        this.isMDI = this.isMDI();
        String lookAndFeel = this.getProperty("lookAndFeel", null);
        if (lookAndFeel != null) {
            this.setLookAndFeel(lookAndFeel);
        } else {
            try {
                String laf = container == null && Application.isMacintosh() ? QuaquaManager.getLookAndFeelClassName() : UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String css = "<head><style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style></head>";
        UIManager.put("OptionPane.css", css);
        this.useFileChooser = this.getBooleanProperty("useFileChooser", false);
        this.frame = new JFrame(this.getApplicationName());
        if (!this.isMDI) {
            this.frame.setResizable(false);
            this.frame.setUndecorated(true);
            System.setProperty("apple.awt.window.position.forceSafeProgrammaticPositioning", "false");
            this.frame.setBounds(-10000, 10000, 0, 0);
            this.frame.pack();
        }
        this.showSplashScreen();
        if (this.isMDI) {
            this.frame.setDefaultCloseOperation(0);
            this.frame.addWindowListener(new ApplicationCloser());
        }
        this.setSplashMessage("Registering plugins");
        this.registerLibraries();
        this.registerPlugins();
        if (this.pluginActions != null) {
            for (i = 0; i < this.pluginActions.size(); ++i) {
                Action a = (Action)this.pluginActions.elementAt(i);
                this.registerAction(a);
            }
        }
        if (this.plugins != null) {
            for (i = 0; i < this.plugins.size(); ++i) {
                Plugin p = (Plugin)this.plugins.elementAt(i);
                p.startup(this);
            }
        }
        this.setSplashMessage("");
        Container contentPane = container != null ? container : this.frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.applicationToolBar = this.currentToolBar = this.makeToolbar();
        try {
            KeyboardFocusManager oldManager = FocusManager.getCurrentKeyboardFocusManager();
            BetterFocusManager newManager = new BetterFocusManager(isMacintosh && !this.isMDI);
            newManager.setDefaultFocusTraversalPolicy(oldManager.getDefaultFocusTraversalPolicy());
            KeyboardFocusManager.setCurrentKeyboardFocusManager(newManager);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (this.isMDI) {
            if (this.hasToolbar) {
                contentPane.add((Component)this.applicationToolBar, "North");
            }
            this.statusBar = new StatusBar();
            contentPane.add((Component)this.statusBar, "South");
            this.statusLabel = new JLabel(){

                public void revalidate() {
                }
            };
            this.statusBar.add(this.statusLabel);
            this.statusLabel.setOpaque(true);
            this.desktopPanel = new JPanel();
            this.desktopPanel.setLayout(new BorderLayout());
            contentPane.add((Component)this.desktopPanel, "Center");
            this.desktopPane = new JDesktopPane();
            this.desktopPanel.add((Component)this.desktopPane, "Center");
            this.desktopPane.setDropTarget(new DropTarget(this.desktopPane, 1, this));
            this.statusBar.setDropTarget(new DropTarget(this.statusBar, 1, this));
            if (container == null) {
                Dimension screenSize = this.frame.getToolkit().getScreenSize();
                this.frame.setSize(screenSize.width - 16, screenSize.height - 46);
            }
        }
        this.startup();
    }

    public static Application getInstance() {
        return instance;
    }

    public static Font getSmallSystemFont() {
        return smallSystemFont;
    }

    public void makeMenuBar() {
        this.menubar = new JMenuBar();
        this.makeMenuBar(this.menubar, null, this.appMenuBarConfig != null ? this.appMenuBarConfig : this.menuBarConfig);
        if (this.container != null) {
            this.container.add((Component)this.menubar, "North");
        } else {
            this.frame.setJMenuBar(this.menubar);
        }
        this.currentMenubar = this.menubar;
    }

    public void setModal(boolean modal) {
        if (this.isMDI) {
            this.menubar.setEnabled(!modal);
        }
    }

    public void startup() {
    }

    public void shutdown() {
    }

    protected boolean isMDI() {
        return this.container != null || this.getBooleanProperty("application.isMDI", !Application.isMacintosh());
    }

    public PluginsManager getPluginsManager() {
        return this.pluginsManager;
    }

    public void registerActions() {
        this.newAction = new NewAction();
        this.registerAction(this.newAction);
        this.openAction = new OpenAction();
        this.registerAction(this.openAction);
        this.quitAction = new QuitAction();
        this.registerAction(this.quitAction);
        this.preferencesAction = new PreferencesAction();
        this.registerAction(this.preferencesAction);
        this.helpAction = new HelpAction();
        this.registerAction(this.helpAction);
        this.aboutAction = new AboutAction();
        this.registerAction(this.aboutAction);
        this.registerAction(new ShowUIElementAction(0));
        if (this.hasToolbar) {
            this.registerAction(new ShowUIElementAction(1));
        }
        this.registerAction(new ShowUIElementAction(2));
    }

    public void registerFileHandlers() {
        try {
            Class<?> osxAdapter = this.getClass().getClassLoader().loadClass("com.jhlabs.app.mac.OSXAdapter");
            Class[] defArgs = new Class[]{Application.class};
            Method registerMethod = osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
            if (registerMethod != null) {
                Object[] args = new Object[]{this};
                registerMethod.invoke(osxAdapter, args);
            }
            defArgs[0] = Boolean.TYPE;
            Method prefsEnableMethod = osxAdapter.getDeclaredMethod("enablePrefs", defArgs);
            if (prefsEnableMethod != null) {
                Object[] args = new Object[]{Boolean.TRUE};
                prefsEnableMethod.invoke(osxAdapter, args);
            }
        }
        catch (NoClassDefFoundError e) {
            System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
        }
        catch (ClassNotFoundException e) {
            System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLookAndFeel(String className) {
        String currentLaf = UIManager.getLookAndFeel().getClass().getName();
        if (!className.equals(currentLaf)) {
            try {
                String osName = System.getProperty("os.name");
                if (className.indexOf("Windows") != -1) {
                    System.getProperties().put("os.name", "Windows");
                } else if (className.indexOf("Mac") != -1) {
                    System.getProperties().put("os.name", "Mac OS");
                }
                UIManager.setLookAndFeel(className);
                if (this.getFrame() != null) {
                    SwingUtilities.updateComponentTreeUI(this.getFrame());
                }
                System.getProperties().put("os.name", osName);
            }
            catch (Exception e) {
                Application.reportException("Can't load the specified look and feel: " + e.getMessage(), "Warning", e);
            }
        }
    }

    public void activateWindow(DocumentWindow f) {
        if (this.isMDI) {
            JFrame frame = this.getFrame();
            JMenuBar mb = f.getFrameMenuBar();
            if (this.container != null) {
                this.container.remove(this.currentMenubar);
                this.container.add((Component)mb, "North");
            } else {
                frame.setJMenuBar(mb);
            }
            this.currentMenubar = mb;
            if (this.hasToolbar) {
                frame.getContentPane().remove(this.currentToolBar);
                this.currentToolBar = f.getFrameToolBar();
                frame.getContentPane().add((Component)this.currentToolBar, "North");
                this.currentToolBar.setVisible(this.isUIElementVisible(1));
            }
            frame.invalidate();
            frame.validate();
        } else {
            this.frame = f.getJFrame();
        }
        this.setCurrentDocumentWindow(f);
        f.enableCommands();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public Component getDialogParent() {
        return this.isMDI ? this.frame : null;
    }

    public void busyCursor(boolean busy) {
        if (this.isMDI) {
            this.frame.setCursor(Cursor.getPredefinedCursor(busy ? 3 : 0));
        } else if (this.currentDocumentWindow != null) {
            this.currentDocumentWindow.busyCursor(busy);
        }
    }

    public Container getContentPane() {
        if (this.container != null) {
            return this.container;
        }
        return this.getFrame().getContentPane();
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public void addInternalFrame(JInternalFrame frame, Integer layer) {
        this.desktopPane.add((Component)frame, layer);
        frame.addInternalFrameListener(new FrameListener());
    }

    public DocumentWindow makeWindow(Document document, Object args) {
        return this.makeWindow(document, args, true);
    }

    public abstract DocumentWindow makeWindow(Document var1, Object var2, boolean var3);

    public abstract Document readDocument(File var1) throws IOException;

    public void showInternalDialog(DialogController dialog) {
        dialog.setVisible(true);
    }

    public void showInternalDialog(JInternalFrame dialog) {
        this.addInternalFrame(dialog, JDesktopPane.PALETTE_LAYER);
        Dimension dialogSize = dialog.getPreferredSize();
        Dimension deskSize = this.desktopPane.getSize();
        dialog.setBounds((deskSize.width - dialogSize.width) / 2, (deskSize.height - dialogSize.height) / 2, dialogSize.width, dialogSize.height);
        this.desktopPane.validate();
        try {
            dialog.moveToFront();
            dialog.setVisible(true);
            dialog.setSelected(true);
        }
        catch (PropertyVetoException ex) {
            // empty catch block
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    protected void loadConfigFile(InputStream is) {
        this.loadConfigFile(is, this.getClassLoader());
    }

    protected void loadConfigFile(InputStream is, ClassLoader cl) {
        try {
            XMLParser xp = new XMLParser();
            xp.setDocumentHandler(this.createDocumentHandler(cl));
            xp.parse(new InputSource(is));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public File getApplicationFolder() {
        return new File(System.getProperty("user.dir"));
    }

    public String getApplicationName() {
        return "Application";
    }

    public String getApplicationVersion() {
        return "0.0";
    }

    public static boolean isMacintosh() {
        return isMacintosh;
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public Vector getPluginActions() {
        return this.pluginActions;
    }

    public void addPlugin(Plugin o) {
        this.plugins.addElement(o);
    }

    public void registerPlugin(Object o) {
        if (this.verbosePlugins) {
            System.out.println(" Registering Plugin: " + o);
        }
        if (o instanceof ApplicationAction) {
            this.registerAction((ApplicationAction)o);
            this.pluginActions.addElement(o);
        } else if (o instanceof PluginFactory) {
            this.registerPlugin(((PluginFactory)o).createPlugin());
        } else if (o instanceof MetalTheme) {
            MetalLookAndFeel.setCurrentTheme((MetalTheme)o);
        } else if (!(o instanceof Plugin) && !(o instanceof File)) {
            Object[] arguments = new Object[]{o.getClass().getName(), "Unknown plugin type"};
            String message = MessageFormat.format(this.commonResources.getString("cantGetPlugin"), arguments);
            JOptionPane.showMessageDialog(this.getDialogParent(), message, "Error", 0);
        }
    }

    public void registerPlugins() {
        Iterator it = this.getPluginsSearchPath("plugins");
        while (it.hasNext()) {
            try {
                File folder = (File)it.next();
                if (this.verbosePlugins) {
                    System.out.println("Looking for plugins in folder " + folder);
                }
                this.registerPlugins(folder);
            }
            catch (SecurityException securityException) {}
        }
    }

    public void registerPlugins(File folder) {
        block24: {
            folder = folder.getAbsoluteFile();
            try {
                if (this.pluginsFolders.get(folder) != null) {
                    return;
                }
                this.pluginsFolders.put(folder, folder);
                if (!folder.exists()) break block24;
                String[] files = folder.list();
                for (int i = 0; i < files.length; ++i) {
                    String message;
                    Object[] arguments;
                    File file = new File(folder, files[i]);
                    String fileName = file.getPath();
                    if (fileName.startsWith(".") || fileName.startsWith("~")) continue;
                    int index = fileName.lastIndexOf(46);
                    String extension = index < 0 ? "" : fileName.substring(index).toLowerCase();
                    String baseName = index < 0 ? "" : fileName.substring(0, index);
                    String mimeType = null;
                    try {
                        FileInputStream fis = new FileInputStream(file);
                        mimeType = this.guessContentTypeFromStream(fis);
                        fis.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        if (extension.equals(".class") || "application/java-vm".equals(mimeType)) {
                            baseName.replace('/', '.');
                            Object o = Beans.instantiate(null, baseName);
                            this.registerPlugin(o);
                            continue;
                        }
                        if (extension.equals(".ser") || "application/x-java-serialized-object".equals(mimeType)) {
                            ObjectInputStream ois = null;
                            try {
                                ois = new ObjectInputStream(new FileInputStream(file));
                                Object o = ois.readObject();
                                ois.close();
                                this.registerPlugin(o);
                                continue;
                            }
                            catch (Exception ex) {
                                if (ois != null) {
                                    ois.close();
                                }
                                throw ex;
                            }
                        }
                        if (extension.equals(".xml") || "application/xml".equals(mimeType)) {
                            try {
                                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                                this.loadConfigFile(is, this.getClassLoader());
                                ((InputStream)is).close();
                            }
                            catch (Throwable e) {
                                arguments = new Object[]{fileName, e.getMessage() == null ? "?" : e.getMessage()};
                                message = MessageFormat.format(this.commonResources.getString("cantGetPlugin"), arguments);
                                Application.reportException(message, "Error", e);
                            }
                            continue;
                        }
                        if (extension.equals(".jar") || extension.equals(".zip") || "application/zip".equals(mimeType)) {
                            URL url = new URL("jar:file:" + file.getPath() + "!/");
                            if (this.verbosePlugins) {
                                System.out.println(" Looking for plugins in jar file " + url);
                            }
                            URLClassLoader cl = new URLClassLoader(new URL[]{url});
                            JarURLConnection connection = (JarURLConnection)url.openConnection();
                            Manifest manifest = connection.getManifest();
                            Map<String, Attributes> entries = manifest.getEntries();
                            Iterator<String> it = entries.keySet().iterator();
                            while (it.hasNext()) {
                                String beanName = it.next();
                                Attributes attributes = entries.get(beanName);
                                String isBean = attributes.getValue("Java-Bean");
                                if (isBean == null || !isBean.equalsIgnoreCase("True")) continue;
                                try {
                                    if (beanName.endsWith(".class")) {
                                        beanName = beanName.substring(0, beanName.length() - 6);
                                    }
                                    beanName = beanName.replace('/', '.');
                                    Class<?> cls = Class.forName(beanName, true, cl);
                                    Object o = cls.newInstance();
                                    this.registerPlugin(o);
                                }
                                catch (Exception e) {
                                    Object[] arguments2 = new Object[]{beanName, e.getMessage() == null ? "?" : e.getMessage()};
                                    String message2 = MessageFormat.format(this.commonResources.getString("cantGetPlugin"), arguments2);
                                    Application.reportException(message2, "Error", e);
                                }
                            }
                            continue;
                        }
                        this.registerPlugin(file);
                        continue;
                    }
                    catch (Exception e) {
                        if (debugLevel > 0) {
                            e.printStackTrace();
                        }
                        arguments = new Object[]{fileName, e.getMessage() == null ? "?" : e.getMessage()};
                        message = MessageFormat.format(this.commonResources.getString("cantGetPlugin"), arguments);
                        Application.reportException(message, "Error", e);
                    }
                }
            }
            catch (SecurityException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showMessage(e.getMessage());
            }
        }
    }

    public Iterator getPluginsSearchPath(String name) {
        Vector<File> folders = new Vector<File>();
        File appFolder = null;
        try {
            String folder;
            URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            File file = new File(new URI(url.toString()));
            if (file != null && (folder = file.getParent()) != null) {
                appFolder = new File(folder, name);
                folders.add(appFolder);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String s = this.getProperty("pluginsFolder", null);
        if (s != null) {
            folders.add(new File(s));
        }
        if (Application.isMacintosh()) {
            String library = "/Library/Application Support/" + this.getApplicationName() + "/" + name;
            try {
                folders.add(new File(System.getProperty("user.home"), library));
            }
            catch (SecurityException e) {
                // empty catch block
            }
            folders.add(new File(library));
        }
        try {
            folders.add(new File(new File(System.getProperty("user.home"), ".imageeditor"), name));
        }
        catch (SecurityException e) {
            // empty catch block
        }
        return folders.iterator();
    }

    public void registerLibraries() {
        try {
            File libraryBase = new File(this.getProperty("libraryFolder", "libraries"));
            if (libraryBase.exists()) {
                String[] files = libraryBase.list();
                for (int i = 0; i < files.length; ++i) {
                    File file = new File(libraryBase, files[i]);
                    try {
                        URL url = new URL("jar:file:" + file.getName() + "!/");
                        URLClassLoader cl = new URLClassLoader(new URL[]{url});
                        continue;
                    }
                    catch (Exception e) {
                        if (debugLevel > 0) {
                            e.printStackTrace();
                        }
                        Object[] arguments = new Object[]{file.getName(), e.getMessage() == null ? "?" : e.getMessage()};
                        String message = MessageFormat.format(this.commonResources.getString("cantGetLibrary"), arguments);
                        Application.reportException(message, "Error", e);
                    }
                }
            }
        }
        catch (SecurityException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showMessage(e.getMessage());
        }
    }

    protected DocumentHandler createDocumentHandler(ClassLoader classLoader) {
        return new ConfigDocumentHandler(classLoader);
    }

    public String guessContentTypeFromStream(InputStream is) throws IOException {
        is.mark(10);
        int c1 = is.read();
        int c2 = is.read();
        int c3 = is.read();
        int c4 = is.read();
        int c5 = is.read();
        int c6 = is.read();
        int c7 = is.read();
        int c8 = is.read();
        is.reset();
        if (c1 == 202 && c2 == 254 && c3 == 186 && c4 == 190) {
            return "application/java-vm";
        }
        if (c1 == 172 && c2 == 237) {
            return "application/x-java-serialized-object";
        }
        if (c1 == 80 && c2 == 75) {
            return "application/zip";
        }
        if (c1 == 31 && c2 == 139) {
            return "application/gzip";
        }
        return null;
    }

    public void setUIElementVisible(int element, boolean show) {
        this.visibleUIElements = show ? (this.visibleUIElements |= 1 << element) : (this.visibleUIElements &= ~(1 << element));
        JFrame frame = this.getFrame();
        switch (element) {
            case 0: {
                frame.getJMenuBar().setVisible(show);
                break;
            }
            case 1: {
                if (!this.hasToolbar) break;
                this.currentToolBar.setVisible(show);
                break;
            }
            case 2: {
                this.statusBar.setVisible(show);
            }
        }
        frame.invalidate();
        frame.validate();
    }

    public boolean isUIElementVisible(int element) {
        return (this.visibleUIElements & 1 << element) != 0;
    }

    public JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(System.getProperty("user.dir"));
        }
        return this.fileChooser;
    }

    public void doNew() {
    }

    public File getFileToOpen() {
        File file = null;
        if (this.useFileChooser) {
            JFileChooser fileChooser = this.getFileChooser();
            fileChooser.rescanCurrentDirectory();
            if (fileChooser.showOpenDialog(this.getFrame()) == 0) {
                file = fileChooser.getSelectedFile();
            }
        } else {
            String directory = null;
            String fileName = null;
            FileDialog dialog = new FileDialog((Frame)this.frame, "File to open", 0);
            if (this.lastDirectory != null) {
                dialog.setDirectory(this.lastDirectory);
            }
            dialog.setVisible(true);
            this.lastDirectory = directory = dialog.getDirectory();
            fileName = dialog.getFile();
            if (fileName != null) {
                file = new File(directory, fileName);
            }
        }
        return file;
    }

    public File getFileToSave() {
        File file = null;
        if (this.useFileChooser) {
            JFileChooser fileChooser = this.getFileChooser();
            fileChooser.rescanCurrentDirectory();
            if (fileChooser.showSaveDialog(this.getFrame()) == 0) {
                file = fileChooser.getSelectedFile();
            }
        } else {
            String directory = null;
            String fileName = null;
            FileDialog dialog = new FileDialog((Frame)this.frame, "File to save", 1);
            if (this.lastDirectory != null) {
                dialog.setDirectory(this.lastDirectory);
            }
            dialog.setVisible(true);
            this.lastDirectory = directory = dialog.getDirectory();
            fileName = dialog.getFile();
            if (fileName != null) {
                file = new File(directory, fileName);
            }
        }
        return file;
    }

    public void doOpen() {
        File file = this.getFileToOpen();
        if (file != null) {
            this.doOpen(file);
        }
    }

    public void doOpen(File file) {
        this.busyCursor(true);
        for (int i = 0; i < this.windows.size(); ++i) {
            DocumentWindow w = (DocumentWindow)this.windows.elementAt(i);
            Document document = w.getDocument();
            if (!file.equals(document.getFile())) continue;
            w.toFront();
            return;
        }
        try {
            Document document = this.readDocument(file);
            document.setFile(file);
            this.makeWindow(document, null);
            this.addRecentFile(file);
        }
        catch (Exception e) {
            String msg;
            if (debugLevel != 0) {
                e.printStackTrace();
            }
            if ((msg = e.getMessage()) == null) {
                msg = e.toString();
            }
            Object[] arguments = new Object[]{file.getName(), msg};
            String message = MessageFormat.format(this.commonResources.getString("cantOpenFile"), arguments);
            Application.reportException(message, "Error", e);
        }
        this.busyCursor(false);
    }

    protected JToolBar makeToolbar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        String[] itemList = this.getStringListProperty("applicationToolbar", "");
        if (itemList != null) {
            for (int i = 0; i < itemList.length; ++i) {
                String name = itemList[i];
                if (name.equals("-")) {
                    toolBar.addSeparator();
                    continue;
                }
                Action action = this.getAction(name);
                if (action == null) continue;
                JButton b = this.makeToolbarButton(action);
                toolBar.add(b);
            }
        }
        return toolBar;
    }

    protected JButton makeToolbarButton(Action action) {
        String name = (String)action.getValue("Name");
        Icon icon = (Icon)action.getValue("SmallIcon");
        JButton b = icon != null ? new JButton(icon) : new JButton(name);
        b.setMargin(DocumentController.noInsets);
        b.setToolTipText(name);
        b.addActionListener(action);
        return b;
    }

    public String localize(String name) {
        try {
            return this.commonResources.getString(name);
        }
        catch (MissingResourceException e) {
            return name;
        }
    }

    protected void addMenuItem(JMenu menu, Action action, char accelerator) {
        this.addMenuItem(menu, action, accelerator, '\u0000');
    }

    protected BufferedImage getSplashImage() {
        return null;
    }

    protected String getDocumentWindowImage() {
        return null;
    }

    public String getVersionString() {
        return "";
    }

    public void showSplashScreen() {
        if (this.splashWindow == null) {
            BufferedImage splashImage = this.getSplashImage();
            if (splashImage != null) {
                this.splashWindow = new SplashWindow(this, this.frame, splashImage);
                new Thread(this.splashWindow).start();
            }
        } else {
            this.splashWindow.toFront();
        }
    }

    public void hideSplashScreen() {
        if (this.splashWindow != null) {
            this.splashWindow.dispose();
        }
        this.splashWindow = null;
    }

    public void setSplashMessage(String message) {
        if (this.splashWindow != null) {
            this.splashWindow.setMessage(message);
        }
    }

    public void doAbout() {
        Object[] arguments = new Object[]{this.getApplicationName(), this.getApplicationVersion()};
        String title = MessageFormat.format(this.commonResources.getString("aboutTitle"), arguments);
        String about = MessageFormat.format(this.commonResources.getString("aboutMessage"), arguments);
        JOptionPane.showMessageDialog(this.getDialogParent(), about, title, 1, null);
    }

    public void doPreferences() {
    }

    public void setExitOnQuit(boolean exitOnQuit) {
        this.exitOnQuit = exitOnQuit;
    }

    public boolean getExitOnQuit() {
        return this.exitOnQuit;
    }

    public void doQuit() {
        DocumentWindow f;
        for (int i = this.windows.size() - 1; i >= 0 && (f = (DocumentWindow)this.windows.elementAt(i)).confirmClose(true); --i) {
            f.doClose(true);
        }
        if (this.windows.size() == 0) {
            this.finish();
        }
    }

    protected void finish() {
        if (this.plugins != null) {
            for (int i = 0; i < this.plugins.size(); ++i) {
                Plugin p = (Plugin)this.plugins.elementAt(i);
                p.shutdown();
            }
        }
        this.shutdown();
        if (this.exitOnQuit) {
            System.exit(0);
        } else {
            this.frame.dispose();
        }
    }

    public void closeLastWindow(DocumentWindow window) {
        this.removeWindow(window);
        this.setCurrentDocumentWindow(null);
        window.dispose();
        if (!this.isMDI && !Application.isMacintosh()) {
            this.finish();
        }
    }

    public void closeWindow(DocumentWindow window, boolean quitting) {
        if (this.isMDI) {
            this.removeWindow(window);
            if (window == this.getCurrentDocumentWindow()) {
                this.setCurrentDocumentWindow(null);
            }
            window.dispose();
        } else if (!quitting && this.windows.size() == 1) {
            this.closeLastWindow(window);
        } else {
            this.removeWindow(window);
            this.setCurrentDocumentWindow(null);
            window.dispose();
        }
        System.gc();
        System.runFinalization();
        if (debugLevel > 0) {
            this.dump(System.out);
        }
    }

    protected void addWindow(DocumentWindow window) {
        if (this.windows.contains(window)) {
            return;
        }
        this.windows.addElement(window);
        if (this.isMDI) {
            AppInternalFrame frame = window.getInternalFrame();
            this.addInternalFrame(frame, JLayeredPane.DEFAULT_LAYER);
            frame.moveToFront();
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            window.getJFrame().setVisible(true);
        }
        this.windowsChanged();
    }

    protected void removeWindow(DocumentWindow window) {
        this.windows.removeElement(window);
        this.windowsChanged();
    }

    protected void windowsChanged() {
        this.changeSupport.firePropertyChange(WINDOWS_PROPERTY, null, this.windows);
    }

    public Enumeration getWindows() {
        return this.windows.elements();
    }

    public DocumentWindow getWindow(int id) {
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            DocumentWindow f = (DocumentWindow)this.windows.elementAt(i);
            if (id != f.getUniqueID()) continue;
            return f;
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    public void setCurrentDocument(Document document) {
        Document oldValue = this.currentDocument;
        this.currentDocument = document;
        this.changeSupport.firePropertyChange(CURRENT_DOCUMENT_PROPERTY, oldValue, this.currentDocument);
        this.mainController.enableCommands();
    }

    public Document getCurrentDocument() {
        return this.currentDocument;
    }

    public void setCurrentDocumentWindow(DocumentWindow window) {
        DocumentWindow oldValue = this.currentDocumentWindow;
        this.currentDocumentWindow = window;
        if (window != null) {
            this.setCurrentDocument(window.getDocument());
        } else {
            this.setCurrentDocument(null);
        }
        this.changeSupport.firePropertyChange(CURRENT_WINDOW_PROPERTY, oldValue, this.currentDocumentWindow);
    }

    public DocumentWindow getCurrentDocumentWindow() {
        return this.currentDocumentWindow;
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.preferences.getProperty(key, null);
        if (value != null) {
            return value;
        }
        value = this.properties.getProperty(key, null);
        if (value != null) {
            return value;
        }
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    public void setProperty(String key, String value) {
        this.preferences.setProperty(key, value);
    }

    public void setProperty(String key, int value) {
        String v = Integer.toString(value);
        this.preferences.setProperty(key, v);
    }

    public String[] getStringListProperty(String key, String defaultValue) {
        String s = this.getProperty(key, defaultValue);
        if (s != null) {
            return StringUtils.stringToArray(s, ",", true);
        }
        return null;
    }

    public int getIntegerProperty(String key, int defaultValue) {
        try {
            String s = this.getProperty(key, null);
            if (s != null) {
                return Integer.parseInt(s);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public Color getColorProperty(String name, Color defaultValue) {
        String s = this.getProperty(name, null);
        if (s != null) {
            if (s.indexOf(44) != -1) {
                return this.parseRGB(s, defaultValue);
            }
            try {
                return new Color(Integer.decode(s));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public Color parseRGB(String rgb, Color defaultValue) {
        String[] s = StringUtils.stringToArray(rgb, ",", true);
        if (s.length != 3) {
            return defaultValue;
        }
        try {
            int red = Integer.parseInt(s[0]);
            int green = Integer.parseInt(s[1]);
            int blue = Integer.parseInt(s[2]);
            return new Color(red, green, blue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double getDoubleProperty(String key, double defaultValue) {
        try {
            String s = this.getProperty(key, null);
            if (s != null) {
                return Double.valueOf(s);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return defaultValue;
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String s = this.getProperty(key, null);
        if (s != null) {
            return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("on") || s.equalsIgnoreCase("yes");
        }
        return defaultValue;
    }

    public void openFiles(String[] files) {
        for (int i = 0; i < files.length; ++i) {
            File file = new File(files[i]);
            this.doOpen(file);
        }
    }

    public void openFiles(Collection files) {
        Iterator it = files.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            this.doOpen(file);
        }
    }

    public void addRecentFile(File file) {
        String path = file.getPath();
        String next = this.recentFiles[0];
        this.recentFiles[0] = path;
        for (int i = 1; i < this.recentFiles.length && !path.equals(next); ++i) {
            String t = next;
            next = this.recentFiles[i];
            this.recentFiles[i] = t;
        }
        this.writeRecentFilesToPreferences();
        this.changeSupport.firePropertyChange(RECENT_FILES_PROPERTY, null, this.recentFiles);
    }

    public void readRecentFilesFromPreferences() {
        Preferences preferences = null;
        try {
            preferences = Preferences.userNodeForPackage(this.getClass());
            for (int i = 0; i < this.recentFiles.length; ++i) {
                this.recentFiles[i] = preferences.get("recentFile" + i, null);
            }
            this.changeSupport.firePropertyChange(RECENT_FILES_PROPERTY, null, this.recentFiles);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void writeRecentFilesToPreferences() {
        Preferences preferences = null;
        try {
            preferences = Preferences.userNodeForPackage(this.getClass());
            for (int i = 0; i < this.recentFiles.length; ++i) {
                String key = "recentFile" + i;
                if (this.recentFiles[i] != null) {
                    preferences.put(key, this.recentFiles[i]);
                    continue;
                }
                preferences.remove(key);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void makeRecentFilesMenu(JMenu menu) {
        menu.removeAll();
        for (int i = 0; i < this.recentFiles.length; ++i) {
            if (this.recentFiles[i] == null) continue;
            OpenMenuItem item = new OpenMenuItem(this.recentFiles[i]);
            menu.add(item);
        }
    }

    public void showMessage(String message) {
        if (this.isMDI) {
            if (this.statusLabel != null) {
                if (message.length() == 0) {
                    message = " ";
                }
                this.statusLabel.setText(message);
                if (!this.inPaint) {
                    this.statusLabel.paintImmediately(new Rectangle(this.statusLabel.getSize()));
                }
            }
        } else {
            DocumentWindow w = this.getCurrentDocumentWindow();
            if (w != null) {
                w.showMessage(message);
            }
        }
    }

    public void showProgress(int percentage) {
        this.showMessage(percentage + "%");
    }

    public void showHelpTopic(String topic) {
        HelpWindow helpWindow = new HelpWindow(topic);
        helpWindow.setVisible(true);
    }

    public static void reportException(String message, String title, Throwable e) {
        if (JOptionPane.showOptionDialog(null, message, title, -1, 0, null, new Object[]{"OK", "Details"}, "OK") == 1) {
            JTextArea text = new JTextArea();
            PrintStream pw = new PrintStream(new DocumentOutputStream(text.getDocument()));
            pw.println(message);
            pw.println("The full stack trace follows:");
            pw.println();
            e.printStackTrace(pw);
            pw.close();
            JScrollPane sp = new JScrollPane(text);
            JOptionPane.showMessageDialog(Application.getInstance().getDialogParent(), sp, "Error Details", -1);
        }
    }

    public Iterator getPluginIterator(String base) {
        return new PluginIterator(base);
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
        } else {
            e.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
        } else {
            e.rejectDrag();
        }
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent e) {
        try {
            Transferable transferable = e.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                e.acceptDrop(1);
                this.openFiles((Collection)transferable.getTransferData(DataFlavor.javaFileListFlavor));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            e.rejectDrop();
        }
        finally {
            try {
                e.getDropTargetContext().dropComplete(true);
            }
            catch (Exception exception) {}
        }
    }

    public void dump(PrintStream out) {
        out.println("Windows: " + this.windows);
        out.println("Current Window: " + this.getCurrentDocumentWindow());
        out.println("Current Document: " + this.getCurrentDocument());
    }

    static {
        debugLevel = 0;
        smallSystemFont = new Font("dialog", 0, 11);
    }

    class ShowUIElementAction
    extends ApplicationAction {
        private int type;

        public ShowUIElementAction(int type) {
            super(type == 0 ? "showMenuBar" : (type == 1 ? "showToolBar" : "showStatusBar"), Application.this.commonResources);
            this.type = type;
        }

        public void actionPerformed(ActionEvent e) {
            Application.this.setUIElementVisible(this.type, !Application.this.isUIElementVisible(this.type));
        }
    }

    public class ShowWindowAction
    extends AbstractAction {
        private AppInternalFrame frame;
        private DocumentWindow window;
        private boolean hideIt;

        public ShowWindowAction(String name, AppInternalFrame frame) {
            this(name, frame, true);
        }

        public ShowWindowAction(String name, AppInternalFrame frame, boolean hideIt) {
            super(name);
            this.hideIt = true;
            this.frame = frame;
            this.hideIt = hideIt;
        }

        public ShowWindowAction(String name, DocumentWindow window, boolean hideIt) {
            super(name);
            this.hideIt = true;
            this.window = window;
            this.hideIt = hideIt;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.frame != null) {
                if (this.frame.isIcon()) {
                    try {
                        this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else if (this.hideIt) {
                    this.frame.setVisible(!this.frame.isVisible());
                } else if (this.frame.isVisible()) {
                    this.frame.moveToFront();
                } else {
                    this.frame.setVisible(true);
                }
            } else if (this.window != null) {
                if (this.hideIt) {
                    this.window.setVisible(!this.window.isVisible());
                } else if (this.window.isVisible()) {
                    this.window.toFront();
                } else {
                    this.window.setVisible(true);
                }
            }
        }
    }

    class AboutAction
    extends ApplicationAction {
        public AboutAction() {
            super("about", Application.this.commonResources, "About24");
        }

        public void actionPerformed(ActionEvent e) {
            Application.this.doAbout();
        }
    }

    class HelpAction
    extends ApplicationAction {
        public HelpAction() {
            super("help", Application.this.commonResources, "Help24");
        }

        public void actionPerformed(ActionEvent e) {
            Application.this.showHelpTopic(null);
        }
    }

    class PreferencesAction
    extends ApplicationAction {
        public PreferencesAction() {
            super("preferences", Application.this.commonResources, "Preferences24");
        }

        public void actionPerformed(ActionEvent e) {
            Application.this.doPreferences();
        }
    }

    class QuitAction
    extends ApplicationAction {
        public QuitAction() {
            super("quit", Application.this.commonResources);
        }

        public void actionPerformed(ActionEvent e) {
            Application.this.doQuit();
        }
    }

    class OpenAction
    extends ApplicationAction {
        public OpenAction() {
            super("open", Application.this.commonResources, "Open24");
        }

        public void actionPerformed(ActionEvent e) {
            Application.this.doOpen();
        }
    }

    class NewAction
    extends ApplicationAction {
        public NewAction() {
            super("new", Application.this.commonResources, "New24");
        }

        public void actionPerformed(ActionEvent e) {
            Application.this.doNew();
        }
    }

    private class PluginIterator
    implements Iterator {
        private String base;
        private Iterator roots;
        private FileIterator iterator;

        public PluginIterator(String base) {
            this.base = base;
            this.roots = Application.this.getPluginsSearchPath(base);
            this.advance();
        }

        private void advance() {
            do {
                this.iterator = this.roots.hasNext() ? new FileIterator((File)this.roots.next()) : null;
            } while (this.iterator != null && !this.iterator.hasNext());
        }

        public boolean hasNext() {
            return this.iterator != null;
        }

        public Object next() {
            Object o = this.iterator.next();
            if (!this.iterator.hasNext()) {
                this.advance();
            }
            return o;
        }

        public void remove() {
        }
    }

    private static class FileIterator
    implements Iterator {
        private File dir;
        private String[] files;
        private int index = 0;
        private FileIterator subIterator;
        private Object nextFile;

        public FileIterator(File dir) {
            this.dir = dir;
            this.files = dir.list();
            this.advance();
        }

        public boolean hasNext() {
            return this.nextFile != null;
        }

        public Object next() {
            Object f = this.nextFile;
            this.advance();
            return f;
        }

        private boolean advance() {
            block2: {
                File file;
                this.nextFile = null;
                while (true) {
                    if (this.subIterator != null && this.subIterator.hasNext()) {
                        this.nextFile = this.subIterator.next();
                        return true;
                    }
                    this.subIterator = null;
                    if (this.files == null || this.index >= this.files.length) break block2;
                    if (!(file = new File(this.dir, this.files[this.index++])).isDirectory()) break;
                    this.subIterator = new FileIterator(file);
                }
                this.nextFile = file;
                return true;
            }
            return false;
        }

        public void remove() {
        }
    }

    class OpenMenuItem
    extends JMenuItem
    implements ActionListener {
        private String file;

        public OpenMenuItem(String file) {
            super(new File(file).getName());
            this.file = file;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            Application.this.doOpen(new File(this.file));
        }
    }

    public class ConfigDocumentHandler
    extends HandlerBase {
        private ClassLoader classLoader;
        private MenuBarTag menubar;
        private MenuTag menu;

        public ConfigDocumentHandler(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public void startElement(String tag, AttributeList attrs) throws SAXException {
            boolean macAvailable;
            String mac = attrs.getValue("mac");
            boolean bl = macAvailable = mac == null || mac.equals("true");
            if (!macAvailable && Application.isMacintosh()) {
                return;
            }
            if (tag.equals("plugin")) {
                String beanName = attrs.getValue("bean");
                try {
                    Object o = Beans.instantiate(this.classLoader, beanName);
                    Application.this.registerPlugin(o);
                }
                catch (Throwable e) {
                    Object[] arguments = new Object[]{beanName, e.getMessage() == null ? "?" : e.getMessage()};
                    String message = MessageFormat.format(Application.this.commonResources.getString("cantGetPlugin"), arguments);
                    Application.reportException(message, "Error", e);
                }
            } else if (!(tag.equals("plugin-suite") || tag.equals("plugin-type") || tag.equals("application"))) {
                if (tag.equals("properties")) {
                    int count = attrs.getLength();
                    for (int i = 0; i < count; ++i) {
                        Application.this.preferences.put(attrs.getName(i), attrs.getValue(i));
                    }
                } else if (tag.equals("menubar")) {
                    this.menubar = new MenuBarTag();
                    if ("application".equals(attrs.getValue("name"))) {
                        Application.this.appMenuBarConfig = this.menubar;
                    } else {
                        Application.this.menuBarConfig = this.menubar;
                    }
                } else if (tag.equals("toolbar")) {
                    Application.this.toolbarItems = new Vector();
                } else if (tag.equals("menu")) {
                    this.menu = new MenuTag(attrs.getValue("name"), attrs.getValue("mnemonic"));
                    this.menubar.addElement(this.menu);
                } else if (tag.equals("item")) {
                    if (this.menu != null) {
                        this.menu.addElement(new MenuItemTag(attrs.getValue("name"), attrs.getValue("mnemonic"), attrs.getValue("shortcut"), XMLUtils.getBooleanValue(attrs, "checkable", false)));
                    } else if (Application.this.toolbarItems != null) {
                        Application.this.toolbarItems.addElement(attrs.getValue("name"));
                    }
                } else if (tag.equals("separator")) {
                    if (this.menu != null) {
                        this.menu.addElement(Application.this.SEPARATOR);
                    } else if (Application.this.toolbarItems != null) {
                        Application.this.toolbarItems.addElement(null);
                    }
                }
            }
        }

        public void endElement(String tag) throws SAXException {
            if (tag.equals("menu")) {
                this.menu = null;
            }
        }
    }

    public class MenuItemTag
    extends MenuTag {
        public char shortcut;
        public boolean isCheckable;

        public MenuItemTag(String name, String mnemonic, String shortcut, boolean isCheckable) {
            super(name, mnemonic);
            if (shortcut != null && shortcut.length() > 0) {
                this.shortcut = shortcut.charAt(0);
            }
            this.isCheckable = isCheckable;
        }

        public void write(PrintStream out, int level) throws IOException {
            if (this == Application.this.SEPARATOR) {
                this.indent(out, level);
                out.println("<separator/>");
            } else {
                String s = "<item name='" + this.name + "'";
                if (this.mnemonic != '\u0000') {
                    s = s + " mnemonic='" + this.mnemonic + "'";
                }
                if (this.shortcut != '\u0000') {
                    s = s + " mnemonic='" + this.shortcut + "'";
                }
                if (this.isCheckable) {
                    s = s + " checkable='true'";
                }
                this.indent(out, level);
                out.print(s);
                out.println("/>");
            }
        }
    }

    public class MenuTag
    extends MenuBarTag {
        public String name;
        public char mnemonic;

        public MenuTag(String name, String mnemonic) {
            this.name = name;
            if (mnemonic != null && mnemonic.length() > 0) {
                this.mnemonic = mnemonic.charAt(0);
            }
        }

        public void write(PrintStream out, int level) throws IOException {
            this.indent(out, level);
            out.println("<menu name='" + this.name + "' mnemonic='" + this.mnemonic + "'>");
            this.writeChildren(out, level + 1);
            this.indent(out, level);
            out.println("</menu>");
        }

        public String toString() {
            return this.name;
        }
    }

    public class MenuBarTag
    extends Vector {
        public void write(PrintStream out, int level) throws IOException {
            this.indent(out, level);
            out.println("<menubar>");
            this.writeChildren(out, level + 1);
            this.indent(out, level);
            out.println("</menubar>");
        }

        public void writeChildren(PrintStream out, int level) throws IOException {
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                MenuTag o = (MenuTag)e.nextElement();
                o.write(out, level);
            }
        }

        public void indent(PrintStream out, int level) throws IOException {
            while (level-- > 0) {
                out.print(" ");
            }
        }

        public String toString() {
            return "Menu Bar";
        }
    }

    class FrameListener
    extends InternalFrameAdapter {
        FrameListener() {
        }

        public void internalFrameClosed(InternalFrameEvent e) {
            JInternalFrame frame = Application.this.desktopPane.getSelectedFrame();
            if (frame != null) {
                frame.requestFocus();
            }
        }
    }

    class ApplicationCloser
    extends WindowAdapter {
        ApplicationCloser() {
        }

        public void windowClosing(WindowEvent e) {
            Application.this.doQuit();
        }
    }
}

