/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;

public class BetterDesktopManager
extends DefaultDesktopManager {
    static final int DEFAULT_RESIZE_MODE = 0;
    static final int OUTLINE_RESIZE_MODE = 1;
    int resizeMode = 0;
    transient Rectangle currentRect = null;

    public void beginResizingFrame(JComponent f, int direction) {
        JDesktopPane p = this.getFrameDesktopPane(f);
        String mode = (String)p.getClientProperty("JDesktopPane.dragMode");
        if (mode == null) {
            this.resizeMode = 0;
        } else if (mode.equals("outline")) {
            this.resizeMode = 1;
        }
    }

    private JDesktopPane getFrameDesktopPane(JComponent frame) {
        JDesktopPane pane = null;
        Container c = frame.getParent();
        while (pane == null) {
            if (c instanceof JDesktopPane) {
                pane = (JDesktopPane)c;
                continue;
            }
            if (c == null) break;
            c = c.getParent();
        }
        return pane;
    }

    public void resizeFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
        if (this.resizeMode == 0) {
            this.setBoundsForFrame(f, newX, newY, newWidth, newHeight);
        } else {
            JDesktopPane desktopPane = this.getFrameDesktopPane(f);
            Graphics g = desktopPane.getGraphics();
            g.setXORMode(Color.white);
            if (this.currentRect != null) {
                g.drawRect(this.currentRect.x, this.currentRect.y, this.currentRect.width - 1, this.currentRect.height - 1);
            }
            g.drawRect(newX, newY, newWidth - 1, newHeight - 1);
            this.currentRect = new Rectangle(newX, newY, newWidth, newHeight);
            g.setPaintMode();
            g.dispose();
        }
    }

    public void endResizingFrame(JComponent f) {
        if (this.resizeMode == 1 && this.currentRect != null) {
            this.setBoundsForFrame(f, this.currentRect.x, this.currentRect.y, this.currentRect.width, this.currentRect.height);
            this.currentRect = null;
        }
    }
}

