/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import com.jhlabs.app.Application;
import com.jhlabs.app.DocumentController;
import com.jhlabs.app.DocumentWindow;
import com.jhlabs.app.Task;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;

public abstract class Document {
    protected transient File file;
    public transient boolean changed = false;
    public transient boolean reusable = false;
    protected transient Vector views = new Vector();
    protected transient PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    protected transient UndoableEditSupport undoSupport = new UndoableEditSupport(this);
    public transient boolean taskDone = false;
    public transient UndoManager undoManager;
    private transient DocumentController controller;
    private Application application;
    protected String title;
    private transient int documentNumber = 0;
    private static int documentIndex = 0;
    public static final String CHANGED_PROPERTY = "changed";
    public static final String FILE_PROPERTY = "file";
    public static final String VIEWS_PROPERTY = "views";

    public Document(Application application) {
        this.application = application;
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1);
        this.documentNumber = ++documentIndex;
    }

    public void newDocument() {
    }

    public abstract void readFile(File var1) throws IOException;

    public abstract void writeFile(File var1) throws IOException;

    public Application getApplication() {
        return this.application;
    }

    public void setController(DocumentController controller) {
        this.controller = controller;
        controller.addDocument(this);
    }

    public DocumentController getController() {
        return this.controller;
    }

    public void setDocumentNumber(int documentNumber) {
        this.documentNumber = documentNumber;
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (this.file == null) {
            return "Untitled" + this.documentNumber;
        }
        return this.file.getName();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (Application.debugLevel > 0) {
            System.out.println("Document.setFile(" + file + ")");
        }
        if (this.file != file) {
            File oldFile = this.file;
            this.file = file;
            this.reusable = false;
            this.changeSupport.firePropertyChange(FILE_PROPERTY, oldFile, file);
        }
    }

    public String getSaveFilename() {
        String name = this.file != null ? this.file.getName() : this.getTitle();
        return name;
    }

    public void addView(Object v) {
        if (Application.debugLevel > 0) {
            System.out.println("Document.addView(" + v + ")");
        }
        this.views.addElement(v);
        this.changeSupport.firePropertyChange(VIEWS_PROPERTY, null, this.views);
    }

    public void removeView(Object v) {
        if (Application.debugLevel > 0) {
            System.out.println("Document.removeView(" + v + ")");
        }
        this.views.removeElement(v);
        this.changeSupport.firePropertyChange(VIEWS_PROPERTY, null, this.views);
        if (this.views.size() == 0) {
            this.closeDocument();
        }
    }

    public int numViews() {
        return this.views.size();
    }

    public Enumeration getViews() {
        return this.views.elements();
    }

    public int getViewNumber() {
        long viewNos = 0L;
        Enumeration e = this.getViews();
        while (e.hasMoreElements()) {
            DocumentWindow w = (DocumentWindow)e.nextElement();
            viewNos |= (long)(1 << w.getViewNumber());
        }
        for (int i = 0; i < 64; ++i) {
            if ((viewNos & (long)(1 << i)) != 0L) continue;
            return i;
        }
        return this.numViews() + 1;
    }

    public void closeDocument() {
        if (Application.debugLevel > 0) {
            System.out.println("Document.closeDocument()");
        }
        this.controller.removeDocument(this);
        this.dispose();
    }

    public void dispose() {
        if (Application.debugLevel > 0) {
            System.out.println("Document.dispose()");
        }
        this.file = null;
        this.views = null;
        this.changeSupport = null;
        this.undoSupport = null;
        this.undoManager = null;
        this.controller = null;
    }

    public void setChanged(boolean changed) {
        if (changed != this.changed) {
            this.changed = changed;
            this.setReusable(false);
            this.changeSupport.firePropertyChange(CHANGED_PROPERTY, null, null);
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setReusable(boolean reusable) {
        this.reusable = reusable;
    }

    public boolean isReusable() {
        return this.reusable;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (Application.debugLevel > 0) {
            System.out.println("Document.addPropertyChangeListener(" + l + ")");
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (Application.debugLevel > 0) {
            System.out.println("Document.removePropertyChangeListener(" + l + ")");
        }
        this.changeSupport.removePropertyChangeListener(l);
    }

    public void addUndoableEditListener(UndoableEditListener l) {
        this.undoSupport.addUndoableEditListener(l);
    }

    public void removeUndoableEditListener(UndoableEditListener l) {
        this.undoSupport.removeUndoableEditListener(l);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void doTask(Task task) {
        try {
            task.doTask();
            this.completeTask(task);
        }
        catch (Exception e) {
            if (Application.debugLevel > 0) {
                e.printStackTrace();
            }
            ResourceBundle commonResources = ResourceBundle.getBundle("com.jhlabs.app.CommonResourceBundle");
            Object[] arguments = new Object[]{e.getMessage() != null ? e.getMessage() : e.toString()};
            String message = MessageFormat.format(commonResources.getString("cantPerformTask"), arguments);
            this.getApplication();
            Application.reportException(message, "Error", e);
        }
    }

    public void completeTask(Task task) {
        this.undoManager.addEdit(task);
        this.taskDone = true;
        this.setChanged(true);
        this.undoSupport.postEdit(task);
    }

    public void doUndo() {
        if (this.undoManager.canUndoOrRedo()) {
            if (this.undoManager.getLimit() == 1) {
                if (this.taskDone) {
                    this.undoManager.undo();
                } else {
                    this.undoManager.redo();
                }
                this.taskDone = !this.taskDone;
            } else if (this.undoManager.canUndo()) {
                this.undoManager.undo();
            }
        }
    }

    public void doRedo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public String toString() {
        return this.getTitle();
    }

    public void finalize() {
        if (Application.debugLevel > 0) {
            System.out.println("Document.finalize()");
        }
    }
}

