/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import com.jhlabs.app.StatusDisplay;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class ProgressReader
extends FilterReader {
    private StatusDisplay status;
    private int amountRead;
    private int limit = 0;

    public ProgressReader(Reader in, int limit, StatusDisplay status) {
        super(in);
        this.status = status;
        this.limit = limit;
    }

    public int read() throws IOException {
        ++this.amountRead;
        return super.read();
    }

    public int read(char[] b, int off, int len) throws IOException {
        this.amountRead += len;
        if (this.limit != 0) {
            this.status.showProgress(this.amountRead * 100 / this.limit);
        }
        return super.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        this.amountRead = (int)((long)this.amountRead + n);
        return super.skip(n);
    }
}

