/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.awt;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Dragger
implements MouseMotionListener,
MouseListener {
    public int startX;
    public int startY;
    public int lastX;
    public int lastY;
    public int currX;
    public int currY;
    public boolean dragged;
    public Rectangle pinRect;
    public MouseEvent event;
    protected Component component;
    private static Dragger currentDragger;
    protected boolean drawBeforeErase = true;

    public void startDrag(Component c, MouseEvent e) {
        this.component = c;
        this.mousePressed(e);
    }

    public void mousePressed(MouseEvent e) {
        if (currentDragger != null) {
            this.component.removeMouseListener(currentDragger);
            this.component.removeMouseMotionListener(currentDragger);
            currentDragger = null;
        }
        currentDragger = this;
        this.event = e;
        this.lastX = this.currX = e.getX();
        this.startX = this.currX;
        this.lastY = this.currY = e.getY();
        this.startY = this.currY;
        this.dragged = false;
        if (this.doStartDrag()) {
            this.component.addMouseListener(this);
            this.component.addMouseMotionListener(this);
        }
    }

    public void mouseReleased(MouseEvent e) {
        currentDragger = null;
        this.component.removeMouseListener(this);
        this.component.removeMouseMotionListener(this);
        if (this.dragged) {
            this.doDrag(true);
        }
        this.event = e;
        this.currX = e.getX();
        this.currY = e.getY();
        this.doEndDrag();
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.pinRect != null) {
            if (x < this.pinRect.x) {
                x = this.pinRect.x;
            } else if (x > this.pinRect.x + this.pinRect.width) {
                x = this.pinRect.x + this.pinRect.width;
            }
            if (y < this.pinRect.y) {
                y = this.pinRect.y;
            } else if (y > this.pinRect.y + this.pinRect.height) {
                y = this.pinRect.y + this.pinRect.height;
            }
        }
        if (x != this.lastX || y != this.lastY) {
            if (this.drawBeforeErase) {
                int saveLastX = this.lastX;
                int saveLastY = this.lastY;
                int saveCurrX = this.currX;
                int saveCurrY = this.currY;
                MouseEvent saveEvent = this.event;
                this.event = e;
                this.lastX = this.currX;
                this.lastY = this.currY;
                this.currX = x;
                this.currY = y;
                this.doDrag(false);
                if (this.dragged) {
                    this.lastX = saveLastX;
                    this.lastY = saveLastY;
                    this.currX = saveCurrX;
                    this.currY = saveCurrY;
                    this.event = saveEvent;
                    this.doDrag(true);
                }
                this.dragged = true;
                this.lastX = this.currX;
                this.lastY = this.currY;
                this.currX = x;
                this.currY = y;
                this.event = e;
            } else {
                this.doDrag(true);
                this.dragged = true;
                this.event = e;
                this.lastX = this.currX;
                this.lastY = this.currY;
                this.currX = x;
                this.currY = y;
                this.doDrag(false);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean doStartDrag() {
        return true;
    }

    public void doDrag(boolean erase) {
    }

    public void doEndDrag() {
    }
}

