/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.awt;

import com.jhlabs.awt.Alignment;
import com.jhlabs.awt.ConstraintLayout;
import com.jhlabs.awt.Direction;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;

public class PackerLayout
extends ConstraintLayout
implements Direction {
    public static final Integer LEFT_TOP = new Integer(1793);
    public static final Integer LEFT_CENTER = new Integer(1792);
    public static final Integer LEFT_BOTTOM = new Integer(1797);
    public static final Integer RIGHT_TOP = new Integer(769);
    public static final Integer RIGHT_CENTER = new Integer(768);
    public static final Integer RIGHT_BOTTOM = new Integer(773);
    public static final Integer TOP_LEFT = new Integer(263);
    public static final Integer TOP_CENTER = new Integer(256);
    public static final Integer TOP_RIGHT = new Integer(259);
    public static final Integer BOTTOM_LEFT = new Integer(1287);
    public static final Integer BOTTOM_CENTER = new Integer(1280);
    public static final Integer BOTTOM_RIGHT = new Integer(1283);
    public static final Integer LEFT_TOP_FILL = new Integer(1921);
    public static final Integer LEFT_CENTER_FILL = new Integer(1920);
    public static final Integer LEFT_BOTTOM_FILL = new Integer(1925);
    public static final Integer RIGHT_TOP_FILL = new Integer(897);
    public static final Integer RIGHT_CENTER_FILL = new Integer(896);
    public static final Integer RIGHT_BOTTOM_FILL = new Integer(901);
    public static final Integer TOP_LEFT_FILL = new Integer(391);
    public static final Integer TOP_CENTER_FILL = new Integer(384);
    public static final Integer TOP_RIGHT_FILL = new Integer(387);
    public static final Integer BOTTOM_LEFT_FILL = new Integer(1415);
    public static final Integer BOTTOM_CENTER_FILL = new Integer(1408);
    public static final Integer BOTTOM_RIGHT_FILL = new Integer(1411);
    protected int hGap;
    protected int vGap;

    public PackerLayout() {
        this(0, 0, 0, 0);
    }

    public PackerLayout(int hGap, int vGap, int hMargin, int vMargin) {
        this.hGap = hGap;
        this.vGap = vGap;
        this.hMargin = hMargin;
        this.vMargin = vMargin;
    }

    public void measureLayout(Container target, Dimension dimension, int type) {
        int count = target.getComponentCount();
        if (count > 0) {
            Component c;
            int i;
            Insets insets = target.getInsets();
            Dimension size = target.getSize();
            int minX = 0;
            int maxX = 0;
            int minY = 0;
            int maxY = 0;
            int position = 3;
            int alignment = 0;
            Rectangle[] sizes = new Rectangle[count];
            for (i = 0; i < count; ++i) {
                c = target.getComponent(i);
                if (!this.includeComponent(c)) continue;
                Dimension d = this.getComponentSize(c, type);
                int x = 0;
                int y = 0;
                int w = d.width;
                int h = d.height;
                int cellX = 0;
                int cellY = 0;
                int cellW = w;
                int cellH = h;
                int fill = 0;
                if (i == 0) {
                    maxX = w;
                    maxY = h;
                } else {
                    Integer n = (Integer)this.getConstraint(c);
                    int v = 0;
                    if (n != null) {
                        v = n;
                    }
                    position = v >> 8 & 0x7F;
                    alignment = v & 0xFF;
                    if ((v & 0x80) != 0) {
                        fill = 3;
                    }
                    switch (position) {
                        case 3: 
                        case 7: {
                            switch (position) {
                                case 7: {
                                    x = minX - w - this.hGap;
                                    break;
                                }
                                case 3: {
                                    x = maxX + this.hGap;
                                }
                            }
                            if (alignment == 1) {
                                y = minY;
                                break;
                            }
                            if (alignment == 5) {
                                y = maxY - h;
                                break;
                            }
                            if (alignment != 0) break;
                            y = (minY + maxY - h) / 2;
                            break;
                        }
                        case 1: 
                        case 5: {
                            switch (position) {
                                case 1: {
                                    y = minY - h - this.vGap;
                                    break;
                                }
                                case 5: {
                                    y = maxY + this.vGap;
                                }
                            }
                            if (alignment == 7) {
                                x = minX;
                                break;
                            }
                            if (alignment == 3) {
                                x = maxX - w;
                                break;
                            }
                            if (alignment != 0) break;
                            x = (minX + maxX - w) / 2;
                        }
                    }
                    minX = Math.min(minX, x);
                    maxX = Math.max(maxX, x + w);
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y + h);
                    switch (position) {
                        case 3: 
                        case 7: {
                            cellX = x;
                            cellY = minY;
                            cellH = maxY - minY;
                            break;
                        }
                        case 1: 
                        case 5: {
                            cellX = minX;
                            cellY = y;
                            cellW = maxX - minX;
                        }
                    }
                }
                sizes[i] = new Rectangle(x, y, w, h);
                Rectangle cell = new Rectangle(cellX, cellY, cellW, cellH);
                Alignment.alignInCell(sizes[i], cell, alignment, fill);
            }
            if (dimension != null) {
                dimension.width = maxX - minX;
                dimension.height = maxY - minY;
            } else {
                for (i = 0; i < count; ++i) {
                    c = target.getComponent(i);
                    if (!this.includeComponent(c)) continue;
                    Rectangle r = sizes[i];
                    c.setBounds(insets.left + this.hMargin - minX + r.x, insets.top + this.vMargin - minY + r.y, r.width, r.height);
                }
            }
        }
    }
}

