/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;

public class BeanUtils {
    public static void setProperty(Object object, String name, Object value) throws IntrospectionException, IllegalAccessException, NoSuchFieldException, MalformedURLException {
        PropertyDescriptor property = BeanUtils.getPropertyDescriptor(object, name);
        if (property != null) {
            Method method = property.getWriteMethod();
            if (method != null) {
                Class<?>[] parameters = method.getParameterTypes();
                try {
                    value = BeanUtils.coerce(value, parameters[0]);
                    method.invoke(object, value);
                }
                catch (Exception ex) {
                    System.out.println("Can't set property: " + name + " " + value + " " + parameters[0]);
                    ex.printStackTrace();
                }
            } else {
                System.out.println("Unknown property: " + name);
            }
        } else {
            Field field = object.getClass().getDeclaredField(name);
            value = BeanUtils.coerce(value, field.getType());
            field.set(object, value);
        }
    }

    public static PropertyDescriptor getPropertyDescriptor(Object object, String name) throws IntrospectionException, IllegalAccessException {
        return BeanUtils.getPropertyDescriptor(object.getClass(), name);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class c, String name) throws IntrospectionException, IllegalAccessException {
        BeanInfo beanInfo = null;
        PropertyDescriptor[] properties = null;
        beanInfo = Introspector.getBeanInfo(c);
        properties = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor property = properties[i];
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    protected static Object coerce(Object v, Class cl) throws MalformedURLException {
        if (v instanceof String) {
            String s = (String)v;
            if (cl == Float.TYPE) {
                return Float.valueOf(s);
            }
            if (cl == Double.TYPE) {
                return Double.valueOf(s);
            }
            if (cl == Integer.TYPE) {
                return Integer.valueOf(s);
            }
            if (cl == Boolean.TYPE) {
                return Boolean.valueOf(s);
            }
            if (cl == URL.class) {
                return new URL(s);
            }
        }
        return v;
    }
}

