/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.beans;

import com.jhlabs.awt.ParagraphLayout;
import com.jhlabs.beans.AbstractPropertyEditor;
import com.jhlabs.beans.AnglePropertyEditor;
import com.jhlabs.beans.BooleanPropertyEditor;
import com.jhlabs.beans.ChoicePropertyEditor;
import com.jhlabs.beans.ColorPropertyEditor;
import com.jhlabs.beans.ColormapPropertyEditor;
import com.jhlabs.beans.FloatPropertyEditor;
import com.jhlabs.beans.FloatTextProperty;
import com.jhlabs.beans.GraphPropertyEditor;
import com.jhlabs.beans.IntPropertyEditor;
import com.jhlabs.beans.IntSpinnerProperty;
import com.jhlabs.beans.IntTextProperty;
import com.jhlabs.beans.LocalPropertyEditorManager;
import com.jhlabs.beans.PercentageProperty;
import com.jhlabs.beans.Point2DPropertyEditor;
import com.jhlabs.beans.RadiusPropertyEditor;
import com.jhlabs.beans.StringPropertyEditor;
import com.jhlabs.composite.MiscComposite;
import com.jhlabs.xml.XMLParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PropertySheet
extends JPanel
implements Customizer,
PropertyChangeListener {
    public static final Font SMALL_FONT = new Font("dialog", 0, 11);
    private Object object;
    private Vector propertyEditors = new Vector();
    private BeanInfo info;
    private JPanel groupPanel = this;
    private boolean firingChangeEvent = false;
    static boolean first = true;

    public PropertySheet() {
        this.setLayout(new ParagraphLayout(10, 10, 6, 6, 4, 4));
        if (first) {
            LocalPropertyEditorManager.registerEditor(Float.TYPE, FloatPropertyEditor.class);
            LocalPropertyEditorManager.registerEditor(Integer.TYPE, IntPropertyEditor.class);
            LocalPropertyEditorManager.registerEditor(Boolean.TYPE, BooleanPropertyEditor.class);
            LocalPropertyEditorManager.registerEditor(String.class, StringPropertyEditor.class);
            LocalPropertyEditorManager.registerEditor(Color.class, ColorPropertyEditor.class);
            first = false;
        }
    }

    public void addProperty(PropertyEditor p, String label, String property) {
        JPanel c = this.groupPanel;
        if (p instanceof AbstractPropertyEditor && ((AbstractPropertyEditor)p).needsLabel()) {
            c.add((Component)new JLabel(label + ":", 4), ParagraphLayout.NEW_PARAGRAPH);
        } else {
            c.add((Component)new JLabel(""), ParagraphLayout.NEW_PARAGRAPH);
        }
        Component control = p.getCustomEditor();
        c.add(control);
        p.addPropertyChangeListener(this);
        this.propertyEditors.add(new PropertyEditorHolder(label, property, p));
    }

    public Iterator getPropertyEditors() {
        return new EditorIterator(this.propertyEditors.iterator());
    }

    public static String capitalize(String name) {
        if (name == null || name.length() < 2) {
            return name;
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected void addPropertyDescriptor(PropertyDescriptor pd) {
        Method readMethod = pd.getReadMethod();
        Method writeMethod = pd.getWriteMethod();
        if (readMethod != null && writeMethod != null) {
            PropertyEditor editor = null;
            Class<?> editorClass = pd.getPropertyEditorClass();
            if (editorClass != null) {
                try {
                    editor = (PropertyEditor)editorClass.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Class<?> type = readMethod.getReturnType();
                editor = LocalPropertyEditorManager.findEditor(type);
            }
            if (editor != null) {
                String name = PropertySheet.capitalize(pd.getName());
                if (editor instanceof AbstractPropertyEditor) {
                    AbstractPropertyEditor ape = (AbstractPropertyEditor)editor;
                    ape.setName(name);
                    ape.setPropertyDescriptor(pd);
                }
                this.addProperty(editor, name, pd.getName());
            }
        }
    }

    public void makePropertyEditors(Object object, String[] propertyNames) {
        InputStream is;
        String className = object.getClass().getName();
        int index = className.lastIndexOf(46);
        if (index != -1) {
            className = className.substring(index + 1);
        }
        if ((is = object.getClass().getResourceAsStream(className + ".xml")) != null) {
            this.loadXML(is);
            return;
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(object.getClass());
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            if (propertyNames != null) {
                block3: for (int i = 0; i < propertyNames.length; ++i) {
                    String propertyName = propertyNames[i];
                    for (int j = 0; j < pds.length; ++j) {
                        PropertyDescriptor pd = pds[j];
                        if (!propertyName.equals(pd.getName())) continue;
                        this.addPropertyDescriptor(pd);
                        continue block3;
                    }
                }
            } else {
                for (int j = 0; j < pds.length; ++j) {
                    this.addPropertyDescriptor(pds[j]);
                }
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.useSmallFont();
    }

    public void setObject(Object object) {
        this.object = object;
        try {
            this.firingChangeEvent = true;
            this.info = Introspector.getBeanInfo(object.getClass());
            for (int i = 0; i < this.propertyEditors.size(); ++i) {
                PropertyEditorHolder h = (PropertyEditorHolder)this.propertyEditors.get(i);
                PropertyEditor property = h.editor;
                if (object instanceof Hashtable) {
                    property.setValue(((Hashtable)object).get(h.property));
                    continue;
                }
                PropertyDescriptor[] pds = this.info.getPropertyDescriptors();
                boolean found = false;
                for (int j = 0; j < pds.length; ++j) {
                    PropertyDescriptor pd = pds[j];
                    if (!h.property.equals(pd.getName())) continue;
                    found = true;
                    Method method = pd.getReadMethod();
                    try {
                        Object value = method.invoke(object, new Object[0]);
                        property.setValue(value);
                    }
                    catch (Exception ex) {
                        System.out.println("Error setting value for property: " + h.name);
                        ex.printStackTrace();
                    }
                    break;
                }
                if (found) continue;
                System.out.println("No such property in object: " + h.name);
            }
            this.firingChangeEvent = false;
            this.fireChangeEvent();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        PropertyEditor editor = (PropertyEditor)e.getSource();
        PropertyEditorHolder holder = null;
        for (int i = 0; i < this.propertyEditors.size(); ++i) {
            PropertyEditorHolder h = (PropertyEditorHolder)this.propertyEditors.get(i);
            if (h.editor != editor) continue;
            holder = h;
            break;
        }
        if (holder == null) {
            System.out.println("Change from non-existent property");
            return;
        }
        Object value = e.getNewValue();
        boolean invoked = false;
        if (this.object instanceof Hashtable) {
            ((Hashtable)this.object).put(holder.property, editor.getValue());
        } else {
            PropertyDescriptor[] pds = this.info.getPropertyDescriptors();
            for (int j = 0; j < pds.length; ++j) {
                PropertyDescriptor pd = pds[j];
                if (!holder.property.equals(pd.getName())) continue;
                Method method = pd.getWriteMethod();
                try {
                    method.invoke(this.object, editor.getValue());
                    invoked = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            block6: for (int i = 0; i < this.propertyEditors.size(); ++i) {
                PropertyEditorHolder h = (PropertyEditorHolder)this.propertyEditors.get(i);
                editor = h.editor;
                if (!(editor instanceof AbstractPropertyEditor) || !((AbstractPropertyEditor)editor).alwaysRefresh()) continue;
                pds = this.info.getPropertyDescriptors();
                for (int j = 0; j < pds.length; ++j) {
                    PropertyDescriptor pd = pds[j];
                    if (!h.property.equals(pd.getName())) continue;
                    Method method = pd.getReadMethod();
                    try {
                        Object v = method.invoke(this.object, new Object[0]);
                        editor.setValue(v);
                    }
                    catch (Exception ex) {
                        System.out.println("Error setting value for property: " + h.name);
                        ex.printStackTrace();
                    }
                    continue block6;
                }
            }
            if (!invoked) {
                System.out.println("Can't set property: " + holder.name);
            }
        }
        this.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChangeEvent() {
        if (!this.firingChangeEvent) {
            this.firingChangeEvent = true;
            ChangeEvent e = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? PropertySheet.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
                if (e == null) {
                    e = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(e);
            }
            this.firingChangeEvent = false;
        }
    }

    public void useSmallFont() {
        this.setGlobalFont(this, SMALL_FONT);
    }

    protected void setGlobalFont(Component c, Font font) {
        Dictionary dictionary;
        if (c instanceof Container) {
            Container d = (Container)c;
            int count = d.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.setGlobalFont(d.getComponent(i), font);
            }
        }
        if (!(c instanceof DisclosureButton)) {
            c.setFont(font);
        }
        if (c instanceof JSlider && (dictionary = ((JSlider)c).getLabelTable()) != null) {
            Enumeration values = dictionary.elements();
            while (values.hasMoreElements()) {
                Component label = (Component)values.nextElement();
                label.setFont(font);
            }
        }
    }

    public void loadXML(InputStream is) {
        try {
            XMLParser xp = new XMLParser();
            xp.setDocumentHandler(new PropertySheetDocumentHandler());
            xp.parse(new InputSource(is));
            this.useSmallFont();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public class PropertySheetDocumentHandler
    extends HandlerBase {
        public void startElement(String tag, AttributeList attrs) throws SAXException {
            if (tag.equals("filter")) {
                String beanName = attrs.getValue("class");
            } else if (tag.equals("group")) {
                String name = attrs.getValue("name");
                JPanel p = new JPanel();
                p.setLayout(new ParagraphLayout());
                boolean visible = !"false".equals(attrs.getValue("open"));
                DisclosureButton b = new DisclosureButton(name, p, visible);
                b.setSelected(visible);
                p.setVisible(visible);
                PropertySheet.this.groupPanel.add((Component)b, ParagraphLayout.NEW_PARAGRAPH);
                PropertySheet.this.groupPanel.add((Component)p, ParagraphLayout.NEW_LINE);
                PropertySheet.this.groupPanel = p;
            } else if (tag.equals("param") || tag.equals("property")) {
                PropertyEditor property = null;
                String name = attrs.getValue("name");
                String propertyName = attrs.getValue("property");
                String type = attrs.getValue("type");
                if (type.equals("int")) {
                    int min = 0;
                    int max = 255;
                    boolean def = false;
                    String s = attrs.getValue("min");
                    if (s != null) {
                        min = Integer.parseInt(s);
                    }
                    if ((s = attrs.getValue("max")) != null) {
                        max = Integer.parseInt(s);
                    }
                    property = "text".equals(s = attrs.getValue("ui")) ? new IntTextProperty(name, propertyName, min, max) : ("spin".equals(s) ? new IntSpinnerProperty(name, propertyName, min, max) : new IntPropertyEditor(name, propertyName, min, max));
                } else if (type.equals("float") || type.equals("radius")) {
                    float min = 0.0f;
                    float max = 1.0f;
                    float def = 0.0f;
                    String s = attrs.getValue("min");
                    if (s != null) {
                        min = Float.parseFloat(s);
                    }
                    if ((s = attrs.getValue("max")) != null) {
                        max = Float.parseFloat(s);
                    }
                    s = attrs.getValue("ui");
                    property = type.equals("radius") ? new RadiusPropertyEditor(name, propertyName, min, max) : ("text".equals(s) ? new FloatTextProperty(name, propertyName, min, max) : new FloatPropertyEditor(name, propertyName, min, max));
                } else if (type.equals("angle")) {
                    float min = 0.0f;
                    float max = 360.0f;
                    float def = 0.0f;
                    String s = attrs.getValue("min");
                    if (s != null) {
                        min = Float.parseFloat(s);
                    }
                    if ((s = attrs.getValue("max")) != null) {
                        max = Float.parseFloat(s);
                    }
                    property = new AnglePropertyEditor(name, propertyName, min, max);
                } else if (type.equals("percentage")) {
                    property = new PercentageProperty(name, propertyName);
                } else if (type.equals("boolean")) {
                    property = new BooleanPropertyEditor(name, propertyName, false);
                } else if (type.equals("color")) {
                    property = new ColorPropertyEditor(name, propertyName);
                } else if (type.equals("colormap")) {
                    property = new ColormapPropertyEditor(name, propertyName);
                } else if (!type.equals("image")) {
                    if (type.equals("composite")) {
                        property = new ChoicePropertyEditor(name, propertyName, MiscComposite.RULE_NAMES);
                    } else if (type.equals("position")) {
                        property = new Point2DPropertyEditor(name, propertyName);
                    } else if (type.equals("graph")) {
                        property = new GraphPropertyEditor(name, propertyName);
                    } else if (type.equals("string")) {
                        property = new StringPropertyEditor(name, propertyName);
                    } else if (type.equals("choice")) {
                        String choices = attrs.getValue("choices");
                        property = new ChoicePropertyEditor(name, propertyName, choices.split("\\|"));
                    } else {
                        try {
                            Class<?> cls = Class.forName(type);
                            property = LocalPropertyEditorManager.findEditor(cls);
                            if (property instanceof AbstractPropertyEditor) {
                                AbstractPropertyEditor ape = property;
                                ape.setName(name);
                                ape.setProperty(propertyName);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new SAXException("No property editor for type " + type);
                        }
                    }
                }
                if (property != null) {
                    if (property instanceof AbstractPropertyEditor) {
                        ((AbstractPropertyEditor)property).setCentreProperty(attrs.getValue("centre"));
                    }
                    PropertySheet.this.addProperty(property, name, propertyName);
                }
            }
        }

        public void endElement(String tag) throws SAXException {
            if (tag.equals("group")) {
                PropertySheet.this.groupPanel = (JPanel)PropertySheet.this.groupPanel.getParent();
            }
        }
    }

    static class DisclosureButton
    extends JToggleButton
    implements ChangeListener {
        public static final Font BOLD_FONT = new Font("Lucida Grande", 1, 12);
        public static Icon COLLAPSED_ICON;
        public static Icon EXPANDED_ICON;
        private JPanel contents;

        public DisclosureButton(String label, JPanel contents, boolean selected) {
            super(label, selected);
            this.contents = contents;
            this.setFont(BOLD_FONT);
            this.addChangeListener(this);
            if (COLLAPSED_ICON == null) {
                COLLAPSED_ICON = new ImageIcon(this.getClass().getResource("collapsedIcon.png"));
                EXPANDED_ICON = new ImageIcon(this.getClass().getResource("expandedIcon.png"));
            }
            this.setIcon(selected ? EXPANDED_ICON : COLLAPSED_ICON);
            this.setBorder(null);
            this.setAlignmentX(0.0f);
        }

        public void stateChanged(ChangeEvent e) {
            boolean selected = this.isSelected();
            this.contents.setVisible(selected);
            this.setIcon(selected ? EXPANDED_ICON : COLLAPSED_ICON);
        }

        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            d.width = Math.max(d.width, 200);
            return d;
        }
    }

    static class EditorIterator
    implements Iterator {
        private Iterator iterator;

        public EditorIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            PropertyEditorHolder h = (PropertyEditorHolder)this.iterator.next();
            return h.editor;
        }

        public void remove() {
        }
    }

    static class PropertyEditorHolder {
        String name;
        String property;
        PropertyEditor editor;

        PropertyEditorHolder(String name, String property, PropertyEditor editor) {
            this.name = name;
            this.property = property;
            this.editor = editor;
        }
    }
}

