/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie;

import com.jhlabs.app.Application;
import com.jhlabs.app.DocumentWindow;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionController;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.CompositionView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JScrollPane;

public class CompositionWindow
extends DocumentWindow {
    private CompositionView view;
    private JScrollPane scrollPane;

    public CompositionWindow(CompositionDocument document, CompositionController controller) {
        super(document, controller);
        this.view = new CompositionView(controller, document);
        this.scrollPane = new JScrollPane(this.view);
        this.scrollPane.setBorder(null);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        Application application = document.getApplication();
        if (application.isMDI) {
            Dimension maxSize = application.getFrame().getSize();
            Composition composition = document.getComposition();
            int w = Math.min(composition.getWidth(), maxSize.width - 60);
            int h = Math.min(composition.getHeight(), maxSize.height - 60);
            this.setSize(w, h);
        } else {
            this.pack();
            Dimension maxSize = Toolkit.getDefaultToolkit().getScreenSize();
            Composition composition = document.getComposition();
            int w = Math.min(this.getJFrame().getWidth(), maxSize.width - 60);
            int h = Math.min(this.getJFrame().getHeight(), maxSize.height - 60);
            this.setSize(w, h);
        }
        this.enableCommands();
        this.view.requestFocus();
    }

    public CompositionView getCompositionView() {
        return this.view;
    }

    public void dispose() {
        this.view.dispose();
        super.dispose();
    }

    public void sizeToFit() {
        CompositionDocument document = (CompositionDocument)this.getDocument();
        Dimension size = this.getCompositionView().getPreferredSize();
        if (this.getInternalFrame() != null) {
            Dimension maxSize = document.getApplication().getDesktopPane().getSize();
            this.pack();
            size = this.getInternalFrame().getSize();
            if (size.width > maxSize.width || size.height > maxSize.height) {
                this.getInternalFrame().setSize(new Dimension(Math.min(size.width, maxSize.width), Math.min(size.height, maxSize.height)));
            }
        }
    }

    public void enableCommands() {
        this.view.setToolFocus();
        super.enableCommands();
    }
}

