/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie;

import com.jhlabs.app.Task;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.image.ImageMemento;
import com.jhlabs.image.TileCache;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class DrawingTask
extends Task {
    protected Rectangle saveBounds;
    protected ImageMemento memento;
    protected Composition composition;
    protected TileCache tileCache;
    protected String name;

    public DrawingTask(Composition composition) {
        this(composition, "Drawing");
    }

    public DrawingTask(Composition composition, String name) {
        this.composition = composition;
        this.name = name;
        Layer layer = composition.getActiveLayer();
        if (layer != null) {
            this.tileCache = new TileCache(layer.getImage());
        }
    }

    public Composition getComposition() {
        return this.composition;
    }

    public void saveArea(Rectangle r) {
        this.saveArea(r, this.composition.getActiveImage());
    }

    public void saveArea(Rectangle r, BufferedImage image) {
        this.saveBounds = r;
        this.memento = new ImageMemento(image, r.x, r.y, r.width, r.height);
    }

    public void touchRectangle(int x, int y, int w, int h) {
        if (this.tileCache != null) {
            this.tileCache.touchRectangle(x, y, w, h);
        }
    }

    public void touchRectangle(Rectangle r) {
        if (this.tileCache != null) {
            this.touchRectangle(r.x, r.y, r.width, r.height);
        }
    }

    TileCache getTileCache() {
        return this.tileCache;
    }

    public void doTask() {
    }

    public void doDrawing(Graphics2D g) {
    }

    public void doTask(Rectangle r) {
        this.doTask(r, null);
    }

    public void doTask(Rectangle r, Composite composite) {
        this.composition.dropFloatingSelection();
        this.composition.simplifyActiveLayer();
        BufferedImage image = this.composition.getActiveImage();
        this.composition.startUpdate();
        this.saveArea(r);
        Graphics2D g = image.createGraphics();
        BufferedImage selection = this.composition.getSelection();
        BufferedImage tmp = new BufferedImage(r.width, r.height, 2);
        Graphics2D g2 = tmp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.translate(-r.x, -r.y);
        this.doDrawing(g2);
        if (this.composition.getSelectedBounds() != null) {
            g2.setComposite(AlphaComposite.getInstance(6));
            g2.drawImage(selection, null, 0, 0);
        }
        g2.dispose();
        if (composite != null) {
            g.setComposite(composite);
        }
        g.drawImage(tmp, null, r.x, r.y);
        g.dispose();
        this.composition.update(r);
        this.composition.endUpdate();
    }

    public void undo() {
        this.composition.startUpdate();
        if (this.memento != null) {
            this.memento.restore();
        }
        if (this.tileCache != null) {
            this.tileCache.restore();
            this.composition.update(this.tileCache.getBounds());
        }
        this.composition.update(this.saveBounds);
        this.composition.endUpdate();
    }

    public void redo() {
        this.undo();
    }

    public String getPresentationName() {
        return this.name;
    }
}

