/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie;

import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.image.ImageUtils;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public class FileFormat {
    protected String name;
    protected String[] mimeTypes;
    protected String[] fileExtensions;
    protected String[] macFileTypes;

    public FileFormat(String name, String mimeType, String fileExtension, String macFileType) {
        String[] mimeTypes = new String[]{mimeType};
        String[] fileExtensions = new String[]{fileExtension};
        String[] macFileTypes = new String[]{macFileType};
        this.initialize(name, mimeTypes, fileExtensions, macFileTypes);
    }

    public FileFormat(String name, String[] mimeTypes, String[] fileExtensions, String[] macFileTypes) {
        this.initialize(name, mimeTypes, fileExtensions, macFileTypes);
    }

    public void initialize(String name, String[] mimeTypes, String[] fileExtensions, String[] macFileTypes) {
        this.name = name;
        this.mimeTypes = mimeTypes;
        this.fileExtensions = fileExtensions;
        this.macFileTypes = macFileTypes;
    }

    public void dispose() {
    }

    public String getName() {
        return this.name;
    }

    public String[] getMimeTypes() {
        return this.mimeTypes;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public Enumeration getSubFileFormats() {
        return null;
    }

    public boolean canRead(String extension) {
        if (this.fileExtensions != null) {
            for (int i = 0; i < this.fileExtensions.length; ++i) {
                if (!extension.equals(this.fileExtensions[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canRead(byte[] fileStart) {
        return false;
    }

    public boolean canWrite() {
        return true;
    }

    public boolean shouldOpenFile() {
        return true;
    }

    public boolean readImage(File file, InputStream in, CompositionDocument document) throws IOException {
        ImageProducer p;
        BufferedImage image = this.readBufferedImage(file, in);
        if (image == null && (p = this.readImage(file, in)) != null) {
            image = ImageUtils.createImage(p);
        }
        if (image != null) {
            image = ImageUtils.cloneImage(image);
            Composition oldComposition = document.getComposition();
            Composition newComposition = new Composition(image);
            if (newComposition != null) {
                newComposition.setCompositionListeners(oldComposition.getCompositionListeners());
            }
            document.setComposition(newComposition);
            return true;
        }
        return false;
    }

    public BufferedImage readBufferedImage(File file, InputStream in) throws IOException {
        return null;
    }

    public ImageProducer readImage(File file, InputStream in) throws IOException {
        return null;
    }

    public void writeImage(File file, OutputStream out, CompositionDocument document) throws IOException {
    }

    public boolean showOptionsDialog(Frame frame, CompositionDocument document) {
        return true;
    }

    public String getSaveFilename(String name) {
        int index = name.lastIndexOf(46);
        if (index != -1) {
            name = name.substring(0, index);
        }
        if (this.fileExtensions != null) {
            name = name + this.fileExtensions[0];
        }
        return name;
    }

    public String toString() {
        return this.name;
    }
}

