/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.tool.PaintingTool;
import com.jhlabs.image.CombineComboBox;
import com.jhlabs.image.FilterCustomizer;
import com.jhlabs.image.PaintingContext;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageTool
extends PaintingTool {
    private int composite;

    public void setComposite(int composite) {
        this.composite = composite;
    }

    public int getComposite() {
        return this.composite;
    }

    public Rectangle getRectangle() {
        int x1 = this.view.XTox(Math.min(this.startX, this.currX));
        int y1 = this.view.YToy(Math.min(this.startY, this.currY));
        int x2 = this.view.XTox(Math.max(this.startX, this.currX));
        int y2 = this.view.YToy(Math.max(this.startY, this.currY));
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public Composition getComposition() {
        CompositionDocument document;
        if (this.view != null && (document = this.view.getDocument()) != null) {
            return document.getComposition();
        }
        return null;
    }

    public PaintingContext getPaintingContext() {
        return PaintingContext.getInstance();
    }

    protected class DrawingToolCustomizer
    extends FilterCustomizer
    implements ChangeListener,
    ActionListener {
        private ImageTool tool;
        private JSpinner lineWidth;
        private JComboBox blendChoice;

        public DrawingToolCustomizer() {
            this.setLayout(new SuperGridLayout(1, 0));
            this.add(new JLabel("Line Width:", 4));
            Float value = new Float(1.0f);
            Float min = new Float(0.0f);
            Float max = new Float(100.0f);
            Float step = new Float(0.1f);
            SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
            this.lineWidth = new JSpinner(model);
            this.lineWidth.addChangeListener(this);
            this.add(this.lineWidth);
            this.blendChoice = new CombineComboBox();
            this.blendChoice.addActionListener(this);
            this.add(this.blendChoice);
        }

        public void setObject(Object o) {
            this.tool = (ImageTool)o;
            this.lineWidth.setValue(new Float(ImageTool.this.getPaintingContext().getLineWidth()));
        }

        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            if (this.tool != null && source == this.lineWidth) {
                float width = ((SpinnerNumberModel)this.lineWidth.getModel()).getNumber().floatValue();
                ImageTool.this.getPaintingContext().setLineWidth(width);
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this.tool != null && source == this.blendChoice) {
                this.tool.setComposite(this.blendChoice.getSelectedIndex());
            }
        }
    }
}

