/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie;

import com.jhlabs.ie.Brush;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.MarbleFilter;
import com.jhlabs.image.PixelUtils;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;

public class SimpleBrush
extends Brush {
    public SimpleBrush() {
        this.type = 0;
        this.image = new BufferedImage(1, 1, 2);
        this.image.setRGB(0, 0, -16777216);
    }

    public SimpleBrush(float radius) {
        this(radius, Math.max(1, (int)(radius / 4.0f)), 0.0f, 1.0f, 1.0f);
    }

    public SimpleBrush(float radius, float softness, float angle, float aspect, float roundness) {
        this.type = 0;
        this.radius = radius;
        this.softness = softness;
        this.angle = angle;
        this.aspect = aspect;
        this.roundness = roundness;
        this.setFilters(new BufferedImageOp[]{new MarbleFilter()});
    }

    public void makeBrush() {
        int rows;
        int iradius = (int)Math.ceil(this.radius);
        int cols = rows = iradius * 2 + 1;
        this.image = new BufferedImage(cols, rows, 2);
        float sigma = this.radius / 3.0f;
        float soft = this.softness * this.radius;
        float cos = (float)Math.cos(this.angle);
        float sin = (float)Math.sin(this.angle);
        float m00 = cos;
        float m01 = sin;
        float m10 = -sin;
        float m11 = cos;
        this.roundness = (float)Math.max(0.01, (double)this.roundness);
        double n2 = 2.0f / this.roundness;
        double r2 = this.roundness / 2.0f;
        int[] pixels = new int[cols];
        for (int row = -iradius; row <= iradius; ++row) {
            for (int col = -iradius; col <= iradius; ++col) {
                float frow = m00 * (float)row + m01 * (float)col;
                float fcol = m10 * (float)row + m11 * (float)col;
                float distance = (float)Math.pow(Math.pow(Math.abs(fcol), n2) + Math.pow(Math.abs(frow /= this.aspect), n2), r2);
                float v = 1.0f - ImageMath.smoothStep(this.radius - soft, this.radius, distance);
                int a = PixelUtils.clamp((int)(255.0f * v));
                pixels[col + iradius] = a << 24;
            }
            this.image.getRaster().setDataElements(0, row + iradius, cols, 1, pixels);
        }
        this.type = 0;
    }

    public BufferedImage getImage() {
        if (this.image == null) {
            this.makeBrush();
        }
        return this.image;
    }

    public BufferedImage getImage(int frame) {
        if (this.image == null) {
            this.makeBrush();
        }
        return this.image;
    }

    public int getWidth() {
        if (this.image == null) {
            this.makeBrush();
        }
        return this.image.getWidth();
    }

    public int getHeight() {
        if (this.image == null) {
            this.makeBrush();
        }
        return this.image.getHeight();
    }

    protected void sizeChanged() {
        this.image = null;
    }

    public boolean imageIsTransformed() {
        return true;
    }
}

