/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.composite.MiscComposite;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.DrawingTask;
import com.jhlabs.ie.ImageTool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;

public class ArrowsTool
extends ImageTool {
    public static final int ARROWHEAD_NONE = 0;
    public static final int ARROWHEAD_LINE = 1;
    public static final int ARROWHEAD_HOLLOW = 2;
    public static final int ARROWHEAD_FILLED = 3;
    private boolean antialiased = false;
    private int arrowStyleStart = 0;
    private int arrowStyleEnd = 0;
    private float arrowWidth = 2.0f;
    private float arrowLength = 4.0f;

    public void setAntialiased(boolean antialiased) {
        this.antialiased = antialiased;
    }

    public boolean isAntialiased() {
        return this.antialiased;
    }

    public void setArrowStyleStart(int arrowStyleStart) {
        this.arrowStyleStart = arrowStyleStart;
    }

    public int getArrowStyleStart() {
        return this.arrowStyleStart;
    }

    public void setArrowStyleEnd(int arrowStyleEnd) {
        this.arrowStyleEnd = arrowStyleEnd;
    }

    public int getArrowStyleEnd() {
        return this.arrowStyleEnd;
    }

    public void setArrowWidth(float arrowWidth) {
        this.arrowWidth = arrowWidth;
    }

    public float getArrowWidth() {
        return this.arrowWidth;
    }

    public void setArrowLength(float arrowLength) {
        this.arrowLength = arrowLength;
    }

    public float getArrowLength() {
        return this.arrowLength;
    }

    public void doDrag(boolean erase) {
        this.graphics.drawLine(this.startX, this.startY, this.currX, this.currY);
    }

    public void doEndDrag() {
        this.view.doTask(new ArrowTask(this.view.getComposition(), this.view.XTox(this.startX), this.view.YToy(this.startY), this.view.XTox(this.currX), this.view.YToy(this.currY), this.view.getPaintColor(this.event), this.arrowStyleStart, this.arrowStyleEnd, this.arrowWidth, this.arrowLength));
    }

    public String getToolTipText() {
        return "Line Tool";
    }

    public String getHelpText() {
        return "Arrow Tool: Meta key picks color";
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new ArrowToolCustomizer();
    }

    protected class ArrowToolCustomizer
    extends ImageTool.DrawingToolCustomizer
    implements ActionListener {
        private ArrowsTool tool;
        private JComboBox arrowStyleStart;
        private JComboBox arrowStyleEnd;
        private JSpinner arrowWidth;
        private JSpinner arrowLength;

        public ArrowToolCustomizer() {
            Icon noneIcon = this.getIcon("arrow_none.png");
            this.add(new JLabel("Arrowheads:", 4));
            this.arrowStyleStart = new JComboBox();
            this.add(this.arrowStyleStart);
            this.arrowStyleStart.setToolTipText("The arrowhead at the end of the line");
            this.arrowStyleStart.addItem(noneIcon);
            this.arrowStyleStart.addItem(this.getIcon("arrow_l_line.png"));
            this.arrowStyleStart.addItem(this.getIcon("arrow_l_hollow.png"));
            this.arrowStyleStart.addItem(this.getIcon("arrow_l_filled.png"));
            this.arrowStyleStart.addActionListener(this);
            this.arrowStyleEnd = new JComboBox();
            this.add(this.arrowStyleEnd);
            this.arrowStyleEnd.setToolTipText("The arrowhead at the end of the line");
            this.arrowStyleEnd.addItem(noneIcon);
            this.arrowStyleEnd.addItem(this.getIcon("arrow_r_line.png"));
            this.arrowStyleEnd.addItem(this.getIcon("arrow_r_hollow.png"));
            this.arrowStyleEnd.addItem(this.getIcon("arrow_r_filled.png"));
            this.arrowStyleEnd.addActionListener(this);
            this.arrowWidth = this.addSizeSpinner("Width:");
            this.arrowLength = this.addSizeSpinner("Length:");
        }

        private Icon getIcon(String name) {
            return new ImageIcon(this.getClass().getResource(name));
        }

        private JSpinner addSizeSpinner(String label) {
            this.add(new JLabel(label, 4));
            Float value = new Float(1.0f);
            Float min = new Float(0.0f);
            Float max = new Float(100.0f);
            Float step = new Float(0.1f);
            SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
            JSpinner spinner = new JSpinner(model);
            spinner.addChangeListener(this);
            this.add(spinner);
            return spinner;
        }

        public void setObject(Object o) {
            super.setObject(o);
            this.tool = (ArrowsTool)o;
            this.arrowStyleStart.setSelectedIndex(this.tool.getArrowStyleStart());
            this.arrowStyleEnd.setSelectedIndex(this.tool.getArrowStyleEnd());
            this.arrowWidth.setValue(new Float(this.tool.getArrowWidth()));
            this.arrowLength.setValue(new Float(this.tool.getArrowLength()));
        }

        public void stateChanged(ChangeEvent e) {
            super.stateChanged(e);
            Object source = e.getSource();
            if (this.tool != null) {
                if (source == this.arrowWidth) {
                    float width = ((SpinnerNumberModel)this.arrowWidth.getModel()).getNumber().floatValue();
                    this.tool.setArrowWidth(width);
                } else if (source == this.arrowLength) {
                    float length = ((SpinnerNumberModel)this.arrowLength.getModel()).getNumber().floatValue();
                    this.tool.setArrowLength(length);
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this.tool != null) {
                if (source == this.arrowStyleStart) {
                    this.tool.setArrowStyleStart(this.arrowStyleStart.getSelectedIndex());
                } else if (source == this.arrowStyleEnd) {
                    this.tool.setArrowStyleEnd(this.arrowStyleEnd.getSelectedIndex());
                } else {
                    super.actionPerformed(e);
                }
            }
        }
    }

    class ArrowTask
    extends DrawingTask {
        private float x1;
        private float y1;
        private float x2;
        private float y2;
        private int color;
        private int arrowStyleStart;
        private int arrowStyleEnd;
        private float arrowWidth;
        private float arrowLength;

        public ArrowTask(Composition composition, int x1, int y1, int x2, int y2, int color, int arrowStyleStart, int arrowStyleEnd, float arrowWidth, float arrowLength) {
            super(composition);
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.color = color;
            this.arrowStyleStart = arrowStyleStart;
            this.arrowStyleEnd = arrowStyleEnd;
            this.arrowWidth = arrowWidth;
            this.arrowLength = arrowLength;
        }

        public void doDrawing(Graphics2D g) {
            g.setColor(new Color(this.color));
            GeneralPath path = new GeneralPath();
            float lx1 = this.x1;
            float ly1 = this.y1;
            float lx2 = this.x2;
            float ly2 = this.y2;
            if (this.arrowStyleStart != 0 || this.arrowStyleEnd != 0) {
                float lineWidth = ArrowsTool.this.getPaintingContext().getLineWidth();
                float x = this.x1;
                float y = this.y1;
                float dx = this.x2 - this.x1;
                float dy = this.y2 - this.y1;
                float d = (float)Math.sqrt(dx * dx + dy * dy);
                double angle = Math.atan2(dy, dx);
                g.setStroke(new BasicStroke(lineWidth));
                if (this.arrowStyleStart != 0) {
                    this.drawArrowHead(g, this.x1, this.y1, angle + Math.PI, this.arrowWidth * lineWidth, this.arrowLength * lineWidth, this.arrowStyleStart);
                }
                if (this.arrowStyleEnd != 0) {
                    this.drawArrowHead(g, this.x2, this.y2, angle, this.arrowWidth * lineWidth, this.arrowLength * lineWidth, this.arrowStyleEnd);
                }
                float shorten = this.shortenAmount(this.arrowStyleStart) * lineWidth;
                lx1 += shorten * dx / d;
                ly1 += shorten * dy / d;
                shorten = this.shortenAmount(this.arrowStyleEnd) * lineWidth;
                lx2 -= shorten * dx / d;
                ly2 -= shorten * dy / d;
            }
            g.setStroke(ArrowsTool.this.getPaintingContext().getStroke());
            path.moveTo(lx1, ly1);
            path.lineTo(lx2, ly2);
            g.draw(path);
        }

        private float shortenAmount(int style) {
            switch (style) {
                case 2: 
                case 3: {
                    return this.arrowLength;
                }
            }
            return 0.5f;
        }

        public void drawArrowHead(Graphics2D g, float x, float y, double angle, float headWidth, float headLength, int style) {
            AffineTransform saveTransform = g.getTransform();
            g.translate(x, y);
            g.rotate(angle);
            GeneralPath path = new GeneralPath();
            path.moveTo(-headLength, headWidth);
            path.lineTo(0.0f, 0.0f);
            path.lineTo(-headLength, -headWidth);
            if (style != 1) {
                path.closePath();
            }
            if (style == 3) {
                g.fill(path);
            }
            g.draw(path);
            g.setTransform(saveTransform);
        }

        public void doTask() {
            Rectangle r = new Rectangle((int)Math.min(this.x1, this.x2), (int)Math.min(this.y1, this.y2), (int)Math.abs(this.x2 - this.x1) + 1, (int)Math.abs(this.y2 - this.y1) + 1);
            float lineWidth = ArrowsTool.this.getPaintingContext().getLineWidth();
            int width = (int)(lineWidth + 0.5f);
            r.grow(width, width);
            r.grow(1 + (int)(lineWidth * this.arrowWidth + 0.5f), 1 + (int)(lineWidth * this.arrowWidth + 0.5f));
            this.doTask(r, MiscComposite.getInstance(ArrowsTool.this.getComposite(), 1.0f));
        }
    }
}

