/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.app.Application;
import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.beans.PropertySheet;
import com.jhlabs.ie.Brush;
import com.jhlabs.ie.CompositionApplication;
import com.jhlabs.ie.tool.BrushTool;
import com.jhlabs.image.FilterCustomizer;
import com.jhlabs.swing.SliderFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BrushToolCustomizer
extends FilterCustomizer
implements ChangeListener,
ItemListener,
ListSelectionListener {
    private BrushTool tool;
    private JComboBox operationChoice;
    private JList brushChoice;
    private Brush[] brushes;
    private Brush brush;
    private BrushPreview preview;
    private PropertySheet propertySheet;
    private JSlider radiusSlider;
    private JSlider opacitySlider;
    private JButton brushButton;
    private JPopupMenu brushMenu;
    private JButton advancedButton;
    private JDialog advancedMenu;
    private static final Font FONT = new Font("dialog", 0, 7);

    public BrushToolCustomizer() {
        JScrollPane scrollPane;
        SuperGridLayout sgl = new SuperGridLayout(1, 0);
        sgl.setAlignment(0);
        sgl.setFill(0);
        this.setLayout(sgl);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        this.add((Component)leftPanel, "Center");
        this.brushButton = new JButton("");
        this.brushButton.putClientProperty("Quaqua.Button.style", "square");
        this.add(this.brushButton);
        this.brushButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BrushToolCustomizer.this.brushMenu.isVisible()) {
                    BrushToolCustomizer.this.brushMenu.setVisible(false);
                } else {
                    BrushToolCustomizer.this.brushMenu.show(BrushToolCustomizer.this.brushButton, 0, BrushToolCustomizer.this.brushButton.getHeight());
                }
            }
        });
        this.brushMenu = new JPopupMenu("Brushes");
        this.add(this.brushMenu);
        this.add(new JLabel("Radius:", 4));
        this.radiusSlider = new JSlider(1, 300, 1);
        this.radiusSlider.addChangeListener(this);
        this.add(this.radiusSlider);
        this.add(new JLabel("Opacity:", 4));
        this.opacitySlider = SliderFactory.createPercentageSlider(false);
        this.opacitySlider.addChangeListener(this);
        this.add(this.opacitySlider);
        this.advancedButton = new JButton("Advanced");
        this.advancedButton.putClientProperty("Quaqua.Button.style", "square");
        this.add(this.advancedButton);
        this.advancedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BrushToolCustomizer.this.advancedMenu.isVisible()) {
                    BrushToolCustomizer.this.advancedMenu.setVisible(false);
                } else {
                    BrushToolCustomizer.this.advancedMenu.setVisible(true);
                }
            }
        });
        this.advancedMenu = new JDialog((Frame)Application.getInstance().getFrame(), "Advanced");
        Dimension size = this.advancedMenu.getSize();
        Dimension screenSize = this.advancedMenu.getToolkit().getScreenSize();
        this.advancedMenu.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 3);
        Vector brushes = ((CompositionApplication)Application.getInstance()).getBrushes();
        if (brushes != null && brushes.size() != 0) {
            this.brushChoice = new JList(brushes);
            scrollPane = new JScrollPane(this.brushChoice);
            scrollPane.setPreferredSize(new Dimension(200, 200));
            this.brushMenu.add(scrollPane);
            this.brushChoice.setLayoutOrientation(2);
            this.brushChoice.setVisibleRowCount(-1);
            this.brushChoice.setCellRenderer(new BrushCellRenderer());
            this.brushChoice.getSelectionModel().addListSelectionListener(this);
            this.brushButton.setIcon(new BrushIcon((Brush)brushes.firstElement(), 24));
        }
        this.propertySheet = new PropertySheet();
        this.propertySheet.addChangeListener(this);
        scrollPane = new JScrollPane(this.propertySheet);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setBorder(null);
        scrollPane.setPreferredSize(new Dimension(400, 300));
        this.advancedMenu.getContentPane().add(scrollPane);
        InputStream is = Brush.class.getResourceAsStream("Brush.xml");
        if (is != null) {
            this.propertySheet.loadXML(is);
        }
        this.advancedMenu.pack();
        this.preview = new BrushPreview();
    }

    public void setObject(Object o) {
        this.tool = (BrushTool)o;
        this.brush = this.tool.getBrush();
        this.propertySheet.setObject(this.brush);
    }

    public void valueChanged(ListSelectionEvent e) {
        Object source = e.getSource();
        if (this.tool != null) {
            this.brush = (Brush)this.brushChoice.getSelectedValue();
            this.tool.setBrush(this.brush);
            this.propertySheet.setObject(this.brush);
            this.preview.repaint();
            this.brushMenu.setVisible(false);
            this.brushButton.setIcon(new BrushIcon(this.brush, 24));
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (this.tool != null && source == this.brushChoice) {
            this.brush = (Brush)this.brushChoice.getSelectedValue();
            this.tool.setBrush(this.brush);
            this.propertySheet.setObject(this.brush);
            this.preview.repaint();
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (this.tool != null) {
            if (source instanceof JSlider && ((JSlider)source).getValueIsAdjusting()) {
                return;
            }
            this.brush = this.tool.getBrush();
            if (source == this.opacitySlider) {
                this.brush.setOpacity((float)this.opacitySlider.getValue() / 100.0f);
                this.propertySheet.setObject(this.brush);
            } else if (source == this.radiusSlider) {
                this.brush.setRadius(this.radiusSlider.getValue());
                this.propertySheet.setObject(this.brush);
            } else if (source == this.propertySheet) {
                this.opacitySlider.setValue((int)(this.brush.getOpacity() * 100.0f));
                this.radiusSlider.setValue((int)this.brush.getRadius());
                this.preview.repaint();
            }
        }
    }

    class BrushCellRenderer
    extends DefaultListCellRenderer {
        public BrushCellRenderer() {
            this.setOpaque(true);
            this.setPreferredSize(new Dimension(48, 48));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
            Brush brush = (Brush)value;
            this.setIcon(new BrushIcon(brush, 48));
            this.setText("");
            return this;
        }
    }

    public class BrushIcon
    implements Icon {
        private Brush brush;
        private int size;

        public BrushIcon(Brush brush, int size) {
            this.brush = brush;
            this.size = size;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            BufferedImage image = this.brush.getImage(0);
            if (image != null) {
                int h;
                int w = image.getWidth();
                int s = Math.max(w, h = image.getHeight());
                if (s > this.size) {
                    w = this.size * w / s;
                    h = this.size * h / s;
                }
                g2d.drawImage(image, x + (this.size - w) / 2, y + (this.size - h) / 2, w, h, c);
                if (s > this.size) {
                    g.setColor(Color.black);
                    g.setFont(FONT);
                    g.drawString(Integer.toString(s), x + 2, y + 4);
                }
            } else {
                g.setColor(Color.red);
                g.drawLine(x, y, x + this.size, y + this.size);
            }
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }

    class BrushPreview
    extends JComponent {
        public BrushPreview() {
            this.setBorder(BorderFactory.createLineBorder(Color.black));
        }

        public void paint(Graphics g) {
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            BufferedImage image = BrushToolCustomizer.this.brush.getImage();
            g.setColor(Color.white);
            g.fillRect(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
            if (image != null) {
                g.drawImage(image, (size.width - image.getWidth()) / 2, (size.height - image.getHeight()) / 2, this);
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 200);
        }
    }
}

