/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.ie.Composition;
import com.jhlabs.ie.DrawingTask;
import com.jhlabs.ie.Tool;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.ie.tool.FillToolCustomizer;
import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.fill.PixelCompareOp;
import com.jhlabs.image.fill.PixelOp;
import com.jhlabs.image.fill.SeedFill;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

public class FillTool
extends Tool
implements PixelOp,
PixelCompareOp {
    private BufferedImage image;
    private BufferedImage selection;
    private int oldColor;
    private int newColor;
    private int tolerance = 0;
    private long[] mask;
    private int width;
    private int height;
    private boolean fillWithPattern = false;
    protected BufferedImage sourceImage;
    protected int[] dataBufferRGB;
    protected int dataBufferOffset;
    protected int dataBufferScanStride;
    private static Cursor cursor;

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setFillWithPattern(boolean fillWithPattern) {
        this.fillWithPattern = fillWithPattern;
    }

    public boolean getFillWithPattern() {
        return this.fillWithPattern;
    }

    public boolean doStartDrag() {
        Composition composition = this.view.getComposition();
        DrawingTask task = new DrawingTask(composition);
        composition.dropFloatingSelection();
        Layer layer = composition.getActiveLayer();
        int x = this.view.XTox(this.currX);
        int y = this.view.YToy(this.currY);
        if (!layer.getBounds().contains(x, y)) {
            return false;
        }
        if (this.fillWithPattern && this.event.isShiftDown()) {
            this.sourceImage = this.view.getActiveImage();
            return false;
        }
        if (this.graphics != null) {
            this.graphics.dispose();
            this.graphics = null;
        }
        this.image = layer.getImage();
        this.selection = this.view.getSelection();
        if (composition.getSelectedBounds() == null) {
            this.selection = null;
        }
        task.saveArea(layer.getBounds());
        this.view.doTask(task);
        this.oldColor = this.image.getRGB(x, y);
        this.newColor = this.view.getPaintColor(this.event);
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.mask = new long[(this.width * this.height + 63) / 64];
        this.dataBufferRGB = null;
        this.dataBufferOffset = 0;
        this.dataBufferScanStride = this.width;
        this.dataBufferRGB = (int[])this.image.getRaster().getDataElements(0, 0, this.width, this.height, this.dataBufferRGB);
        SeedFill sf = new SeedFill();
        Rectangle bounds = sf.fill(this.width, this.height, x, y, this, this);
        this.mask = null;
        if (bounds != null) {
            composition.startUpdate();
            this.image.getRaster().setDataElements(0, 0, this.width, this.height, this.dataBufferRGB);
            composition.update(bounds);
            composition.endUpdate();
        }
        return true;
    }

    public void apply(int x, int y) {
        int alpha = this.selection != null ? this.selection.getRGB(x, y) >> 24 & 0xFF : 255;
        int color = this.fillWithPattern && this.sourceImage != null ? this.sourceImage.getRGB(x % this.sourceImage.getWidth(), y % this.sourceImage.getHeight()) : this.newColor;
        int offset = this.dataBufferOffset + y * this.dataBufferScanStride + x;
        this.dataBufferRGB[offset] = alpha == 255 ? color : PixelUtils.combinePixels(color, this.dataBufferRGB[offset], 1, alpha);
        int i = y * this.width + x;
        int n = i >> 6;
        this.mask[n] = this.mask[n] | 1L << (i & 0x3F);
    }

    public boolean thisPixel(int x, int y) {
        int i = y * this.width + x;
        if ((this.mask[i >> 6] & 1L << (i & 0x3F)) != 0L) {
            return false;
        }
        if (this.selection != null && (this.selection.getRGB(x, y) & 0xFF000000) == 0) {
            return false;
        }
        int offset = this.dataBufferOffset + y * this.dataBufferScanStride + x;
        if (this.tolerance == 0) {
            return this.dataBufferRGB[offset] == this.oldColor;
        }
        return PixelUtils.nearColors(this.dataBufferRGB[offset], this.oldColor, this.tolerance);
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new FillToolCustomizer();
    }

    public void setCursor(Component c) {
        if (cursor == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.getImage(this.getClass().getResource("FillTool.gif"));
            cursor = toolkit.createCustomCursor(image, new Point(2, 22), "tool");
        }
        c.setCursor(cursor);
    }

    public char getShortcutKey() {
        return 'f';
    }

    public String getToolTipText() {
        return "Fill Tool";
    }

    public String getHelpText() {
        return "Fill Tool: Meta key picks color";
    }
}

