/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.ie.tool.GradientTool;
import com.jhlabs.image.CombineComboBox;
import com.jhlabs.image.FilterCustomizer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GradientToolCustomizer
extends FilterCustomizer
implements ChangeListener,
ActionListener {
    private GradientTool tool;
    private JCheckBox useColormap;
    private JComboBox shapeGroup;
    private JComboBox interpolationGroup;
    private JComboBox blendChoice;
    private JCheckBox repeatCheck;

    public GradientToolCustomizer() {
        this.setLayout(new SuperGridLayout(1, 0));
        this.useColormap = new JCheckBox("Use Colormap");
        this.add(this.useColormap);
        this.useColormap.addChangeListener(this);
        this.shapeGroup = new JComboBox<String>(new String[]{"Linear", "Bilinear", "Radial", "Clock", "Fan", "Square"});
        this.shapeGroup.setRenderer(new ShapeRenderer());
        this.shapeGroup.addActionListener(this);
        this.add(this.shapeGroup);
        this.interpolationGroup = new JComboBox<String>(new String[]{"Linear", "Circle up", "Circle down"});
        this.interpolationGroup.addActionListener(this);
        this.add(this.interpolationGroup);
        this.blendChoice = new CombineComboBox();
        this.blendChoice.addActionListener(this);
        this.add(this.blendChoice);
        this.repeatCheck = new JCheckBox("Repeat");
        this.add(this.repeatCheck);
        this.repeatCheck.addChangeListener(this);
    }

    public void setObject(Object o) {
        GradientTool tool = (GradientTool)o;
        this.tool = null;
        this.useColormap.setSelected(tool.getUseColormap());
        this.shapeGroup.setSelectedIndex(tool.getType());
        this.interpolationGroup.setSelectedIndex(tool.getInterpolation());
        this.blendChoice.setSelectedIndex(tool.getComposite());
        this.tool = tool;
    }

    public void stateChanged(ChangeEvent e) {
        if (this.tool != null) {
            Object source = e.getSource();
            if (source == this.useColormap) {
                this.tool.setUseColormap(this.useColormap.isSelected());
            } else if (source == this.repeatCheck) {
                this.tool.setRepeat(this.repeatCheck.isSelected());
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.tool != null) {
            Object source = e.getSource();
            if (source == this.shapeGroup) {
                this.tool.setType(this.shapeGroup.getSelectedIndex());
            } else if (source == this.interpolationGroup) {
                this.tool.setInterpolation(this.interpolationGroup.getSelectedIndex());
            } else if (source == this.blendChoice) {
                this.tool.setComposite(this.blendChoice.getSelectedIndex());
            }
        }
    }

    class ShapeRenderer
    extends DefaultListCellRenderer {
        String[] iconNames = new String[]{"gradient_linear.png", "gradient_bilinear.png", "gradient_radial.png", "gradient_conical.png", "gradient_fan.png", "gradient_square.png"};
        ImageIcon[] icons;

        public ShapeRenderer() {
            this.setOpaque(true);
            this.icons = new ImageIcon[this.iconNames.length];
            for (int i = 0; i < this.iconNames.length; ++i) {
                this.icons[i] = new ImageIcon(this.getClass().getResource(this.iconNames[i]));
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
            if (index == -1) {
                index = GradientToolCustomizer.this.shapeGroup.getSelectedIndex();
            }
            if (index >= 0 && index < this.icons.length) {
                this.setIcon(this.icons[index]);
            }
            this.setText(value.toString());
            return this;
        }
    }
}

