/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.composite.MiscComposite;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.DrawingTask;
import com.jhlabs.ie.ImageTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class LineTool
extends ImageTool {
    private boolean antialiased = false;

    public void setAntialiased(boolean antialiased) {
        this.antialiased = antialiased;
    }

    public boolean isAntialiased() {
        return this.antialiased;
    }

    public void doDrag(boolean erase) {
        this.graphics.drawLine(this.startX, this.startY, this.currX, this.currY);
    }

    public void doEndDrag() {
        this.view.doTask(new LineTask(this.view.getComposition(), this.view.XTox(this.startX), this.view.YToy(this.startY), this.view.XTox(this.currX), this.view.YToy(this.currY), this.view.getPaintColor(this.event)));
    }

    public String getToolTipText() {
        return "Line Tool";
    }

    public String getHelpText() {
        return "Line Tool: Meta key picks color";
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new ImageTool.DrawingToolCustomizer();
    }

    class LineTask
    extends DrawingTask {
        private float x1;
        private float y1;
        private float x2;
        private float y2;
        private int color;

        public LineTask(Composition composition, int x1, int y1, int x2, int y2, int color) {
            super(composition);
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.color = color;
        }

        public void doDrawing(Graphics2D g) {
            g.setColor(new Color(this.color));
            GeneralPath path = new GeneralPath();
            g.setStroke(LineTool.this.getPaintingContext().getStroke());
            path.moveTo(this.x1, this.y1);
            path.lineTo(this.x2, this.y2);
            g.draw(path);
        }

        public void doTask() {
            Rectangle r = new Rectangle((int)Math.min(this.x1, this.x2), (int)Math.min(this.y1, this.y2), (int)Math.abs(this.x2 - this.x1) + 1, (int)Math.abs(this.y2 - this.y1) + 1);
            float lineWidth = LineTool.this.getPaintingContext().getLineWidth();
            int width = (int)(lineWidth + 0.5f);
            r.grow(width, width);
            this.doTask(r, MiscComposite.getInstance(LineTool.this.getComposite(), 1.0f));
        }
    }
}

