/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.ie.Composition;
import com.jhlabs.ie.DrawingTask;
import com.jhlabs.ie.ImageTool;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;

public class PathTool
extends ImageTool {
    private GeneralPath path;
    private int freezeX;
    private int freezeY;
    private int firstX;
    private int firstY;
    private boolean first;

    public boolean doStartDrag() {
        boolean b = super.doStartDrag();
        if (b) {
            if (this.path == null) {
                this.path = new GeneralPath();
                this.first = true;
            }
            if (this.first) {
                this.path.moveTo(this.view.XTox(this.currX), this.view.YToy(this.currY));
                this.freezeX = this.currX;
                this.freezeY = this.currY;
                this.firstX = this.currX;
                this.firstY = this.currY;
            } else {
                this.path.lineTo(this.view.XTox(this.currX), this.view.YToy(this.currY));
            }
        }
        return true;
    }

    public void doDrag(boolean erase) {
        this.graphics.drawLine(this.freezeX, this.freezeY, this.currX, this.currY);
    }

    public void doEndDrag() {
        this.graphics.drawLine(this.freezeX, this.freezeY, this.currX, this.currY);
        if (!this.first && Math.abs(this.currX - this.firstX) < 3 && Math.abs(this.currY - this.firstY) < 3) {
            this.view.doTask(new PathTask(this.view.getComposition(), this.path, this.view.getPaintColor(this.event), this.event.isShiftDown()));
            this.path = null;
        } else {
            if (this.first) {
                this.firstX = this.currX;
                this.firstY = this.currY;
            }
            this.path.lineTo(this.view.XTox(this.currX), this.view.YToy(this.currY));
            this.first = false;
            this.freezeX = this.currX;
            this.freezeY = this.currY;
        }
    }

    public String getToolTipText() {
        return "Path Tool";
    }

    public String getHelpText() {
        return "Path Tool: Meta key picks color, Shift key fills";
    }

    class PathTask
    extends DrawingTask {
        private GeneralPath path;
        private int color;
        private boolean fill;

        public PathTask(Composition composition, GeneralPath path, int color, boolean fill) {
            super(composition);
            this.path = path;
            this.color = color;
            this.fill = fill;
        }

        public void doDrawing(Graphics2D g) {
            g.setColor(new Color(this.color));
            g.setStroke(PathTool.this.getPaintingContext().getStroke());
            if (this.fill) {
                g.fill(this.path);
            } else {
                g.draw(this.path);
            }
        }

        public void doTask() {
            this.doTask(this.path.getBounds());
        }
    }
}

