/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ConvolveFilter;
import com.jhlabs.image.PreviewFilterCustomizer;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.Kernel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ConvolveFilterCustomizer
extends PreviewFilterCustomizer
implements ActionListener,
DocumentListener {
    private JTextField[] eText;
    private JTextField targetText;
    private JButton normalizeButton;
    private ConvolveFilter filter;

    public ConvolveFilterCustomizer() {
        JPanel p = new JPanel();
        this.add((Component)p, "Center");
        p.setLayout(new GridLayout(5, 5));
        this.eText = new JTextField[25];
        for (int i = 0; i < 25; ++i) {
            this.eText[i] = new JTextField(4);
            p.add(this.eText[i]);
            this.eText[i].getDocument().addDocumentListener(this);
        }
        p = new JPanel();
        p.add(new JLabel("Target:", 4));
        this.targetText = new JTextField(4);
        p.add(this.targetText);
        this.targetText.getDocument().addDocumentListener(this);
        this.normalizeButton = new JButton("Normalize");
        p.add(this.normalizeButton);
        this.normalizeButton.addActionListener(this);
        this.add((Component)p, "South");
    }

    public void setObject(Object o) {
        super.setObject(o);
        this.filter = (ConvolveFilter)o;
        Kernel k = this.filter.getKernel();
        if (k == null || k.getHeight() != 5 || k.getWidth() != 5) {
            float[] d = new float[25];
            d[12] = 1.0f;
            k = new Kernel(5, 5, d);
            this.filter.setKernel(k);
        }
        float[] a = k.getKernelData(null);
        for (int i = 0; i < 25; ++i) {
            this.eText[i].setText(Float.toString(a[i]));
        }
        this.targetText.setText("1");
        this.preview();
    }

    public void insertUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void textValueChanged(DocumentEvent event) {
        if (this.filter != null) {
            try {
                float[] a = new float[25];
                for (int i = 0; i < 25; ++i) {
                    a[i] = Float.parseFloat(this.eText[i].getText());
                }
                float target = new Float(this.targetText.getText()).floatValue();
                int i = 0;
                while (i < 25) {
                    int n = i++;
                    a[n] = a[n] / target;
                }
                this.filter.setKernel(new Kernel(5, 5, a));
                this.preview();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.filter != null) {
            try {
                int i;
                float[] a = new float[25];
                for (int i2 = 0; i2 < 25; ++i2) {
                    a[i2] = Float.parseFloat(this.eText[i2].getText());
                }
                float target = 0.0f;
                for (i = 0; i < 25; ++i) {
                    target += a[i];
                }
                i = 0;
                while (i < 25) {
                    int n = i++;
                    a[n] = a[n] / target;
                }
                this.targetText.setText(Float.toString(target));
                this.preview();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

