/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.image.DilateFilter;
import com.jhlabs.image.PreviewFilterCustomizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DilateFilterCustomizer
extends PreviewFilterCustomizer
implements ChangeListener,
ActionListener {
    private JSlider threshold;
    private JSlider iterations;
    private JButton newColorButton;
    private DilateFilter filter;

    public DilateFilterCustomizer() {
        JPanel p = new JPanel();
        this.add((Component)p, "South");
        SuperGridLayout sgl = new SuperGridLayout(0, 2);
        p.setLayout(sgl);
        sgl.setColWeight(1, 1);
        p.add(new JLabel("Threshold:", 4));
        this.threshold = new JSlider(0, 1, 8, 4);
        p.add(this.threshold);
        this.threshold.setPaintTicks(true);
        this.threshold.setMajorTickSpacing(4);
        this.threshold.setMinorTickSpacing(1);
        this.threshold.setPaintLabels(true);
        this.threshold.addChangeListener(this);
        p.add(new JLabel("Iterations:", 4));
        this.iterations = new JSlider(0, 0, 100, 1);
        p.add(this.iterations);
        this.iterations.setPaintTicks(true);
        this.iterations.setMajorTickSpacing(50);
        this.iterations.setMinorTickSpacing(10);
        this.iterations.setPaintLabels(true);
        this.iterations.addChangeListener(this);
        this.newColorButton = new JButton("Color...");
        p.add(this.newColorButton);
        this.newColorButton.addActionListener(this);
    }

    public void setObject(Object o) {
        super.setObject(o);
        this.filter = (DilateFilter)o;
        this.threshold.setValue(this.filter.getThreshold());
        this.iterations.setValue(this.filter.getIterations());
    }

    public void stateChanged(ChangeEvent e) {
        if (this.filter != null) {
            Object source = e.getSource();
            if (source instanceof JSlider && ((JSlider)source).getValueIsAdjusting()) {
                return;
            }
            if (source == this.threshold) {
                this.filter.setThreshold(this.threshold.getValue());
            } else if (source == this.iterations) {
                this.filter.setIterations(this.iterations.getValue());
            }
            this.preview();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this.filter != null) {
            Color color;
            if (source == this.newColorButton && (color = JColorChooser.showDialog(this, "New Color", new Color(this.filter.getNewColor()))) != null) {
                this.filter.setNewColor(color.getRGB());
            }
            this.preview();
        }
    }
}

