/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.ParagraphLayout;
import com.jhlabs.image.DitherFilter;
import com.jhlabs.image.PreviewFilterCustomizer;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DitherFilterCustomizer
extends PreviewFilterCustomizer
implements ItemListener {
    private JCheckBox colorCheck;
    private JComboBox matrixChoice;
    private JComboBox levelsChoice;
    private DitherFilter filter;

    public DitherFilterCustomizer() {
        JPanel p = new JPanel();
        this.add((Component)p, "Center");
        p.setLayout(new ParagraphLayout());
        p.add((Component)new JLabel("", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.colorCheck = new JCheckBox("Color Dither");
        p.add(this.colorCheck);
        this.colorCheck.addItemListener(this);
        p.add((Component)new JLabel("Dither Matrix:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.matrixChoice = new JComboBox();
        p.add(this.matrixChoice);
        this.matrixChoice.addItemListener(this);
        this.matrixChoice.addItem("2 x 2 Ordered Dither");
        this.matrixChoice.addItem("4 x 4 Ordered Dither");
        this.matrixChoice.addItem("6 x 6 Ordered Dither");
        this.matrixChoice.addItem("8 x 8 Ordered Dither");
        this.matrixChoice.addItem("4 x 4 Magic Square");
        this.matrixChoice.addItem("Cluster 3");
        this.matrixChoice.addItem("Cluster 4");
        this.matrixChoice.addItem("Cluster 8");
        this.matrixChoice.addItem("6 x 6 Horizontal Lines");
        this.matrixChoice.addItem("6 x 6 90 degree Halftone");
        p.add((Component)new JLabel("Levels:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.levelsChoice = new JComboBox();
        p.add(this.levelsChoice);
        this.levelsChoice.addItemListener(this);
        this.levelsChoice.addItem("2 (Black and White)");
        this.levelsChoice.addItem("4");
        this.levelsChoice.addItem("5");
        this.levelsChoice.addItem("6 (World Wide Web)");
        this.levelsChoice.addItem("8");
        this.levelsChoice.addItem("16");
    }

    public void setObject(Object o) {
        super.setObject(o);
        this.filter = (DitherFilter)o;
        this.colorCheck.setSelected(this.filter.getColorDither());
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (this.filter != null) {
            if (source == this.matrixChoice) {
                switch (this.matrixChoice.getSelectedIndex()) {
                    case 0: {
                        this.filter.setMatrix(DitherFilter.ditherMagic2x2Matrix);
                        break;
                    }
                    case 1: {
                        this.filter.setMatrix(DitherFilter.ditherOrdered4x4Matrix);
                        break;
                    }
                    case 2: {
                        this.filter.setMatrix(DitherFilter.ditherOrdered6x6Matrix);
                        break;
                    }
                    case 3: {
                        this.filter.setMatrix(DitherFilter.ditherOrdered6x6Matrix);
                        break;
                    }
                    case 4: {
                        this.filter.setMatrix(DitherFilter.ditherMagic4x4Matrix);
                        break;
                    }
                    case 5: {
                        this.filter.setMatrix(DitherFilter.ditherCluster3Matrix);
                        break;
                    }
                    case 6: {
                        this.filter.setMatrix(DitherFilter.ditherCluster4Matrix);
                        break;
                    }
                    case 7: {
                        this.filter.setMatrix(DitherFilter.ditherCluster8Matrix);
                        break;
                    }
                    case 8: {
                        this.filter.setMatrix(DitherFilter.ditherLines4x4Matrix);
                        break;
                    }
                    default: {
                        this.filter.setMatrix(DitherFilter.dither90Halftone6x6Matrix);
                        break;
                    }
                }
            } else if (source == this.levelsChoice) {
                switch (this.levelsChoice.getSelectedIndex()) {
                    case 0: {
                        this.filter.setLevels(2);
                        break;
                    }
                    case 1: {
                        this.filter.setLevels(4);
                        break;
                    }
                    case 2: {
                        this.filter.setLevels(5);
                        break;
                    }
                    case 3: {
                        this.filter.setLevels(6);
                        break;
                    }
                    case 4: {
                        this.filter.setLevels(8);
                        break;
                    }
                    default: {
                        this.filter.setLevels(16);
                        break;
                    }
                }
            } else if (source == this.colorCheck) {
                this.filter.setColorDither(this.colorCheck.isSelected());
            }
            this.preview();
        }
    }
}

