/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.image.ColormapWell;
import com.jhlabs.image.FBMFilter;
import com.jhlabs.image.PreviewFilterCustomizer;
import com.jhlabs.math.CellularFunction2DCustomizer;
import com.jhlabs.math.VLNoiseCustomizer;
import com.jhlabs.swing.SliderFactory;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FBMFilterCustomizer
extends PreviewFilterCustomizer
implements ChangeListener,
ItemListener {
    private JSlider scale;
    private JSlider stretch;
    private JSlider angle;
    private JSlider amount;
    private JSlider octaves;
    private JSlider H;
    private JSlider lacunarity;
    private JSlider gain;
    private JSlider bias;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JComboBox typeChoice;
    private FBMFilter filter;
    private Customizer functionCustomizer;
    private JPanel functionPanel;
    private ColormapWell colormapWell;

    public FBMFilterCustomizer() {
        JPanel p = new JPanel();
        SuperGridLayout sgl = new SuperGridLayout(3, 2);
        p.setLayout(sgl);
        sgl.setColWeight(1, 1);
        p.add(new JLabel("Scale:", 4));
        this.scale = new JSlider(0, 1, 256, 32);
        p.add(this.scale);
        this.scale.setPaintTicks(true);
        this.scale.setMajorTickSpacing(64);
        this.scale.setMinorTickSpacing(8);
        this.scale.setPaintLabels(true);
        this.scale.addChangeListener(this);
        p.add(new JLabel("Stretch:", 4));
        this.stretch = new JSlider(0, 1, 100, 1);
        p.add(this.stretch);
        this.stretch.setPaintTicks(true);
        this.stretch.setMajorTickSpacing(50);
        this.stretch.setMinorTickSpacing(10);
        this.stretch.setPaintLabels(true);
        this.stretch.addChangeListener(this);
        p.add(new JLabel("Angle:", 4));
        this.angle = SliderFactory.create360AngleSlider();
        p.add(this.angle);
        this.angle.addChangeListener(this);
        p.add(new JLabel("Amount (%):", 4));
        this.amount = new JSlider(0, 0, 200, 0);
        p.add(this.amount);
        this.amount.setPaintTicks(true);
        this.amount.setMajorTickSpacing(100);
        this.amount.setMinorTickSpacing(5);
        this.amount.setPaintLabels(true);
        this.amount.addChangeListener(this);
        p.add(new JLabel("Gain:", 4));
        this.gain = SliderFactory.createPercentageSlider();
        p.add(this.gain);
        this.gain.addChangeListener(this);
        p.add(new JLabel("Bias:", 4));
        this.bias = SliderFactory.createPercentageSlider();
        p.add(this.bias);
        this.bias.addChangeListener(this);
        this.tabbedPane.addTab("FBM", p);
        p = new JPanel();
        this.add((Component)p, "South");
        sgl = new SuperGridLayout(3, 2);
        p.setLayout(sgl);
        sgl.setColWeight(1, 1);
        p.add(new JLabel("H:", 4));
        this.H = new JSlider(0, 0, 200, 0);
        p.add(this.H);
        this.H.setPaintTicks(true);
        this.H.setMajorTickSpacing(100);
        this.H.setMinorTickSpacing(20);
        this.H.setPaintLabels(true);
        this.H.addChangeListener(this);
        p.add(new JLabel("Octaves:", 4));
        this.octaves = new JSlider(0, 0, 100, 0);
        p.add(this.octaves);
        this.octaves.setPaintTicks(true);
        this.octaves.setMajorTickSpacing(100);
        this.octaves.setMinorTickSpacing(20);
        this.octaves.setPaintLabels(true);
        this.octaves.addChangeListener(this);
        p.add(new JLabel("Lacunarity:", 4));
        this.lacunarity = new JSlider(0, 0, 300, 0);
        p.add(this.lacunarity);
        this.lacunarity.setPaintTicks(true);
        this.lacunarity.setMajorTickSpacing(100);
        this.lacunarity.setMinorTickSpacing(20);
        this.lacunarity.setPaintLabels(true);
        this.lacunarity.addChangeListener(this);
        p.add(new JLabel("Type:", 4));
        this.typeChoice = new JComboBox();
        this.typeChoice.addItem("Noise");
        this.typeChoice.addItem("Ridged Noise");
        this.typeChoice.addItem("Distorted Noise");
        this.typeChoice.addItem("Sparse Convolution Noise");
        this.typeChoice.addItem("Cellular");
        this.typeChoice.addItemListener(this);
        p.add(this.typeChoice);
        p.add(new JLabel("Gradient:", 4));
        this.colormapWell = new ColormapWell();
        p.add(this.colormapWell);
        this.colormapWell.addChangeListener(this);
        this.tabbedPane.addTab("Function", p);
        this.functionPanel = new JPanel();
        this.tabbedPane.addTab("Basis", this.functionPanel);
        this.add((Component)this.tabbedPane, "South");
    }

    public void setObject(Object o) {
        super.setObject(o);
        FBMFilter filter = (FBMFilter)o;
        this.filter = null;
        this.setControls(filter);
        this.setFunctionCustomizer();
    }

    public void setControls(FBMFilter filter) {
        this.filter = null;
        this.scale.setValue((int)filter.getScale());
        this.stretch.setValue((int)filter.getStretch() * 10);
        this.angle.setValue((int)((double)(filter.getAngle() * 180.0f) / Math.PI));
        this.amount.setValue((int)((double)filter.getAmount() * 100.0));
        this.H.setValue((int)((double)filter.getH() * 100.0));
        this.octaves.setValue((int)(((double)filter.getOctaves() - 1.0) * 100.0 / 10.0));
        this.lacunarity.setValue((int)((double)filter.getLacunarity() * 100.0));
        this.gain.setValue((int)((double)filter.getGain() * 100.0));
        this.bias.setValue((int)((double)filter.getBias() * 100.0));
        this.typeChoice.setSelectedIndex(filter.getBasisType());
        this.colormapWell.setColormap(filter.getColormap());
        this.filter = filter;
    }

    public void stateChanged(ChangeEvent e) {
        if (this.filter != null) {
            Object source = e.getSource();
            if (source instanceof JSlider && ((JSlider)source).getValueIsAdjusting()) {
                return;
            }
            if (source == this.scale) {
                this.filter.setScale(this.scale.getValue());
            } else if (source == this.stretch) {
                this.filter.setStretch(this.stretch.getValue() / 10);
            } else if (source == this.angle) {
                this.filter.setAngle((float)this.angle.getValue() * (float)Math.PI / 180.0f);
            } else if (source == this.amount) {
                this.filter.setAmount((float)this.amount.getValue() / 100.0f);
            } else if (source == this.H) {
                this.filter.setH((float)this.H.getValue() / 100.0f);
            } else if (source == this.octaves) {
                this.filter.setOctaves(1.0f + (float)this.octaves.getValue() / 10.0f);
            } else if (source == this.lacunarity) {
                this.filter.setLacunarity((float)this.lacunarity.getValue() / 100.0f);
            } else if (source == this.gain) {
                this.filter.setGain((float)this.gain.getValue() / 100.0f);
            } else if (source == this.bias) {
                this.filter.setBias((float)this.bias.getValue() / 100.0f);
            } else if (source == this.colormapWell) {
                this.filter.setColormap(this.colormapWell.getColormap());
            }
            this.preview();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (this.filter != null) {
            if (source == this.typeChoice) {
                this.filter.setBasisType(this.typeChoice.getSelectedIndex());
                this.setFunctionCustomizer();
            }
            this.preview();
        }
    }

    private void setFunctionCustomizer() {
        if (this.functionCustomizer != null) {
            this.functionPanel.remove((Component)((Object)this.functionCustomizer));
        }
        this.functionCustomizer = null;
        switch (this.filter.getBasisType()) {
            default: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.functionCustomizer = new VLNoiseCustomizer();
                this.functionCustomizer.setObject(this.filter.getBasis());
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.functionCustomizer = new CellularFunction2DCustomizer();
                this.functionCustomizer.setObject(this.filter.getBasis());
            }
        }
        if (this.functionCustomizer != null) {
            this.functionPanel.add((Component)((Object)this.functionCustomizer));
        }
    }
}

