/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.image.BicubicScaleFilter;
import com.jhlabs.image.CropFilter;
import com.jhlabs.image.FilterCustomizer;
import com.jhlabs.image.ScaleFilter;
import com.jhlabs.image.TileImageFilter;
import com.jhlabs.image.TileImageFilterCustomizer;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImageOp;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ScaleFilterCustomizer
extends FilterCustomizer
implements ChangeListener,
DocumentListener {
    private JTextField widthText;
    private JTextField heightText;
    private JCheckBox keepAspectCheck;
    private JRadioButton dontScaleRB;
    private JRadioButton replicateRB;
    private JRadioButton bilinearRB;
    private JRadioButton bicubicRB;
    private JRadioButton averageRB;
    private JRadioButton tileRB;
    private ButtonGroup group;
    private TileImageFilterCustomizer tileOptions;
    private int oldWidth;
    private int oldHeight;
    private int width;
    private int height;
    private double aspectRatio;
    private boolean inChange = false;

    public ScaleFilterCustomizer(int width, int height) {
        this.width = this.oldWidth = width;
        this.height = this.oldHeight = height;
        this.setLayout(new SuperGridLayout(2, 1, 4, 4, 8, 8));
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder("Size"));
        SuperGridLayout sgl = new SuperGridLayout(2, 1);
        JPanel p2 = new JPanel();
        sgl = new SuperGridLayout(2, 2);
        sgl.setColWeight(1, 1);
        p2.setLayout(sgl);
        p2.add(new JLabel("Width:", 4));
        this.widthText = new JTextField(8);
        p2.add(this.widthText);
        p2.add(new JLabel("Height:", 4));
        this.heightText = new JTextField(8);
        p2.add(this.heightText);
        p.add(p2);
        this.keepAspectCheck = new JCheckBox("Keep aspect ratio");
        p.add(this.keepAspectCheck);
        this.keepAspectCheck.setSelected(true);
        this.add(p);
        p = new JPanel();
        sgl = new SuperGridLayout(3, 1);
        p.setLayout(sgl);
        sgl.setAlignment(7);
        sgl.setFill(0);
        p.setBorder(BorderFactory.createTitledBorder("Scaling"));
        this.dontScaleRB = new JRadioButton("Don't rescale image");
        p.add(this.dontScaleRB);
        this.replicateRB = new JRadioButton("Replicate pixels");
        p.add(this.replicateRB);
        this.bilinearRB = new JRadioButton("Bilinear interpolation");
        p.add(this.bilinearRB);
        this.bicubicRB = new JRadioButton("Bicubic interpolation");
        p.add(this.bicubicRB);
        this.averageRB = new JRadioButton("Area-averaging");
        p.add(this.averageRB);
        this.tileRB = new JRadioButton("Tile image");
        p.add(this.tileRB);
        this.tileRB.addChangeListener(this);
        this.add(p);
        this.group = new ButtonGroup();
        this.group.add(this.dontScaleRB);
        this.group.add(this.replicateRB);
        this.group.add(this.bilinearRB);
        this.group.add(this.bicubicRB);
        this.group.add(this.averageRB);
        this.group.add(this.tileRB);
        this.bilinearRB.setSelected(true);
        this.aspectRatio = (double)height / (double)width;
        this.widthText.setText(Integer.toString(width));
        this.heightText.setText(Integer.toString(height));
        this.widthText.getDocument().addDocumentListener(this);
        this.heightText.getDocument().addDocumentListener(this);
    }

    public void setObject(Object o) {
    }

    public BufferedImageOp getFilter() {
        if (this.dontScaleRB.isSelected()) {
            return new CropFilter(-(this.width - this.oldWidth) / 2, -(this.height - this.oldHeight) / 2, this.width, this.height);
        }
        if (this.replicateRB.isSelected()) {
            return new AffineTransformOp(AffineTransform.getScaleInstance((double)this.width / (double)this.oldWidth, (double)this.height / (double)this.oldHeight), 1);
        }
        if (this.bilinearRB.isSelected()) {
            return new AffineTransformOp(AffineTransform.getScaleInstance((double)this.width / (double)this.oldWidth, (double)this.height / (double)this.oldHeight), 2);
        }
        if (this.bicubicRB.isSelected()) {
            return new BicubicScaleFilter(this.width, this.height);
        }
        if (this.tileRB.isSelected()) {
            return new TileImageFilter(this.width, this.height);
        }
        return new ScaleFilter(this.width, this.height);
    }

    private void setText(JTextField t, String s) {
        this.inChange = true;
        if (!s.equals(t.getText())) {
            t.setText(s);
        }
        this.inChange = false;
    }

    public void stateChanged(ChangeEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void textValueChanged(DocumentEvent event) {
        Document document = event.getDocument();
        if (this.inChange) {
            return;
        }
        try {
            if (document == this.widthText.getDocument()) {
                this.width = Integer.parseInt(this.widthText.getText());
                if (this.keepAspectCheck.isSelected()) {
                    this.height = (int)(this.aspectRatio * (double)this.width);
                    this.setText(this.heightText, Integer.toString(this.height));
                }
            } else if (document == this.heightText.getDocument()) {
                this.height = Integer.parseInt(this.heightText.getText());
                if (this.keepAspectCheck.isSelected()) {
                    this.width = (int)((double)this.height / this.aspectRatio);
                    this.setText(this.widthText, Integer.toString(this.width));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getNewWidth() {
        return this.width;
    }

    public int getNewHeight() {
        return this.height;
    }
}

