/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.image.PreviewFilterCustomizer;
import com.jhlabs.image.SwizzleFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SwizzleFilterCustomizer
extends PreviewFilterCustomizer
implements ChangeListener {
    private JToggleButton[] crossings;
    private int rows = 4;
    private int cols = 5;
    private SwizzleFilter filter;

    public SwizzleFilterCustomizer() {
        String[] labels = new String[]{"A", "R", "G", "B", "1"};
        JPanel p = new JPanel();
        this.add((Component)p, "Center");
        SuperGridLayout sgl = new SuperGridLayout(2, 2);
        p.setLayout(sgl);
        sgl.setColWeight(1, 1);
        JPanel p2 = new JPanel();
        p2.setLayout(new SuperGridLayout(0, 1));
        p.add(p2);
        p2 = new JPanel();
        p.add(p2);
        JPanel p3 = new JPanel();
        p2.add(p3);
        p3.setLayout(new GridLayout(this.rows + 1, this.cols + 1));
        this.crossings = new JRadioButton[this.rows * this.cols];
        SwizzleIcon selectedIcon = new SwizzleIcon(true);
        SwizzleIcon unselectedIcon = new SwizzleIcon(false);
        Insets nullInsets = new Insets(0, 0, 0, 0);
        p3.add(new JLabel());
        for (int col = 0; col < this.cols; ++col) {
            p3.add(new JLabel(labels[col]));
        }
        for (int row = 0; row < this.rows; ++row) {
            p3.add(new JLabel(labels[row]));
            for (int col = 0; col < this.cols; ++col) {
                JRadioButton b;
                JRadioButton jRadioButton = b = new JRadioButton();
                this.crossings[row * this.cols + col] = jRadioButton;
                p3.add(jRadioButton);
                b.addChangeListener(this);
                b.setIcon(unselectedIcon);
                b.setSelectedIcon(selectedIcon);
                b.setBorderPainted(false);
                b.setMargin(nullInsets);
            }
        }
    }

    private void setCrossings(int[] c) {
        for (int row = 0; row < this.rows * this.cols; ++row) {
            this.crossings[row].setSelected(c[row] != 0);
        }
    }

    private int[] getCrossings() {
        int[] c = new int[this.rows * this.cols];
        for (int row = 0; row < this.rows * this.cols; ++row) {
            c[row] = this.crossings[row].isSelected() ? 1 : 0;
        }
        return c;
    }

    public void setObject(Object o) {
        super.setObject(o);
        this.filter = (SwizzleFilter)o;
        this.setCrossings(this.filter.getMatrix());
    }

    public void stateChanged(ChangeEvent e) {
        if (this.filter != null) {
            Object source = e.getSource();
            this.filter.setMatrix(this.getCrossings());
            this.preview();
        }
    }

    class SwizzleIcon
    implements Icon {
        private boolean selected;

        public SwizzleIcon(boolean selected) {
            this.selected = selected;
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(this.selected ? Color.black : Color.lightGray);
            g.fillOval(2, 2, 12, 12);
        }
    }
}

