/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.util.Memento;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class TileCache
extends Rectangle
implements Memento {
    private static final int TILE_WIDTH = 64;
    private static final int TILE_HEIGHT = 64;
    private BufferedImage image;
    private BufferedImage[] tiles;
    private int width;
    private int height;
    private int tilesX;
    private int tilesY;

    public TileCache(BufferedImage image) {
        this.image = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.tilesX = (this.width + 64 - 1) / 64;
        this.tilesY = (this.height + 64 - 1) / 64;
    }

    public Rectangle getBounds() {
        return this;
    }

    public void touchRectangle(int x, int y, int w, int h) {
        int ty0 = y / 64;
        int ty1 = (y + h) / 64;
        int tx0 = x / 64;
        int tx1 = (x + w) / 64;
        for (int ty = ty0; ty <= ty1; ++ty) {
            for (int tx = tx0; tx <= tx1; ++tx) {
                this.touchTile(tx, ty);
            }
        }
        this.add(x, y);
        this.add(x + w, y + h);
    }

    public void touchPoint(int x, int y) {
        this.touchTile(x / 64, y / 64);
        this.add(x, y);
    }

    public void touchTile(int tx, int ty) {
        int index;
        if (this.tiles == null) {
            this.tiles = new BufferedImage[this.tilesX * this.tilesY];
        }
        if (tx >= 0 && ty >= 0 && tx < this.tilesX && ty < this.tilesY && this.tiles[index = ty * this.tilesX + tx] == null) {
            int x = tx * 64;
            int y = ty * 64;
            int w = Math.min(64, this.width - x);
            int h = Math.min(64, this.height - y);
            BufferedImage tile = new BufferedImage(64, 64, this.image.getType());
            Graphics2D tileGraphics = tile.createGraphics();
            tileGraphics.setComposite(AlphaComposite.Src);
            tileGraphics.drawImage((Image)this.image, -x, -y, null);
            tileGraphics.dispose();
            this.tiles[index] = tile;
        }
    }

    public void restore() {
        if (this.tiles != null) {
            BufferedImage tile = null;
            Graphics2D imageGraphics = this.image.createGraphics();
            imageGraphics.setComposite(AlphaComposite.Src);
            for (int ty = 0; ty < this.tilesY; ++ty) {
                for (int tx = 0; tx < this.tilesX; ++tx) {
                    int index = ty * this.tilesX + tx;
                    if (this.tiles[index] == null) continue;
                    int x = tx * 64;
                    int y = ty * 64;
                    if (tile == null) {
                        tile = new BufferedImage(64, 64, this.image.getType());
                    }
                    Graphics2D tileGraphics = tile.createGraphics();
                    tileGraphics.setComposite(AlphaComposite.Src);
                    tileGraphics.drawImage((Image)this.image, -x, -y, null);
                    imageGraphics.drawImage((Image)this.tiles[index], x, y, null);
                    tileGraphics.dispose();
                    BufferedImage t = this.tiles[index];
                    this.tiles[index] = tile;
                    tile = t;
                }
            }
            imageGraphics.dispose();
        }
    }

    public void paint(Graphics2D g) {
        if (this.tiles != null) {
            g.setColor(Color.blue);
            g.setComposite(AlphaComposite.getInstance(3, 0.5f));
            for (int ty = 0; ty < this.tilesY; ++ty) {
                for (int tx = 0; tx < this.tilesX; ++tx) {
                    int index = ty * this.tilesX + tx;
                    if (this.tiles[index] == null) continue;
                    g.fillRect(tx * 64, ty * 64, this.tiles[index].getWidth(), this.tiles[index].getHeight());
                }
            }
        }
    }
}

