/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.image.PreviewFilterCustomizer;
import com.jhlabs.image.TileImageFilter;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class TileImageFilterCustomizer
extends PreviewFilterCustomizer
implements ActionListener {
    private SymmetryButton[][] symmetry;
    private int rows = 4;
    private int cols = 4;
    private TileImageFilter filter;

    public TileImageFilterCustomizer() {
        JPanel p = new JPanel();
        this.add((Component)p, "Center");
        SuperGridLayout sgl = new SuperGridLayout(2, 2);
        p.setLayout(sgl);
        sgl.setColWeight(1, 1);
        JPanel p2 = new JPanel();
        p.add(p2);
        JPanel p3 = new JPanel();
        p2.add(p3);
        p3.setLayout(new GridLayout(this.rows, this.cols));
        this.symmetry = new SymmetryButton[this.rows][];
        for (int row = 0; row < this.rows; ++row) {
            this.symmetry[row] = new SymmetryButton[this.cols];
            for (int col = 0; col < this.cols; ++col) {
                SymmetryButton b;
                SymmetryButton symmetryButton = b = new SymmetryButton();
                this.symmetry[row][col] = symmetryButton;
                p3.add(symmetryButton);
                b.addActionListener(this);
            }
        }
        p3.setBorder(new TitledBorder("Symmetry"));
    }

    private void setSymmetry(int[][] c) {
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                this.symmetry[row][col].setState(c[row][col]);
            }
        }
    }

    private int[][] getSymmetry() {
        int[][] c = new int[this.rows][];
        for (int row = 0; row < this.rows; ++row) {
            c[row] = new int[this.cols];
            for (int col = 0; col < this.cols; ++col) {
                c[row][col] = this.symmetry[row][col].getState();
            }
        }
        return c;
    }

    public void setObject(Object o) {
        super.setObject(o);
        this.filter = (TileImageFilter)o;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.filter != null) {
            Object source = e.getSource();
            this.preview();
        }
    }

    class SymmetryButton
    extends JButton
    implements ActionListener {
        private int state;

        public SymmetryButton() {
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            this.setState((this.state + 1) % 5);
        }

        public void setState(int state) {
            this.state = state;
            this.setText(Integer.toString(state));
        }

        public int getState() {
            return this.state;
        }
    }
}

