/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PointFilter;
import com.jhlabs.image.PreviewFilterCustomizer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class TransferFilterCustomizer
extends PreviewFilterCustomizer {
    protected TransferGraph graph;

    protected void addCenter(Container c) {
        this.graph = new TransferGraph();
        c.add(this.graph);
    }

    public void preview() {
        super.preview();
        this.graph.repaint();
    }

    public int evaluate(int x) {
        if (this.filter != null) {
            int rgb = ((PointFilter)this.filter).filterRGB(0, 0, 0xFF000000 | x);
            return rgb & 0xFF;
        }
        return 0;
    }

    class TransferGraph
    extends JComponent {
        TransferGraph() {
        }

        public Dimension getMinimumSize() {
            return new Dimension(102, 102);
        }

        public Dimension getPreferredSize() {
            return new Dimension(102, 102);
        }

        public void paintComponent(Graphics g) {
            if (TransferFilterCustomizer.this.filter != null) {
                g.setColor(Color.white);
                g.fillRect(1, 1, 100, 100);
                g.setColor(Color.lightGray);
                g.drawLine(1, 101, 101, 1);
                g.setColor(Color.black);
                g.drawRect(0, 0, 101, 101);
                g.setColor(Color.black);
                int lastY = 0;
                for (int x = 0; x < 100; ++x) {
                    int y = 101 - TransferFilterCustomizer.this.evaluate(256 * x / 100) * 100 / 256;
                    if (x != 0) {
                        g.drawLine(x, lastY, 1 + x, y);
                    }
                    lastY = y;
                }
            }
        }
    }
}

