/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.image.PreviewFilterCustomizer;
import com.jhlabs.image.WeaveFilter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WeaveFilterCustomizer
extends PreviewFilterCustomizer
implements ChangeListener {
    private JSlider xWidth;
    private JSlider yWidth;
    private JSlider xGap;
    private JSlider yGap;
    private JCheckBox useImageColors;
    private JCheckBox roundThreads;
    private JCheckBox shadeCrossings;
    private JToggleButton[][] crossings;
    private int rows = 4;
    private int cols = 4;
    private WeaveFilter filter;

    public WeaveFilterCustomizer() {
        JPanel p = new JPanel();
        this.add((Component)p, "Center");
        SuperGridLayout sgl = new SuperGridLayout(2, 2);
        p.setLayout(sgl);
        sgl.setColWeight(1, 1);
        p.add(new JLabel("X Width:", 4));
        this.xWidth = new JSlider(0, 1, 256, 32);
        p.add(this.xWidth);
        this.xWidth.setPaintTicks(true);
        this.xWidth.setMajorTickSpacing(64);
        this.xWidth.setMinorTickSpacing(8);
        this.xWidth.setPaintLabels(true);
        this.xWidth.addChangeListener(this);
        p.add(new JLabel("Y Width:", 4));
        this.yWidth = new JSlider(0, 1, 256, 32);
        p.add(this.yWidth);
        this.yWidth.setPaintTicks(true);
        this.yWidth.setMajorTickSpacing(64);
        this.yWidth.setMinorTickSpacing(8);
        this.yWidth.setPaintLabels(true);
        this.yWidth.addChangeListener(this);
        p.add(new JLabel("X Gap:", 4));
        this.xGap = new JSlider(0, 1, 256, 32);
        p.add(this.xGap);
        this.xGap.setPaintTicks(true);
        this.xGap.setMajorTickSpacing(64);
        this.xGap.setMinorTickSpacing(8);
        this.xGap.setPaintLabels(true);
        this.xGap.addChangeListener(this);
        p.add(new JLabel("Y Gap:", 4));
        this.yGap = new JSlider(0, 1, 256, 32);
        p.add(this.yGap);
        this.yGap.setPaintTicks(true);
        this.yGap.setMajorTickSpacing(64);
        this.yGap.setMinorTickSpacing(8);
        this.yGap.setPaintLabels(true);
        this.yGap.addChangeListener(this);
        JPanel p2 = new JPanel();
        p2.setLayout(new SuperGridLayout(0, 1));
        p.add(p2);
        this.useImageColors = new JCheckBox("Use Image Colors");
        p2.add(this.useImageColors);
        this.useImageColors.addChangeListener(this);
        this.roundThreads = new JCheckBox("Round Threads");
        p2.add(this.roundThreads);
        this.roundThreads.addChangeListener(this);
        this.shadeCrossings = new JCheckBox("Shade Crossings");
        p2.add(this.shadeCrossings);
        this.shadeCrossings.addChangeListener(this);
        p2 = new JPanel();
        p.add(p2);
        JPanel p3 = new JPanel();
        p2.add(p3);
        p3.setLayout(new GridLayout(this.rows, this.cols));
        this.crossings = new JRadioButton[this.rows][];
        CrossIcon hCross = new CrossIcon(true);
        CrossIcon vCross = new CrossIcon(false);
        Insets nullInsets = new Insets(0, 0, 0, 0);
        for (int row = 0; row < this.rows; ++row) {
            this.crossings[row] = new JRadioButton[this.cols];
            for (int col = 0; col < this.cols; ++col) {
                JRadioButton b;
                JRadioButton jRadioButton = b = new JRadioButton();
                this.crossings[row][col] = jRadioButton;
                p3.add(jRadioButton);
                b.addChangeListener(this);
                b.setIcon(hCross);
                b.setSelectedIcon(vCross);
                b.setBorderPainted(false);
                b.setMargin(nullInsets);
            }
        }
        p3.setBorder(new TitledBorder("Crossings"));
    }

    private void setCrossings(int[][] c) {
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                this.crossings[row][col].setSelected(c[row][col] != 0);
            }
        }
    }

    private int[][] getCrossings() {
        int[][] c = new int[this.rows][];
        for (int row = 0; row < this.rows; ++row) {
            c[row] = new int[this.cols];
            for (int col = 0; col < this.cols; ++col) {
                c[row][col] = this.crossings[row][col].isSelected() ? 1 : 0;
            }
        }
        return c;
    }

    public void setObject(Object o) {
        super.setObject(o);
        this.filter = (WeaveFilter)o;
        this.xWidth.setValue((int)this.filter.getXWidth());
        this.yWidth.setValue((int)this.filter.getXWidth());
        this.xGap.setValue((int)this.filter.getXGap());
        this.yGap.setValue((int)this.filter.getYGap());
        this.setCrossings(this.filter.getCrossings());
        this.useImageColors.setSelected(this.filter.getUseImageColors());
        this.roundThreads.setSelected(this.filter.getRoundThreads());
        this.shadeCrossings.setSelected(this.filter.getShadeCrossings());
    }

    public void stateChanged(ChangeEvent e) {
        if (this.filter != null) {
            Object source = e.getSource();
            if (source instanceof JSlider && ((JSlider)source).getValueIsAdjusting()) {
                return;
            }
            if (source == this.xWidth) {
                this.filter.setXWidth(this.xWidth.getValue());
            } else if (source == this.yWidth) {
                this.filter.setYWidth(this.yWidth.getValue());
            } else if (source == this.xGap) {
                this.filter.setXGap(this.xGap.getValue());
            } else if (source == this.yGap) {
                this.filter.setYGap(this.yGap.getValue());
            } else if (source == this.useImageColors) {
                this.filter.setUseImageColors(this.useImageColors.isSelected());
            } else if (source == this.roundThreads) {
                this.filter.setRoundThreads(this.roundThreads.isSelected());
            } else if (source == this.shadeCrossings) {
                this.filter.setShadeCrossings(this.shadeCrossings.isSelected());
            } else {
                this.filter.setCrossings(this.getCrossings());
            }
            this.preview();
        }
    }

    class CrossIcon
    implements Icon {
        private boolean horizontal;

        public CrossIcon(boolean horizontal) {
            this.horizontal = horizontal;
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(4.0f));
            g2d.setColor(Color.darkGray);
            if (this.horizontal) {
                g.drawLine(8, 0, 8, 16);
            } else {
                g.drawLine(0, 8, 16, 8);
            }
            g2d.setColor(Color.lightGray);
            if (this.horizontal) {
                g.drawLine(0, 8, 16, 8);
            } else {
                g.drawLine(8, 0, 8, 16);
            }
        }
    }
}

