/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.arw;

import it.tidalwave.imageio.arw.ARWMakerNote;
import it.tidalwave.imageio.arw.ARWMetadata;
import it.tidalwave.imageio.arw.ARWPrimaryIFD;
import it.tidalwave.imageio.arw.ARWRasterReader;
import it.tidalwave.imageio.minolta.MinoltaRawData;
import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.spi.ImageReaderSpi;

public class ARWImageReader
extends TIFFImageReaderSupport {
    private static final String CLASS = ARWImageReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected ARWImageReader(@Nonnull ImageReaderSpi originatingProvider, @CheckForNull Object extension) {
        super(originatingProvider, ARWMakerNote.class, ARWMetadata.class);
    }

    @Nonnull
    protected IFD createPrimaryIFD() {
        return new ARWPrimaryIFD();
    }

    @Nonnull
    protected WritableRaster loadRAWRaster() throws IOException {
        logger.fine("loadRAWRaster() - iis: %s", this.iis);
        long time = System.currentTimeMillis();
        ARWRasterReader rasterReader = new ARWRasterReader();
        this.initializeRasterReader(rasterReader);
        logger.finest(">>>> using rasterReader: %s", rasterReader);
        WritableRaster raster = rasterReader.loadRaster(this.iis, this);
        logger.finer(">>>> loadRAWRaster() completed ok in %d msec.", System.currentTimeMillis() - time);
        return raster;
    }

    protected void initializeRasterReader(@Nonnull RasterReader rasterReader) {
        ARWMetadata arwMetadata = (ARWMetadata)this.metadata;
        MinoltaRawData.PRD prd = arwMetadata.getMinoltaRawData().getPRD();
        int bitsPerSample = prd.getPixelSize();
        rasterReader.setRasterOffset(((ARWPrimaryIFD)this.primaryDirectory).getRasterOffset());
        rasterReader.setTileOffsets(new int[1]);
        rasterReader.setCompression(1);
        rasterReader.setWidth(prd.getCcdSize().width);
        rasterReader.setHeight(prd.getCcdSize().height);
        rasterReader.setBitsPerSample(bitsPerSample);
        rasterReader.setCFAPattern(new byte[]{0, 1, 1, 2});
    }
}

