/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.cr2;

import it.tidalwave.imageio.cr2.CR2SensorInfo;
import it.tidalwave.imageio.cr2.CanonCR2MakerNoteSupport;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CanonCR2MakerNote
extends CanonCR2MakerNoteSupport {
    private static final String CLASS = CanonCR2MakerNote.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static Properties lensNameByID = new Properties();
    private static final long serialVersionUID = 6347805638960118907L;
    @CheckForNull
    private transient CR2SensorInfo sensorInfo;

    @Nonnull
    public synchronized CR2SensorInfo getSensorInfo() {
        if (this.sensorInfo == null) {
            this.sensorInfo = new CR2SensorInfo(this.getSensorInfoAsIntegers());
        }
        return this.sensorInfo;
    }

    @Nonnegative
    public int getLensType() {
        return 0;
    }

    @Nonnull
    public String getLensName() {
        return lensNameByID.getProperty("" + this.getLensType());
    }

    @Nonnull
    public String getOwnerName() {
        String artist = super.getOwnerName();
        int i = artist.indexOf(0);
        if (i >= 0) {
            artist = artist.substring(0, i);
        }
        return artist;
    }

    @Nonnull
    public short[] getWhiteBalanceCoefficients() {
        int[] wbi = this.getWhiteBalanceInfo();
        short[] coefficients = new short[4];
        if (wbi != null) {
            int offset;
            switch (wbi.length) {
                case 582: {
                    offset = 25;
                    break;
                }
                case 653: {
                    offset = 34;
                    break;
                }
                default: {
                    offset = 63;
                }
            }
            for (int i = 0; i < coefficients.length; ++i) {
                coefficients[i] = (short)wbi[offset + i];
            }
            logger.finer(">>>> wb coefficients: %s - read at %d, wbi.length: %d", Arrays.toString(coefficients), offset, wbi.length);
        }
        return coefficients;
    }

    static {
        try {
            InputStream is = CanonCR2MakerNote.class.getResourceAsStream("CanonLens.properties");
            lensNameByID.load(is);
            is.close();
        }
        catch (IOException e) {
            logger.warning("Can't load CanonLens.properties: %s", e);
            logger.throwing(CLASS, "", e);
        }
    }
}

