/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.decoder;

import it.tidalwave.imageio.decoder.HuffmannDecoder;
import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.imageio.stream.ImageInputStream;

public class LosslessJPEGDecoder {
    private static final String CLASS = LosslessJPEGDecoder.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final int BYTE_MASK = 255;
    private static final int SHORT_MASK = 65535;
    @Nonnegative
    private int bitsPerSample;
    @Nonnegative
    private int height;
    @Nonnegative
    private int width;
    @Nonnegative
    private int channelCount;
    @Nonnegative
    private int rowSize;
    private int[] vPredictors;
    private HuffmannDecoder[] decoders;
    private short[] rowBuffer;

    /*
     * Enabled aggressive block sorting
     */
    public void reset(@Nonnull ImageInputStream iis) throws IOException {
        short magic = iis.readShort();
        if (magic != -40) {
            throw new RuntimeException("Bad magic: " + Integer.toHexString(magic & 0xFFFF));
        }
        HuffmannDecoder[] dcTables = new HuffmannDecoder[4];
        while (true) {
            short tag = iis.readShort();
            int length = iis.readShort() - 2;
            logger.finer(">>>> tag: %x length: %d", tag & 0xFFFF, length);
            if ((tag & 0xFFFF) <= 65280) throw new RuntimeException("Bad tag:" + Integer.toHexString(tag & 0xFFFF));
            if (length > 255) {
                throw new RuntimeException("Bad tag:" + Integer.toHexString(tag & 0xFFFF));
            }
            switch (tag) {
                case -61: {
                    this.bitsPerSample = iis.readByte() & 0xFF;
                    this.height = iis.readShort() & 0xFFFF;
                    this.width = iis.readShort() & 0xFFFF;
                    this.channelCount = iis.readByte() & 0xFF;
                    this.rowSize = this.width * this.channelCount;
                    iis.skipBytes(length - 6);
                    this.rowBuffer = new short[this.rowSize];
                    this.vPredictors = new int[this.channelCount];
                    for (int i = 0; i < this.channelCount; ++i) {
                        this.vPredictors[i] = 1 << this.bitsPerSample - 1;
                    }
                    logger.fine("bitsPerSample: %d, height: %d, width: %d, channelCount: %d", this.bitsPerSample, this.height, this.rowSize, this.channelCount);
                    break;
                }
                case -60: {
                    int decoderLen;
                    byte[] data = new byte[length];
                    iis.readFully(data);
                    for (int scan = 0; scan < length && data[scan] < 4; scan += decoderLen) {
                        byte channel = data[scan++];
                        decoderLen = 16;
                        for (int q = scan; q < scan + 16; decoderLen += data[q], ++q) {
                        }
                        byte[] temp = new byte[decoderLen];
                        System.arraycopy(data, scan, temp, 0, temp.length);
                        dcTables[channel] = HuffmannDecoder.createDecoderWithJpegHack(temp, 0);
                        logger.fine("Decoder[%d] = %s", channel, dcTables[channel]);
                    }
                    break;
                }
                case -38: {
                    int channels = iis.readUnsignedByte();
                    this.decoders = new HuffmannDecoder[channels];
                    int i = 0;
                    while (true) {
                        if (i >= channels) {
                            iis.skipBytes(3);
                            return;
                        }
                        int index = iis.readUnsignedByte();
                        int dcac = iis.readUnsignedByte();
                        int dc = dcac >> 4;
                        int ac = dcac & 0xF;
                        logger.fine("Decoder index=%d, DC table=%d, AC table=%d", index, dc, ac);
                        this.decoders[index - 1] = dcTables[dc];
                        ++i;
                    }
                }
            }
        }
    }

    @Nonnull
    public short[] loadRow(@Nonnull RAWImageInputStream iis) throws IOException {
        int scan = 0;
        for (int x = 0; x < this.width; ++x) {
            for (int c = 0; c < this.channelCount; ++c) {
                int n;
                HuffmannDecoder decoder = this.decoders[c];
                int bitCount = decoder.decode(iis);
                int diff = decoder.readSignedBits(iis, bitCount);
                if (x == 0) {
                    int n2 = c;
                    n = this.vPredictors[n2] = this.vPredictors[n2] + diff;
                } else {
                    n = this.rowBuffer[scan - this.channelCount] + diff;
                }
                this.rowBuffer[scan] = (short)n;
                ++scan;
            }
        }
        return this.rowBuffer;
    }
}

