/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.nef;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.nef.NEFCompressionData;
import it.tidalwave.imageio.nef.NEFWhiteBalanceInfo;
import it.tidalwave.imageio.nef.Nikon3MakerNoteSupport;
import it.tidalwave.imageio.nef.NikonLensInfo;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class NikonMakerNote3
extends Nikon3MakerNoteSupport {
    private static final long serialVersionUID = -802326201633669892L;
    private static final String CLASS = NikonMakerNote3.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private transient NikonLensInfo lensInfo;
    private transient NEFCompressionData nefCompressionData;
    private boolean bigEndian;

    public void loadAll(@Nonnull RAWImageInputStream iis, long offset) throws IOException {
        iis.seek(offset);
        long baseOffsetSave = iis.getBaseOffset();
        ByteOrder byteOrderSave = iis.getByteOrder();
        iis.setBaseOffset(0L);
        offset = iis.getStreamPosition();
        byte[] buffer = new byte[10];
        iis.readFully(buffer);
        String s = new String(buffer);
        if (s.startsWith("Nikon")) {
            iis.setBaseOffset(iis.getStreamPosition());
            offset = TIFFImageReaderSupport.processHeader(iis, null);
        }
        this.bigEndian = iis.getByteOrder() == ByteOrder.BIG_ENDIAN;
        super.loadAll(iis, offset);
        iis.setBaseOffset(baseOffsetSave);
        iis.setByteOrder(byteOrderSave);
    }

    @Nonnull
    public NikonLensInfo getLensInfo2() {
        if (this.lensInfo == null && this.isLensInfoAvailable()) {
            this.lensInfo = new NikonLensInfo(this.getLensInfo());
        }
        return this.lensInfo;
    }

    public boolean isLensNameAvailable() {
        NikonLensInfo lensInfo = this.getLensInfo2();
        return lensInfo != null && lensInfo.getLensName() != null;
    }

    @Nonnull
    public String getLensName() {
        if (!this.isLensNameAvailable()) {
            throw new NoSuchElementException();
        }
        return this.getLensInfo2().getLensName();
    }

    @Nonnull
    public synchronized NEFCompressionData getCompressionDataObject() {
        if (this.nefCompressionData == null) {
            this.nefCompressionData = new NEFCompressionData(this);
        }
        return this.nefCompressionData;
    }

    @CheckForNull
    public NEFWhiteBalanceInfo getWhiteBalanceInfo() {
        return this.isBlock151Available() ? new NEFWhiteBalanceInfo(this, this.bigEndian) : null;
    }

    @Nonnull
    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        if (this.isLensInfoAvailable()) {
            buffer.append("\n>>>>LensInfo:" + this.getLensInfo2());
        }
        return buffer.toString();
    }
}

