/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.srf;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.srf.SRFImageInputStream;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;

public class SRFRasterReader
extends RasterReader {
    private int rasterKey;

    public void setRasterKey(int rasterKey) {
        this.rasterKey = rasterKey;
    }

    protected boolean isCompressedRaster() {
        return false;
    }

    protected void loadUncompressedRaster(RAWImageInputStream iis, WritableRaster raster, RAWImageReaderSupport ir) throws IOException {
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int pixelStride = 3;
        iis.seek(this.rasterOffset);
        int scan = 0;
        iis.setByteOrder(ByteOrder.BIG_ENDIAN);
        ((SRFImageInputStream)iis).setDecryptionKey(this.rasterKey);
        for (int y = 0; y < height; ++y) {
            ((SRFImageInputStream)iis).startEncryptedSection(width * 2);
            for (int x = 0; x < width; ++x) {
                int cfaIndex = 2 * (y & 1) + (x & 1);
                data[scan + this.cfaOffsets[cfaIndex]] = iis.readShort();
                scan += pixelStride;
            }
            ir.processImageProgress(100.0f * (float)y / (float)height);
            ((SRFImageInputStream)iis).stopEncryptedSection();
        }
    }
}

