/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.tiff;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.HeaderProcessor;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.raw.RAWMetadataSupport;
import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.tiff.ThumbnailLoader;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteOrder;
import javax.annotation.Nonnegative;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public abstract class TIFFImageReaderSupport
extends RAWImageReaderSupport {
    private static final String CLASS = TIFFImageReaderSupport.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final short TIFF_MAGIC = 42;
    private static final short TIFF_LITTLE_ENDIAN = 18761;
    private static final short TIFF_BIG_ENDIAN = 19789;
    protected Class makerNoteClass;
    private Class metadataClass;

    protected TIFFImageReaderSupport(ImageReaderSpi originatingProvider, Class makerNoteClass, Class metadataClass) {
        super(originatingProvider);
        this.makerNoteClass = makerNoteClass;
        this.metadataClass = metadataClass;
    }

    public int getWidth(@Nonnegative int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        this.ensureMetadataIsLoaded(imageIndex);
        return ((TIFFMetadataSupport)this.metadata).getWidth();
    }

    public final int getHeight(@Nonnegative int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        this.ensureMetadataIsLoaded(imageIndex);
        return ((TIFFMetadataSupport)this.metadata).getHeight();
    }

    public final int getNumThumbnails(@Nonnegative int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        this.ensureMetadataIsLoaded(imageIndex);
        ThumbnailLoader[] thumbnailInfo = ((TIFFMetadataSupport)this.metadata).getThumbnailHelper();
        return thumbnailInfo.length;
    }

    public int getThumbnailWidth(int imageIndex, int thumbnailIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        this.ensureMetadataIsLoaded(imageIndex);
        this.checkThumbnailIndex(thumbnailIndex);
        return ((TIFFMetadataSupport)this.metadata).getThumbnailWidth(thumbnailIndex);
    }

    public int getThumbnailHeight(int imageIndex, int thumbnailIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        this.ensureMetadataIsLoaded(imageIndex);
        this.checkThumbnailIndex(thumbnailIndex);
        return ((TIFFMetadataSupport)this.metadata).getThumbnailHeight(thumbnailIndex);
    }

    protected BufferedImage loadThumbnail(int imageIndex, int thumbnailIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        this.ensureMetadataIsLoaded(imageIndex);
        this.checkThumbnailIndex(thumbnailIndex);
        ThumbnailLoader[] thumbnailInfo = ((TIFFMetadataSupport)this.metadata).getThumbnailHelper();
        return thumbnailInfo[thumbnailIndex].load(this.iis);
    }

    protected BufferedImage loadImage(int imageIndex) throws IOException {
        logger.fine("loadImage(%d) - iis: %s", imageIndex, this.iis);
        this.checkImageIndex(imageIndex);
        this.ensureMetadataIsLoaded(imageIndex);
        BufferedImage image = this.loadRAWImage();
        logger.fine(">>>> loadImage() completed ok, returning %s", image);
        return image;
    }

    public static long processHeader(ImageInputStream iis, HeaderProcessor headerProcessor) throws IOException {
        int fileOffset = 0;
        logger.fine("processHeader(%s, %s)", iis, headerProcessor);
        if (headerProcessor != null) {
            fileOffset = headerProcessor.getOffset();
        }
        iis.skipBytes(fileOffset);
        logger.finest(">>>> reading byte order at %d", iis.getStreamPosition());
        TIFFImageReaderSupport.setByteOrder(iis);
        short magic = iis.readShort();
        if (magic < 42) {
            throw new IOException("Invalid magic: " + magic);
        }
        long offset = iis.readUnsignedInt() + (long)fileOffset;
        logger.finer(">>>> processHeader() returning offset is %d", offset);
        return offset;
    }

    public static void setByteOrder(ImageInputStream iis) throws IOException {
        short byteOrder = iis.readShort();
        if (byteOrder == 18761) {
            iis.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else if (byteOrder == 19789) {
            iis.setByteOrder(ByteOrder.BIG_ENDIAN);
        } else {
            throw new IOException("Invalid byte order: 0x" + Integer.toHexString(byteOrder));
        }
        logger.finer(">>>> Byte order is %s", iis.getByteOrder());
    }

    protected void initializeRasterReader(int width, int height, int bitsPerSample, RasterReader rasterReader) {
        IFD rasterIFD = ((TIFFMetadataSupport)this.metadata).getRasterIFD();
        IFD exifIFD = ((TIFFMetadataSupport)this.metadata).getExifIFD();
        rasterReader.setWidth(width);
        rasterReader.setHeight(height);
        rasterReader.setBitsPerSample(bitsPerSample);
        if (exifIFD.isEXIFCFAPatternAvailable()) {
            rasterReader.setCFAPattern(exifIFD.getEXIFCFAPattern());
        }
        if (rasterIFD != null && rasterIFD.isCFAPatternAvailable()) {
            rasterReader.setCFAPattern(rasterIFD.getCFAPattern());
        }
        if (rasterIFD != null && rasterIFD.isCompressionAvailable()) {
            rasterReader.setCompression(rasterIFD.getCompression().intValue());
        }
        if (rasterIFD != null && rasterIFD.isStripByteCountsAvailable()) {
            rasterReader.setStripByteCount(rasterIFD.getStripByteCounts());
        }
        if (rasterIFD != null && rasterIFD.isTileWidthAvailable()) {
            int imageWidth = rasterIFD.getImageWidth();
            int imageLength = rasterIFD.getImageLength();
            int tileWidth = rasterIFD.getTileWidth();
            int tileLength = rasterIFD.getTileLength();
            rasterReader.setTileWidth(tileWidth);
            rasterReader.setTileHeight(tileLength);
            rasterReader.setTilesAcross((imageWidth + tileWidth - 1) / tileWidth);
            rasterReader.setTilesDown((imageLength + tileLength - 1) / tileLength);
            rasterReader.setTileOffsets(rasterIFD.getTileOffsets());
        }
        if (rasterIFD != null && rasterIFD.isLinearizationTableAvailable()) {
            rasterReader.setLinearizationTable(rasterIFD.getLinearizationTable());
        }
    }

    protected Directory loadPrimaryDirectory() throws IOException {
        logger.fine("loadPrimaryDirectory() - %s", this.iis);
        this.headerProcessor.process(this.iis);
        this.iis.seek(0L);
        long directoryOffset = TIFFImageReaderSupport.processHeader(this.iis, this.headerProcessor);
        if (directoryOffset == 20L) {
            directoryOffset -= 12L;
            this.iis.setBaseOffset(12L);
        }
        IFD primaryIFD = this.createPrimaryIFD();
        primaryIFD.loadAll(this.iis, directoryOffset);
        return primaryIFD;
    }

    protected IFD createPrimaryIFD() {
        return new IFD();
    }

    protected RAWMetadataSupport createMetadata(Directory primaryDirectory, Directory imageDirectory) {
        try {
            Constructor constructor = this.metadataClass.getConstructor(Directory.class, RAWImageInputStream.class, HeaderProcessor.class);
            return (RAWMetadataSupport)constructor.newInstance(primaryDirectory, this.iis, this.headerProcessor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void processMetadata() throws IOException {
        this.primaryDirectory = this.loadPrimaryDirectory();
        logger.fine(">>>> primary directory: %s", this.primaryDirectory);
        this.processEXIFAndMakerNote(this.primaryDirectory);
        this.metadata = this.createMetadata(this.primaryDirectory, null);
    }

    protected void processEXIFAndMakerNote(Directory directory) throws IOException {
        if (((IFD)directory).isExifIFDPointerAvailable()) {
            IFD exifIFD = new IFD();
            exifIFD.loadAll(this.iis, ((IFD)directory).getExifIFDPointer());
            directory.addNamedDirectory("EXIF", exifIFD);
            logger.fine("EXIF IFD: %s", exifIFD);
            if (exifIFD.isMakerNoteAvailable()) {
                this.processMakerNote();
            }
            if (exifIFD.isInteroperabilityIFDAvailable()) {
                IFD interoperabilityIFD = new IFD();
                interoperabilityIFD.loadAll(this.iis, exifIFD.getInteroperabilityIFD());
                exifIFD.addNamedDirectory("INTEROPERABILITY", interoperabilityIFD);
                logger.fine("INTEROPERABILITY IFD: %s", interoperabilityIFD);
            }
        }
        if (((IFD)directory).isGPSInfoIFDPointerAvailable()) {
            IFD gpsIFD = new IFD();
            gpsIFD.loadAll(this.iis, ((IFD)directory).getGPSInfoIFDPointer());
            directory.addNamedDirectory("GPS", gpsIFD);
            logger.fine("GPS IFD: %s", gpsIFD);
        }
    }

    protected void processMakerNote() throws IOException {
        logger.fine("processMakerNote()", new Object[0]);
        try {
            this.makerNote = (Directory)this.makerNoteClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.finer(">>>> makerNote class: %s", this.makerNoteClass);
        IFD exifIFD = (IFD)this.primaryDirectory.getNamedDirectory("EXIF");
        int makerNoteOffset = exifIFD.getMakerNoteOffset();
        this.makerNote.loadAll(this.iis, makerNoteOffset);
        exifIFD.addNamedDirectory("MakerNote", this.makerNote);
        logger.fine("MakerNote: %s", this.makerNote);
    }

    protected void checkThumbnailIndex(int thumbnailIndex) throws IOException {
        if (thumbnailIndex >= this.getNumThumbnails(0)) {
            throw new IndexOutOfBoundsException("Invalid thumbnail index: " + thumbnailIndex);
        }
    }
}

