/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class HttpServlet
extends GenericServlet
implements Serializable {
    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        this.service(httpServletRequest, httpServletResponse);
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        boolean bl = false;
        if (string.equals("GET") || (bl = string.equals("HEAD"))) {
            long l;
            long l2 = this.getLastModified(httpServletRequest);
            if (l2 <= 0L) {
                if (bl) {
                    this.doHead(httpServletRequest, httpServletResponse);
                } else {
                    this.doGet(httpServletRequest, httpServletResponse);
                }
                return;
            }
            char[] cArray = null;
            String string2 = httpServletRequest.getHeader("If-None-Match");
            if (string2 != null) {
                cArray = HttpServlet.generateETag(l2);
                int n = string2.length();
                if (n == cArray.length) {
                    --n;
                    while (n >= 0 && string2.charAt(n) == cArray[n]) {
                        --n;
                    }
                }
                if (n < 0) {
                    httpServletResponse.sendError(304);
                    return;
                }
            }
            if (l2 / 1000L == (l = httpServletRequest.getDateHeader("If-Modified-Since")) / 1000L) {
                httpServletResponse.sendError(304);
                return;
            }
            if (cArray == null) {
                cArray = HttpServlet.generateETag(l2);
            }
            httpServletResponse.setHeader("ETag", new String(cArray));
            httpServletResponse.setDateHeader("Last-Modified", l2);
            if (bl) {
                this.doHead(httpServletRequest, httpServletResponse);
            } else {
                this.doGet(httpServletRequest, httpServletResponse);
            }
        } else if (string.equals("POST")) {
            this.doPost(httpServletRequest, httpServletResponse);
        } else if (string.equals("PUT")) {
            this.doPut(httpServletRequest, httpServletResponse);
        } else if (string.equals("DELETE")) {
            this.doDelete(httpServletRequest, httpServletResponse);
        } else if (string.equals("OPTIONS")) {
            this.doOptions(httpServletRequest, httpServletResponse);
        } else if (string.equals("TRACE")) {
            this.doTrace(httpServletRequest, httpServletResponse);
        } else {
            httpServletResponse.sendError(501, "Method not implemented");
        }
    }

    private static char[] generateETag(long l) {
        char[] cArray = new char[]{'\"', HttpServlet.encodeBase64(l >> 60), HttpServlet.encodeBase64(l >> 54), HttpServlet.encodeBase64(l >> 48), HttpServlet.encodeBase64(l >> 42), HttpServlet.encodeBase64(l >> 36), HttpServlet.encodeBase64(l >> 30), HttpServlet.encodeBase64(l >> 24), HttpServlet.encodeBase64(l >> 18), HttpServlet.encodeBase64(l >> 12), HttpServlet.encodeBase64(l >> 6), HttpServlet.encodeBase64(l), '\"'};
        return cArray;
    }

    private static char encodeBase64(long l) {
        if ((l &= 0x3FL) < 26L) {
            return (char)(l + 65L);
        }
        if (l < 52L) {
            return (char)(l + 97L - 26L);
        }
        if (l < 62L) {
            return (char)(l + 48L - 52L);
        }
        if (l == 62L) {
            return '+';
        }
        return '/';
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        return -1L;
    }

    protected void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = httpServletRequest.getMethod() + " not supported";
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = httpServletRequest.getMethod() + " not supported";
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = httpServletRequest.getMethod() + " not supported";
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = httpServletRequest.getMethod() + " not supported";
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = httpServletRequest.getMethod() + " not supported";
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    protected void doTrace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = httpServletRequest.getMethod() + " not supported";
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }
}

